/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portlet.PortletRequestDispatcherImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContextImpl
implements PortletContext {
    private static int _MAJOR_VERSION = 2;
    private static int _MINOR_VERSION = 0;
    private static Log _log = LogFactoryUtil.getLog(PortletContextImpl.class);
    private Portlet _portlet;
    private ServletContext _servletContext;
    private String _servletContextName;

    public PortletContextImpl(Portlet portlet, ServletContext servletContext) {
        this._portlet = portlet;
        this._servletContext = servletContext;
        this._servletContextName = GetterUtil.getString((String)this._servletContext.getServletContextName());
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this._servletContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._servletContext.getAttributeNames();
    }

    public Enumeration<String> getContainerRuntimeOptions() {
        return null;
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this._servletContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this._servletContext.getInitParameterNames();
    }

    public int getMajorVersion() {
        return _MAJOR_VERSION;
    }

    public String getMimeType(String file) {
        return this._servletContext.getMimeType(file);
    }

    public int getMinorVersion() {
        return _MINOR_VERSION;
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher requestDispatcher = null;
        try {
            requestDispatcher = this._servletContext.getNamedDispatcher(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (requestDispatcher != null) {
            return new PortletRequestDispatcherImpl(requestDispatcher, true, this);
        }
        return null;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public String getPortletContextName() {
        return this._servletContextName;
    }

    public String getRealPath(String path) {
        return this._servletContext.getRealPath(path);
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher requestDispatcher = null;
        try {
            requestDispatcher = this._servletContext.getRequestDispatcher(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (requestDispatcher != null) {
            return new PortletRequestDispatcherImpl(requestDispatcher, false, this, path);
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException();
        }
        return this._servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this._servletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this._servletContext.getResourcePaths(path);
    }

    public String getServerInfo() {
        return ReleaseInfo.getServerInfo();
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public boolean isWARFile() {
        PortletApp portletApp = this._portlet.getPortletApp();
        return portletApp.isWARFile();
    }

    public void log(String msg) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)msg);
        }
    }

    public void log(String msg, Throwable throwable) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)msg, throwable);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._servletContext.setAttribute(name, obj);
    }
}

