/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import java.util.List;

public class VerifyDocumentLibrary
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDocumentLibrary.class);

    protected void doVerify() throws Exception {
        List fileEntries = DLFileEntryLocalServiceUtil.getNoAssetFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + fileEntries.size() + " file entries with no asset"));
        }
        for (DLFileEntry fileEntry : fileEntries) {
            try {
                DLFileEntryLocalServiceUtil.updateAsset((long)fileEntry.getUserId(), (DLFileEntry)fileEntry, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for file entry " + fileEntry.getFileEntryId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for file entries");
        }
    }
}

