/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.velocity.VelocityResourceListener;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class LiferayResourceLoader
extends ResourceLoader {
    private static Log _log = LogFactoryUtil.getLog(LiferayResourceLoader.class);
    private static VelocityResourceListener[] _listeners = new VelocityResourceListener[0];

    public static void setListeners(String[] listeners) {
        _listeners = new VelocityResourceListener[listeners.length];
        int i = 0;
        while (i < listeners.length) {
            try {
                LiferayResourceLoader._listeners[i] = (VelocityResourceListener)Class.forName(listeners[i]).newInstance();
            }
            catch (Exception ex) {
                _log.error((Throwable)ex);
                LiferayResourceLoader._listeners[i] = null;
            }
            ++i;
        }
    }

    public long getLastModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get last modified for " + resource.getName()));
        }
        return 0L;
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get resource for " + source));
        }
        InputStream is = null;
        int i = 0;
        while (is == null && i < _listeners.length) {
            if (_listeners[i] != null) {
                is = _listeners[i].getResourceStream(source);
            }
            ++i;
        }
        if (is == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Could not find " + source));
            }
            throw new ResourceNotFoundException(source);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Successfully got " + source));
        }
        return is;
    }

    public void init(ExtendedProperties props) {
        boolean cachingOn = GetterUtil.getBoolean((String)PropsUtil.get("velocity.engine.resource.manager.cache.enabled"));
        int modificationCheckInterval = GetterUtil.getInteger((String)PropsUtil.get("velocity.engine.resource.manager.modification.check.interval"));
        this.setCachingOn(cachingOn);
        this.setModificationCheckInterval(modificationCheckInterval);
    }

    public boolean isSourceModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check modified status for " + resource.getName()));
        }
        return false;
    }
}

