/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MultiValueMap;
import com.liferay.portal.kernel.util.SerializableUtil;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMultiValueMap<K extends Serializable, V extends Serializable>
extends MultiValueMap<K, V> {
    private static final String _CREATE_SQL = "CREATE TABLE Map (key_ BLOB not null, value_ BLOB not null, primary key (key_, value_))";
    private static final String _KEY = "key_";
    private static final String _VALUE = "value_";
    private String _fileName = FileUtil.createTempFileName();

    public FileMultiValueMap() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._createDatabase();
    }

    public void clear() {
        try {
            this._deleteDatabase();
            this._createDatabase();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean containsKey(Object key) {
        int count = this._getCount((Serializable)key, null);
        return count > 0;
    }

    public boolean containsValue(Object value) {
        int count = this._getCount(null, (Serializable)value);
        return count > 0;
    }

    public Set<V> getAll(Object key) {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<Serializable> values = null;
        try {
            try {
                con = this._getConnection();
                ps = con.prepareStatement("SELECT value_ FROM Map WHERE key_ = ?");
                ps.setBytes(1, SerializableUtil.serialize((Object)key));
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (values == null) {
                        values = new HashSet<Serializable>();
                    }
                    Serializable value = null;
                    value = (Serializable)SerializableUtil.deserialize((byte[])rs.getBytes(_VALUE));
                    values.add(value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return values;
    }

    public boolean isEmpty() {
        int count = this._getCount(null, null);
        return count == 0;
    }

    public Set<K> keySet() {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<Serializable> keys = null;
        try {
            try {
                con = this._getConnection();
                ps = con.prepareStatement("SELECT DISTINCT (key_) FROM Map ");
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (keys == null) {
                        keys = new HashSet<Serializable>();
                    }
                    Serializable key = null;
                    key = (Serializable)SerializableUtil.deserialize((byte[])rs.getBytes(_KEY));
                    keys.add(key);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return keys;
    }

    public V put(K key, V value) {
        if (key == null || value == null) {
            return null;
        }
        if (this._getCount(key, value) == 0) {
            Connection con = null;
            PreparedStatement ps = null;
            try {
                try {
                    con = this._getConnection();
                    ps = con.prepareStatement("INSERT INTO Map (key_, value_) values (?, ?)");
                    ps.setBytes(1, SerializableUtil.serialize(key));
                    ps.setBytes(2, SerializableUtil.serialize(value));
                    ps.execute();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps);
        }
        return value;
    }

    public Set<V> putAll(K key, Collection<? extends V> values) {
        Set<V> curValues = this.getAll(key);
        if (values == null || values.isEmpty()) {
            return curValues;
        }
        if (curValues == null) {
            values = new HashSet<V>();
        }
        for (Serializable value : values) {
            if (curValues.contains(value)) continue;
            curValues.add(value);
            this.put(key, (V)value);
        }
        return curValues;
    }

    public V remove(Object key) {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Serializable firstValue = null;
        try {
            try {
                con = this._getConnection();
                ps = con.prepareStatement("SELECT value_ FROM Map WHERE key_ = ?");
                ps.setBytes(1, SerializableUtil.serialize((Object)key));
                rs = ps.executeQuery();
                if (rs.next()) {
                    firstValue = (Serializable)SerializableUtil.deserialize((byte[])rs.getBytes(_VALUE));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        try {
            try {
                con = this._getConnection();
                ps = con.prepareStatement("DELETE FROM Map WHERE key_ = ?");
                ps.setBytes(1, SerializableUtil.serialize((Object)key));
                ps.execute();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps);
        }
        return (V)firstValue;
    }

    protected void finalize() throws Throwable {
        try {
            this._deleteDatabase();
        }
        finally {
            super.finalize();
        }
    }

    private void _createDatabase() {
        Connection con = null;
        try {
            try {
                con = this._getConnection();
                DB db = DBFactoryUtil.getDB((String)"hypersonic");
                db.runSQL(con, _CREATE_SQL);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    private void _deleteDatabase() throws Throwable {
        File[] files;
        File[] fileArray = files = new File[]{new File(String.valueOf(this._fileName) + ".properties"), new File(String.valueOf(this._fileName) + ".script"), new File(String.valueOf(this._fileName) + ".log"), new File(String.valueOf(this._fileName) + ".data"), new File(String.valueOf(this._fileName) + ".backup")};
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                file.delete();
            }
            ++n2;
        }
    }

    private Connection _getConnection() throws Exception {
        return DriverManager.getConnection("jdbc:hsqldb:file:" + this._fileName, "sa", "");
    }

    private int _getCount(K key, V value) {
        int n;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this._getConnection();
            String sql = "SELECT count(*) FROM Map ";
            if (key != null && value != null) {
                sql = String.valueOf(sql) + "WHERE key_ = ? AND value_ = ?";
                ps = con.prepareStatement(sql);
                ps.setBytes(1, SerializableUtil.serialize(key));
                ps.setBytes(2, SerializableUtil.serialize(value));
            } else if (key != null) {
                sql = String.valueOf(sql) + "WHERE key_ = ?";
                ps = con.prepareStatement(sql);
                ps.setBytes(1, SerializableUtil.serialize(key));
            } else if (value != null) {
                sql = String.valueOf(sql) + "WHERE value_ = ?";
                ps = con.prepareStatement(sql);
                ps.setBytes(1, SerializableUtil.serialize(value));
            } else {
                ps = con.prepareStatement(sql);
            }
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return n;
    }
}

