/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public abstract class BaseUpgradePortletPreferences
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select * from Layout where plid = ?";
    private static final String _GET_LAYOUT_UUID = "select uuid_ from Layout where groupId = ? AND privateLayout = ? AND layoutId = ?";

    protected void deletePortletPreferences(long portletPreferencesId) throws Exception {
        this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
    }

    protected void doUpgrade() throws Exception {
        this.updatePortletPreferences();
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                boolean privateLayout = rs.getBoolean("privateLayout");
                long layoutId = rs.getLong("layoutId");
                layout = new Object[]{groupId, companyId, privateLayout, layoutId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return layout;
    }

    protected String getLayoutUuid(long plid, long layoutId) throws Exception {
        Object[] layout = this.getLayout(plid);
        if (layout == null) {
            return null;
        }
        String uuid = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT_UUID);
            long groupId = (Long)layout[0];
            boolean privateLayout = (Boolean)layout[2];
            ps.setLong(1, groupId);
            ps.setBoolean(2, privateLayout);
            ps.setLong(3, layoutId);
            rs = ps.executeQuery();
            if (rs.next()) {
                uuid = rs.getString("uuid_");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return uuid;
    }

    protected abstract String getUpdatePortletPreferencesWhereClause();

    protected void updatePortletPreferences() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where " + this.getUpdatePortletPreferencesWhereClause());
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = rs.getString("preferences");
                Object[] layout = this.getLayout(plid);
                if (layout != null) {
                    long companyId = (Long)layout[1];
                    String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
                    this.updatePortletPreferences(portletPreferencesId, newPreferences);
                    continue;
                }
                this.deletePortletPreferences(portletPreferencesId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePortletPreferences(long portletPreferencesId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected abstract String upgradePreferences(long var1, long var3, int var5, long var6, String var8, String var9) throws Exception;
}

