/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchWebDAVPropsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.WebDAVProps;
import com.liferay.portal.service.base.WebDAVPropsLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;

public class WebDAVPropsLocalServiceImpl
extends WebDAVPropsLocalServiceBaseImpl {
    public void deleteWebDAVProps(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        try {
            this.webDAVPropsPersistence.removeByC_C(classNameId, classPK);
        }
        catch (NoSuchWebDAVPropsException noSuchWebDAVPropsException) {}
    }

    public WebDAVProps getWebDAVProps(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        WebDAVProps webDavProps = this.webDAVPropsPersistence.fetchByC_C(classNameId, classPK);
        if (webDavProps == null) {
            webDavProps = this.webDAVPropsPersistence.create(this.counterLocalService.increment());
            Date now = new Date();
            webDavProps.setCompanyId(companyId);
            webDavProps.setCreateDate(now);
            webDavProps.setModifiedDate(now);
            webDavProps.setClassNameId(classNameId);
            webDavProps.setClassPK(classPK);
            this.webDAVPropsPersistence.update((BaseModel)webDavProps, false);
        }
        return webDavProps;
    }

    public void storeWebDAVProps(WebDAVProps webDavProps) throws PortalException, SystemException {
        try {
            webDavProps.store();
        }
        catch (Exception e) {
            throw new WebDAVException("Problem trying to store WebDAVProps", (Throwable)e);
        }
        this.webDAVPropsPersistence.update((BaseModel)webDavProps, true);
    }
}

