/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.ResourcePermissionLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePermissionLocalServiceImpl
extends ResourcePermissionLocalServiceBaseImpl {
    public void addResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        if (scope == 1) {
            this.removeResourcePermissions(companyId, name, 2, roleId, actionId);
        } else if (scope == 2) {
            this.removeResourcePermissions(companyId, name, 1, roleId, actionId);
        } else if (scope == 4) {
            throw new NoSuchResourcePermissionException();
        }
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, new String[]{actionId}, 1);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteResourcePermission(long resourcePermissionId) throws PortalException, SystemException {
        this.resourcePermissionPersistence.remove(resourcePermissionId);
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, long primKey) throws PortalException, SystemException {
        this.deleteResourcePermissions(companyId, name, scope, String.valueOf(primKey));
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.deleteResourcePermission(resourcePermission.getResourcePermissionId());
        }
    }

    public List<String> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, long roleId, List<String> actionIds) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> availableActionIds = new ArrayList<String>(actionIds.size());
        for (String actionId : actionIds) {
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            if (!this.hasActionId(resourcePermission, resourceAction)) continue;
            availableActionIds.add(actionId);
        }
        return availableActionIds;
    }

    public List<ResourcePermission> getResourcePermissions(long companyId, String name, int scope, String primKey) throws SystemException {
        return this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
    }

    public int getResourcePermissionsCount(long companyId, String name, int scope, String primKey) throws SystemException {
        return this.resourcePermissionPersistence.countByC_N_S_P(companyId, name, scope, primKey);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId) throws SystemException {
        return this.resourcePermissionPersistence.findByRoleId(roleId);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId, int[] scopes, int start, int end) throws SystemException {
        return this.resourcePermissionFinder.findByR_S(roleId, scopes, start, end);
    }

    public boolean hasActionId(ResourcePermission resourcePermission, ResourceAction resourceAction) {
        long bitwiseValue;
        long actionIds = resourcePermission.getActionIds();
        return (actionIds & (bitwiseValue = resourceAction.getBitwiseValue())) == bitwiseValue;
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return false;
        }
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        return this.hasActionId(resourcePermission, resourceAction);
    }

    public boolean hasScopeResourcePermission(long companyId, String name, int scope, long roleId, String actionId) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, name, scope);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.hasResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), roleId, actionId)) continue;
            return true;
        }
        return false;
    }

    public void mergePermissions(long fromRoleId, long toRoleId) throws PortalException, SystemException {
        Role fromRole = this.rolePersistence.findByPrimaryKey(fromRoleId);
        Role toRole = this.rolePersistence.findByPrimaryKey(toRoleId);
        if (fromRole.getType() != toRole.getType()) {
            throw new PortalException("Role types are mismatched");
        }
        if (PortalUtil.isSystemRole((String)toRole.getName())) {
            throw new PortalException("Cannot move permissions to system role");
        }
        if (PortalUtil.isSystemRole((String)fromRole.getName())) {
            throw new PortalException("Cannot move permissions from system role");
        }
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setRoleId(toRoleId);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission, false);
        }
        this.roleLocalService.deleteRole(fromRoleId);
        PermissionCacheUtil.clearCache();
    }

    public void reassignPermissions(long resourcePermissionId, long toRoleId) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.getResourcePermission(resourcePermissionId);
        long companyId = resourcePermission.getCompanyId();
        String name = resourcePermission.getName();
        int scope = resourcePermission.getScope();
        String primKey = resourcePermission.getPrimKey();
        long fromRoleId = resourcePermission.getRoleId();
        Role toRole = this.roleLocalService.getRole(toRoleId);
        List<String> actionIds = null;
        actionIds = toRole.getType() == 1 ? ResourceActionsUtil.getModelResourceActions(name) : ResourceActionsUtil.getModelResourceCommunityDefaultActions(name);
        this.setResourcePermissions(companyId, name, scope, primKey, toRoleId, actionIds.toArray(new String[actionIds.size()]));
        this.resourcePermissionPersistence.remove(resourcePermissionId);
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        if (resourcePermissions.isEmpty()) {
            this.roleLocalService.deleteRole(fromRoleId);
        }
    }

    public void removeResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, new String[]{actionId}, 2);
        PermissionCacheUtil.clearCache();
    }

    public void removeResourcePermissions(long companyId, String name, int scope, long roleId, String actionId) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, name, scope);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.updateResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), roleId, new String[]{actionId}, 2);
        }
        PermissionCacheUtil.clearCache();
    }

    public void setResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds) throws PortalException, SystemException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, actionIds, 3);
    }

    protected void doUpdateResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds, int operator) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        long oldActionIds = 0L;
        if (resourcePermission == null) {
            if (operator == 2 || actionIds.length == 0) {
                return;
            }
            long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
            resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
            resourcePermission.setCompanyId(companyId);
            resourcePermission.setName(name);
            resourcePermission.setScope(scope);
            resourcePermission.setPrimKey(primKey);
            resourcePermission.setRoleId(roleId);
        } else {
            oldActionIds = resourcePermission.getActionIds();
        }
        long actionIdsLong = resourcePermission.getActionIds();
        if (operator == 3) {
            actionIdsLong = 0L;
        }
        String[] stringArray = actionIds;
        int n = actionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            actionIdsLong = operator == 1 || operator == 3 ? (actionIdsLong |= resourceAction.getBitwiseValue()) : (actionIdsLong &= resourceAction.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL);
            ++n2;
        }
        if (oldActionIds == actionIdsLong) {
            return;
        }
        if (actionIdsLong == 0L) {
            this.resourcePermissionPersistence.remove((BaseModel)resourcePermission);
        } else {
            resourcePermission.setActionIds(actionIdsLong);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission, false);
        }
        PermissionCacheUtil.clearCache();
        SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
    }

    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds, int operator) throws PortalException, SystemException {
        DB db = DBFactoryUtil.getDB();
        if (!db.getType().equals("hypersonic")) {
            this.doUpdateResourcePermission(companyId, name, scope, primKey, roleId, actionIds, operator);
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append(companyId);
        sb.append("#");
        sb.append(name);
        sb.append("#");
        sb.append(scope);
        sb.append("#");
        sb.append(primKey);
        sb.append("#");
        sb.append(roleId);
        String groupName = this.getClass().getName();
        String key = sb.toString();
        Lock lock = LockRegistry.allocateLock((String)groupName, (String)key);
        lock.lock();
        try {
            this.doUpdateResourcePermission(companyId, name, scope, primKey, roleId, actionIds, operator);
        }
        finally {
            lock.unlock();
            LockRegistry.freeLock((String)groupName, (String)key);
        }
    }
}

