/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutSetServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;

public class LayoutSetServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetServiceHttp.class);

    public static void updateLogo(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, boolean logo, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetServiceUtil.class.getName(), "updateLogo", new Class[]{Long.TYPE, Boolean.TYPE, Boolean.TYPE, File.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, logo, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutSet updateLookAndFeel(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetServiceUtil.class.getName(), "updateLookAndFeel", new Class[]{Long.TYPE, Boolean.TYPE, String.class, String.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, themeId, colorSchemeId, css, wapTheme});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutSet)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutSet updateSettings(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, String settings) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetServiceUtil.class.getName(), "updateSettings", new Class[]{Long.TYPE, Boolean.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, settings});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutSet)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutSet updateVirtualHost(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, String virtualHost) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetServiceUtil.class.getName(), "updateVirtualHost", new Class[]{Long.TYPE, Boolean.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, virtualHost});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutSet)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

