/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.AdvancedPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;

public class SearchPermissionCheckerImpl
implements SearchPermissionChecker {
    private static Log _log = LogFactoryUtil.getLog(SearchPermissionCheckerImpl.class);

    public void addPermissionFields(long companyId, Document doc) {
        try {
            long groupId = GetterUtil.getLong((String)doc.get("groupId"));
            String className = doc.get("entryClassName");
            String classPK = doc.get("rootEntryClassPK");
            if (Validator.isNull((String)classPK)) {
                classPK = doc.get("entryClassPK");
            }
            if (Validator.isNotNull((String)className) && Validator.isNotNull((String)classPK)) {
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                    this.doAddPermissionFields_5(companyId, groupId, className, classPK, doc);
                } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    this.doAddPermissionFields_6(companyId, groupId, className, classPK, doc);
                }
            }
        }
        catch (NoSuchResourceException noSuchResourceException) {
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public Query getPermissionQuery(long companyId, long[] groupIds, long userId, String className, Query query) {
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                return this.doGetPermissionQuery_5(companyId, groupIds, userId, className, query);
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                return this.doGetPermissionQuery_6(companyId, groupIds, userId, className, query);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return query;
    }

    public void updatePermissionFields(long resourceId) {
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.doUpdatePermissionFields_5(resourceId);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updatePermissionFields(String resourceName, String resourceClassPK) {
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.doUpdatePermissionFields_6(resourceName, resourceClassPK);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void addRequiredMemberRole(Group group, BooleanQuery permissionQuery) throws Exception {
        if (group.isCommunity()) {
            Role communityMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Community Member");
            permissionQuery.addTerm("groupRoleId", String.valueOf(group.getGroupId()) + "-" + communityMemberRole.getRoleId());
        } else if (group.isOrganization()) {
            Role organizationMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Organization Member");
            permissionQuery.addTerm("groupRoleId", String.valueOf(group.getGroupId()) + "-" + organizationMemberRole.getRoleId());
        }
    }

    protected void doAddPermissionFields_5(long companyId, long groupId, String className, String classPK, Document doc) throws Exception {
        Resource resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)className, (int)4, (String)classPK);
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)groupId);
        }
        List<Role> roles = ResourceActionsUtil.getRoles(companyId, group, className);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        for (Role role : roles) {
            long roleId = role.getRoleId();
            if (!this.hasPermission(roleId, resource.getResourceId())) continue;
            if (role.getType() == 2 || role.getType() == 3) {
                groupRoleIds.add(String.valueOf(groupId) + "-" + roleId);
                continue;
            }
            roleIds.add(roleId);
        }
        doc.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
        doc.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
    }

    protected void doAddPermissionFields_6(long companyId, long groupId, String className, String classPK, Document doc) throws Exception {
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)groupId);
        }
        List<Role> roles = ResourceActionsUtil.getRoles(companyId, group, className);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        for (Role role : roles) {
            long roleId = role.getRoleId();
            if (!ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)4, (String)classPK, (long)roleId, (String)"VIEW")) continue;
            if (role.getType() == 2 || role.getType() == 3) {
                groupRoleIds.add(String.valueOf(groupId) + "-" + roleId);
                continue;
            }
            roleIds.add(roleId);
        }
        doc.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
        doc.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
    }

    protected Query doGetPermissionQuery_5(long companyId, long[] groupIds, long userId, String className, Query query) throws Exception {
        PermissionCheckerBag bag = this.getUserBag(userId);
        ArrayList<Group> groups = new ArrayList<Group>();
        List roles = bag.getRoles();
        List userGroupRoles = new ArrayList();
        if (groupIds == null || groupIds.length == 0) {
            groups.addAll(GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true));
            groups.addAll(bag.getGroups());
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId);
        } else {
            long[] lArray = groupIds;
            int n = groupIds.length;
            int n2 = 0;
            while (n2 < n) {
                long groupId = lArray[n2];
                if (GroupLocalServiceUtil.hasUserGroup((long)userId, (long)groupId)) {
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    groups.add(group);
                }
                userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId));
                userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRolesByUserUserGroupAndGroup((long)userId, (long)groupId));
                ++n2;
            }
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        if (defaultUserId != userId) {
            roles.add(RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest"));
        }
        long companyResourceId = 0L;
        try {
            Resource companyResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)className, (int)1, (String)String.valueOf(companyId));
            companyResourceId = companyResource.getResourceId();
        }
        catch (NoSuchResourceException noSuchResourceException) {}
        long[] groupResourceIds = new long[groups.size()];
        try {
            int i = 0;
            while (i < groups.size()) {
                Group group = (Group)groups.get(i);
                Resource groupResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)className, (int)2, (String)String.valueOf(group.getGroupId()));
                groupResourceIds[i] = groupResource.getResourceId();
                ++i;
            }
        }
        catch (NoSuchResourceException noSuchResourceException) {}
        BooleanQuery permissionQuery = BooleanQueryFactoryUtil.create();
        if (userId > 0L) {
            permissionQuery.addTerm("userId", userId);
        }
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) {
                return query;
            }
            long roleId = role.getRoleId();
            if (this.hasPermission(roleId, companyResourceId)) {
                return query;
            }
            long[] lArray = groupResourceIds;
            int n = groupResourceIds.length;
            int n3 = 0;
            while (n3 < n) {
                long groupResourceId = lArray[n3];
                if (this.hasPermission(roleId, groupResourceId)) {
                    return query;
                }
                ++n3;
            }
            permissionQuery.addTerm("roleId", role.getRoleId());
        }
        for (Group group : groups) {
            this.addRequiredMemberRole(group, permissionQuery);
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            permissionQuery.addTerm("groupRoleId", String.valueOf(userGroupRole.getGroupId()) + "-" + userGroupRole.getRoleId());
        }
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
        fullQuery.add(query, BooleanClauseOccur.MUST);
        fullQuery.add((Query)permissionQuery, BooleanClauseOccur.MUST);
        return fullQuery;
    }

    protected Query doGetPermissionQuery_6(long companyId, long[] groupIds, long userId, String className, Query query) throws Exception {
        Object object;
        PermissionCheckerBag bag = this.getUserBag(userId);
        if (bag == null) {
            return query;
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        List roles = bag.getRoles();
        List userGroupRoles = new ArrayList();
        if (groupIds == null || groupIds.length == 0) {
            groups.addAll(GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true));
            groups.addAll(bag.getGroups());
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId);
        } else {
            object = groupIds;
            int n = groupIds.length;
            int n2 = 0;
            while (n2 < n) {
                long groupId = object[n2];
                if (GroupLocalServiceUtil.hasUserGroup((long)userId, (long)groupId)) {
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    groups.add(group);
                }
                userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId));
                userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRolesByUserUserGroupAndGroup((long)userId, (long)groupId));
                ++n2;
            }
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        if (defaultUserId != userId) {
            roles.add(RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest"));
        }
        BooleanQuery permissionQuery = BooleanQueryFactoryUtil.create();
        if (userId > 0L) {
            permissionQuery.addTerm("userId", userId);
        }
        object = roles.iterator();
        while (object.hasNext()) {
            Role role = (Role)object.next();
            if (role.getName().equals("Administrator")) {
                return query;
            }
            long roleId = role.getRoleId();
            if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)1, (String)String.valueOf(companyId), (long)roleId, (String)"VIEW")) {
                return query;
            }
            for (Group group : groups) {
                if (!ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)2, (String)String.valueOf(group.getGroupId()), (long)roleId, (String)"VIEW")) continue;
                return query;
            }
            permissionQuery.addTerm("roleId", roleId);
        }
        for (Group group : groups) {
            this.addRequiredMemberRole(group, permissionQuery);
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            permissionQuery.addTerm("groupRoleId", String.valueOf(userGroupRole.getGroupId()) + "-" + userGroupRole.getRoleId());
        }
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
        fullQuery.add(query, BooleanClauseOccur.MUST);
        fullQuery.add((Query)permissionQuery, BooleanClauseOccur.MUST);
        return fullQuery;
    }

    protected void doUpdatePermissionFields_5(long resourceId) throws Exception {
        Resource resource = ResourceLocalServiceUtil.getResource((long)resourceId);
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)resource.getName());
        if (indexer != null) {
            indexer.reindex(resource.getName(), GetterUtil.getLong((String)resource.getPrimKey()));
        }
    }

    protected void doUpdatePermissionFields_6(String resourceName, String resourceClassPK) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)resourceName);
        if (indexer != null) {
            indexer.reindex(resourceName, GetterUtil.getLong((String)resourceClassPK));
        }
    }

    protected PermissionCheckerBag getUserBag(long userId) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
        if (permissionChecker instanceof AdvancedPermissionChecker) {
            AdvancedPermissionChecker advancedPermissionChecker = (AdvancedPermissionChecker)permissionChecker;
            return advancedPermissionChecker.getUserBag(userId, 0L);
        }
        return null;
    }

    protected boolean hasPermission(long roleId, long resourceId) throws SystemException {
        if (resourceId == 0L) {
            return false;
        }
        List permissions = PermissionLocalServiceUtil.getRolePermissions((long)roleId, (long)resourceId);
        List<String> actions = ResourceActionsUtil.getActions(permissions);
        return actions.contains("VIEW");
    }
}

