/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.job;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

public class MessageSenderJob
implements Job {
    private static Log _log = LogFactoryUtil.getLog(MessageSenderJob.class);

    public void execute(JobExecutionContext jobExecutionContext) {
        try {
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            String destination = jobDataMap.getString("destination");
            Message message = (Message)jobDataMap.get((Object)"message");
            if (message == null) {
                message = new Message();
            }
            Date scheduledFireTime = jobExecutionContext.getScheduledFireTime();
            message.put("scheduledFireTime", (Object)scheduledFireTime);
            if (jobExecutionContext.getNextFireTime() == null) {
                message.put("disable", (Object)true);
            }
            MessageBusUtil.sendMessage((String)destination, (Message)message);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to execute job", (Throwable)e);
        }
    }
}

