/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PluginSettingLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.JS;
import com.liferay.util.PwdGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTypePortletImpl
extends LayoutTypeImpl
implements LayoutTypePortlet {
    private static final String _NESTED_PORTLETS_NAMESPACE = PortalUtil.getPortletNamespace((String)"118");
    private static Log _log = LogFactoryUtil.getLog(LayoutTypePortletImpl.class);
    private boolean _enablePortletLayoutListener = true;

    public static String getFullInstanceSeparator() {
        String instanceId = PwdGenerator.getPassword((String)(String.valueOf(PwdGenerator.KEY1) + PwdGenerator.KEY2 + PwdGenerator.KEY3), (int)4);
        return "_INSTANCE_" + instanceId;
    }

    public LayoutTypePortletImpl(Layout layout) {
        super(layout);
    }

    public void addModeAboutPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeAbout(StringUtil.add((String)this.getModeAbout(), (String)portletId));
    }

    public void addModeConfigPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeConfig(StringUtil.add((String)this.getModeConfig(), (String)portletId));
    }

    public void addModeEditDefaultsPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditDefaults(StringUtil.add((String)this.getModeEditDefaults(), (String)portletId));
    }

    public void addModeEditGuestPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditGuest(StringUtil.add((String)this.getModeEditGuest(), (String)portletId));
    }

    public void addModeEditPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEdit(StringUtil.add((String)this.getModeEdit(), (String)portletId));
    }

    public void addModeHelpPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeHelp(StringUtil.add((String)this.getModeHelp(), (String)portletId));
    }

    public void addModePreviewPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePreview(StringUtil.add((String)this.getModePreview(), (String)portletId));
    }

    public void addModePrintPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePrint(StringUtil.add((String)this.getModePrint(), (String)portletId));
    }

    public String addPortletId(long userId, String portletId) throws PortalException, SystemException {
        return this.addPortletId(userId, portletId, true);
    }

    public String addPortletId(long userId, String portletId, boolean checkPermission) throws PortalException, SystemException {
        return this.addPortletId(userId, portletId, null, -1, checkPermission);
    }

    public String addPortletId(long userId, String portletId, String columnId, int columnPos) throws PortalException, SystemException {
        return this.addPortletId(userId, portletId, columnId, columnPos, true);
    }

    public String addPortletId(long userId, String portletId, String columnId, int columnPos, boolean checkPermission) throws PortalException, SystemException {
        LayoutTemplate layoutTemplate;
        List columns;
        Portlet portlet;
        Layout layout;
        block17: {
            portletId = JS.getSafeName((String)portletId);
            layout = this.getLayout();
            portlet = null;
            portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet != null) break block17;
            _log.error((Object)("Portlet " + portletId + " cannot be added because it is not registered"));
            return null;
        }
        try {
            if (checkPermission && !portlet.hasAddPortletPermission(userId)) {
                return null;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (portlet.isSystem()) {
            return null;
        }
        if (portlet.isInstanceable() && PortletConstants.getInstanceId((String)portlet.getPortletId()) == null) {
            portletId = String.valueOf(portletId) + LayoutTypePortletImpl.getFullInstanceSeparator();
        }
        if (this.hasPortletId(portletId)) {
            return null;
        }
        if (columnId == null && (columns = (layoutTemplate = this.getLayoutTemplate()).getColumns()).size() > 0) {
            columnId = (String)columns.get(0);
        }
        if (columnId != null) {
            String columnValue = this.getTypeSettingsProperties().getProperty(columnId);
            if (columnValue == null && columnId.startsWith(_NESTED_PORTLETS_NAMESPACE)) {
                this.addNestedColumn(columnId);
            }
            if (columnPos >= 0) {
                List portletIds = ListUtil.fromArray((Object[])StringUtil.split((String)columnValue));
                if (columnPos <= portletIds.size()) {
                    portletIds.add(columnPos, portletId);
                } else {
                    portletIds.add(portletId);
                }
                columnValue = StringUtil.merge((Collection)portletIds);
            } else {
                columnValue = StringUtil.add((String)columnValue, (String)portletId);
            }
            this.getTypeSettingsProperties().setProperty(columnId, columnValue);
        }
        try {
            PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            if (this._enablePortletLayoutListener && portletLayoutListener != null) {
                portletLayoutListener.onAddToLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e);
        }
        return portletId;
    }

    public void addPortletIds(long userId, String[] portletIds, boolean checkPermission) throws PortalException, SystemException {
        int i = 0;
        while (i < portletIds.length) {
            String portletId = portletIds[i];
            this.addPortletId(userId, portletId, checkPermission);
            ++i;
        }
    }

    public void addPortletIds(long userId, String[] portletIds, String columnId, boolean checkPermission) throws PortalException, SystemException {
        int i = 0;
        while (i < portletIds.length) {
            String portletId = portletIds[i];
            this.addPortletId(userId, portletId, columnId, -1, checkPermission);
            ++i;
        }
    }

    public void addStateMaxPortletId(String portletId) {
        this.removeStatesPortletId(portletId);
        this.setStateMax(StringUtil.add((String)"", (String)portletId));
    }

    public void addStateMinPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.setStateMin(StringUtil.add((String)this.getStateMin(), (String)portletId));
    }

    public List<Portlet> addStaticPortlets(List<Portlet> portlets, List<Portlet> startPortlets, List<Portlet> endPortlets) {
        if (startPortlets == null) {
            startPortlets = new ArrayList<Portlet>();
        }
        if (endPortlets == null) {
            endPortlets = new ArrayList<Portlet>();
        }
        if (startPortlets.isEmpty() && endPortlets.isEmpty()) {
            return portlets;
        }
        ArrayList<Portlet> list = new ArrayList<Portlet>(portlets.size() + startPortlets.size() + endPortlets.size());
        if (startPortlets != null) {
            list.addAll(startPortlets);
        }
        int i = 0;
        while (i < portlets.size()) {
            Portlet portlet = portlets.get(i);
            if (!startPortlets.contains(portlet) && !endPortlets.contains(portlet)) {
                list.add(portlet);
            }
            ++i;
        }
        if (endPortlets != null) {
            list.addAll(endPortlets);
        }
        return list;
    }

    public List<Portlet> getAllPortlets() throws PortalException, SystemException {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        List<String> columns = this.getColumns();
        int i = 0;
        while (i < columns.size()) {
            String columnId = columns.get(i);
            portlets.addAll(this.getAllPortlets(columnId));
            ++i;
        }
        return portlets;
    }

    public List<Portlet> getAllPortlets(String columnId) throws PortalException, SystemException {
        String columnValue = this.getTypeSettingsProperties().getProperty(columnId);
        String[] portletIds = StringUtil.split((String)columnValue);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.length);
        int i = 0;
        while (i < portletIds.length) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getLayout().getCompanyId(), (String)portletIds[i]);
            if (portlet != null) {
                portlets.add(portlet);
            }
            ++i;
        }
        List<Portlet> startPortlets = this.getStaticPortlets("layout.static.portlets.start." + columnId);
        List<Portlet> endPortlets = this.getStaticPortlets("layout.static.portlets.end." + columnId);
        return this.addStaticPortlets(portlets, startPortlets, endPortlets);
    }

    public LayoutTemplate getLayoutTemplate() {
        LayoutTemplate layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)this.getLayoutTemplateId(), (boolean)false, null);
        if (layoutTemplate == null) {
            layoutTemplate = new LayoutTemplateImpl("", "");
            ArrayList<String> columns = new ArrayList<String>();
            int i = 1;
            while (i <= 10) {
                columns.add("column-" + i);
                ++i;
            }
            layoutTemplate.setColumns(columns);
        }
        return layoutTemplate;
    }

    public String getLayoutTemplateId() {
        String layoutTemplateId = this.getTypeSettingsProperties().getProperty("layout-template-id");
        if (Validator.isNull((String)layoutTemplateId)) {
            layoutTemplateId = "";
        }
        return layoutTemplateId;
    }

    public String getModeAbout() {
        return this.getTypeSettingsProperties().getProperty("mode-about");
    }

    public String getModeConfig() {
        return this.getTypeSettingsProperties().getProperty("mode-config");
    }

    public String getModeEdit() {
        return this.getTypeSettingsProperties().getProperty("mode-edit");
    }

    public String getModeEditDefaults() {
        return this.getTypeSettingsProperties().getProperty("mode-edit-defaults");
    }

    public String getModeEditGuest() {
        return this.getTypeSettingsProperties().getProperty("mode-edit-guest");
    }

    public String getModeHelp() {
        return this.getTypeSettingsProperties().getProperty("mode-help");
    }

    public String getModePreview() {
        return this.getTypeSettingsProperties().getProperty("mode-preview");
    }

    public String getModePrint() {
        return this.getTypeSettingsProperties().getProperty("mode-print");
    }

    public int getNumOfColumns() {
        return this.getLayoutTemplate().getColumns().size();
    }

    public List<String> getPortletIds() {
        ArrayList<String> portletIds = new ArrayList<String>();
        List<String> columns = this.getColumns();
        int i = 0;
        while (i < columns.size()) {
            String columnId = columns.get(i);
            String columnValue = this.getTypeSettingsProperties().getProperty(columnId);
            portletIds.addAll(ListUtil.fromArray((Object[])StringUtil.split((String)columnValue)));
            ++i;
        }
        return portletIds;
    }

    public List<Portlet> getPortlets() throws SystemException {
        List<String> portletIds = this.getPortletIds();
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.size());
        int i = 0;
        while (i < portletIds.size()) {
            String portletId = portletIds.get(i);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getLayout().getCompanyId(), (String)portletId);
            if (portlet != null) {
                portlets.add(portlet);
            }
            ++i;
        }
        return portlets;
    }

    public String getStateMax() {
        return this.getTypeSettingsProperties().getProperty("state-max");
    }

    public String getStateMaxPortletId() {
        String[] stateMax = StringUtil.split((String)this.getStateMax());
        if (stateMax.length > 0) {
            return stateMax[0];
        }
        return "";
    }

    public String getStateMin() {
        return this.getTypeSettingsProperties().getProperty("state-min");
    }

    public boolean hasDefaultScopePortletId(long groupId, String portletId) throws PortalException, SystemException {
        long scopeGroupId;
        return this.hasPortletId(portletId) && groupId == (scopeGroupId = PortalUtil.getScopeGroupId((Layout)this.getLayout(), (String)portletId));
    }

    public boolean hasModeAboutPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeAbout(), (String)portletId);
    }

    public boolean hasModeConfigPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeConfig(), (String)portletId);
    }

    public boolean hasModeEditDefaultsPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEditDefaults(), (String)portletId);
    }

    public boolean hasModeEditGuestPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEditGuest(), (String)portletId);
    }

    public boolean hasModeEditPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEdit(), (String)portletId);
    }

    public boolean hasModeHelpPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeHelp(), (String)portletId);
    }

    public boolean hasModePreviewPortletId(String portletId) {
        return StringUtil.contains((String)this.getModePreview(), (String)portletId);
    }

    public boolean hasModePrintPortletId(String portletId) {
        return StringUtil.contains((String)this.getModePrint(), (String)portletId);
    }

    public boolean hasModeViewPortletId(String portletId) {
        return !this.hasModeAboutPortletId(portletId) && !this.hasModeConfigPortletId(portletId) && !this.hasModeEditPortletId(portletId) && !this.hasModeEditDefaultsPortletId(portletId) && !this.hasModeEditGuestPortletId(portletId) && !this.hasModeHelpPortletId(portletId) && !this.hasModePreviewPortletId(portletId) && !this.hasModePrintPortletId(portletId);
    }

    public boolean hasPortletId(String portletId) throws PortalException, SystemException {
        List<String> columns = this.getColumns();
        int i = 0;
        while (i < columns.size()) {
            String columnId = columns.get(i);
            if (this.hasNonstaticPortletId(columnId, portletId)) {
                return true;
            }
            if (this.hasStaticPortletId(columnId, portletId)) {
                return true;
            }
            ++i;
        }
        return this.getLayout().isTypeControlPanel() && this.hasStateMaxPortletId(portletId);
    }

    public boolean hasStateMax() {
        String[] stateMax = StringUtil.split((String)this.getStateMax());
        return stateMax.length > 0;
    }

    public boolean hasStateMaxPortletId(String portletId) {
        return StringUtil.contains((String)this.getStateMax(), (String)portletId);
    }

    public boolean hasStateMin() {
        String[] stateMin = StringUtil.split((String)this.getStateMin());
        return stateMin.length > 0;
    }

    public boolean hasStateMinPortletId(String portletId) {
        return StringUtil.contains((String)this.getStateMin(), (String)portletId);
    }

    public boolean hasStateNormalPortletId(String portletId) {
        return !this.hasStateMaxPortletId(portletId) && !this.hasStateMinPortletId(portletId);
    }

    public void movePortletId(long userId, String portletId, String columnId, int columnPos) throws PortalException, SystemException {
        this._enablePortletLayoutListener = false;
        try {
            this.removePortletId(userId, portletId, false);
            this.addPortletId(userId, portletId, columnId, columnPos);
        }
        finally {
            this._enablePortletLayoutListener = true;
        }
        Layout layout = this.getLayout();
        try {
            PortletLayoutListener portletLayoutListener;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet != null && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
                portletLayoutListener.onMoveInLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e);
        }
    }

    public void removeModeAboutPortletId(String portletId) {
        this.setModeAbout(StringUtil.remove((String)this.getModeAbout(), (String)portletId));
    }

    public void removeModeConfigPortletId(String portletId) {
        this.setModeConfig(StringUtil.remove((String)this.getModeConfig(), (String)portletId));
    }

    public void removeModeEditDefaultsPortletId(String portletId) {
        this.setModeEditDefaults(StringUtil.remove((String)this.getModeEditDefaults(), (String)portletId));
    }

    public void removeModeEditGuestPortletId(String portletId) {
        this.setModeEditGuest(StringUtil.remove((String)this.getModeEditGuest(), (String)portletId));
    }

    public void removeModeEditPortletId(String portletId) {
        this.setModeEdit(StringUtil.remove((String)this.getModeEdit(), (String)portletId));
    }

    public void removeModeHelpPortletId(String portletId) {
        this.setModeHelp(StringUtil.remove((String)this.getModeHelp(), (String)portletId));
    }

    public void removeModePreviewPortletId(String portletId) {
        this.setModePreview(StringUtil.remove((String)this.getModePreview(), (String)portletId));
    }

    public void removeModePrintPortletId(String portletId) {
        this.setModePrint(StringUtil.remove((String)this.getModePrint(), (String)portletId));
    }

    public void removeModesPortletId(String portletId) {
        this.removeModeAboutPortletId(portletId);
        this.removeModeConfigPortletId(portletId);
        this.removeModeEditPortletId(portletId);
        this.removeModeEditDefaultsPortletId(portletId);
        this.removeModeEditGuestPortletId(portletId);
        this.removeModeHelpPortletId(portletId);
        this.removeModePreviewPortletId(portletId);
        this.removeModePrintPortletId(portletId);
    }

    public void removeNestedColumns(String portletId) {
        UnicodeProperties props = this.getTypeSettingsProperties();
        UnicodeProperties newProps = new UnicodeProperties();
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(portletId)) continue;
            newProps.setProperty(key, (String)entry.getValue());
        }
        this.getLayout().setTypeSettingsProperties(newProps);
        String nestedColumnIds = GetterUtil.getString((String)this.getTypeSettingsProperties().getProperty("nested-column-ids"));
        Object[] nestedColumnIdsArray = ArrayUtil.removeByPrefix((String[])StringUtil.split((String)nestedColumnIds), (String)portletId);
        this.getTypeSettingsProperties().setProperty("nested-column-ids", StringUtil.merge((Object[])nestedColumnIdsArray));
    }

    public void removePortletId(long userId, String portletId) {
        this.removePortletId(userId, portletId, true);
    }

    public void removePortletId(long userId, String portletId, boolean cleanUp) {
        try {
            Layout layout = this.getLayout();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet == null) {
                _log.error((Object)("Portlet " + portletId + " cannot be removed because it is not registered"));
                return;
            }
            if (!portlet.hasAddPortletPermission(userId)) {
                return;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        List<String> columns = this.getColumns();
        int i = 0;
        while (i < columns.size()) {
            String columnId = columns.get(i);
            String columnValue = this.getTypeSettingsProperties().getProperty(columnId);
            columnValue = StringUtil.remove((String)columnValue, (String)portletId);
            this.getTypeSettingsProperties().setProperty(columnId, columnValue);
            ++i;
        }
        if (cleanUp) {
            this.removeStatesPortletId(portletId);
            this.removeModesPortletId(portletId);
            try {
                this.onRemoveFromLayout(portletId);
            }
            catch (Exception e) {
                _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e);
            }
        }
    }

    public void removeStateMaxPortletId(String portletId) {
        this.setStateMax(StringUtil.remove((String)this.getStateMax(), (String)portletId));
    }

    public void removeStateMinPortletId(String portletId) {
        this.setStateMin(StringUtil.remove((String)this.getStateMin(), (String)portletId));
    }

    public void removeStatesPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.removeStateMinPortletId(portletId);
    }

    public void reorganizePortlets(List<String> newColumns, List<String> oldColumns) {
        String lastNewColumnId = newColumns.get(newColumns.size() - 1);
        String lastNewColumnValue = this.getTypeSettingsProperties().getProperty(lastNewColumnId);
        for (String oldColumnId : oldColumns) {
            String[] portletIds;
            if (newColumns.contains(oldColumnId)) continue;
            String oldColumnValue = this.getTypeSettingsProperties().remove((Object)oldColumnId);
            String[] stringArray = portletIds = StringUtil.split((String)oldColumnValue);
            int n = portletIds.length;
            int n2 = 0;
            while (n2 < n) {
                String portletId = stringArray[n2];
                lastNewColumnValue = StringUtil.add((String)lastNewColumnValue, (String)portletId);
                ++n2;
            }
        }
        this.getTypeSettingsProperties().setProperty(lastNewColumnId, lastNewColumnValue);
    }

    public void resetModes() {
        this.setModeAbout("");
        this.setModeConfig("");
        this.setModeEdit("");
        this.setModeEditDefaults("");
        this.setModeEditGuest("");
        this.setModeHelp("");
        this.setModePreview("");
        this.setModePrint("");
    }

    public void resetStates() {
        this.setStateMax("");
        this.setStateMin("");
    }

    public void setLayoutTemplateId(long userId, String newLayoutTemplateId) {
        this.setLayoutTemplateId(userId, newLayoutTemplateId, true);
    }

    public void setLayoutTemplateId(long userId, String newLayoutTemplateId, boolean checkPermission) {
        if (checkPermission && !PluginSettingLocalServiceUtil.hasPermission((long)userId, (String)newLayoutTemplateId, (String)"layout-template")) {
            return;
        }
        String oldLayoutTemplateId = this.getLayoutTemplateId();
        if (Validator.isNull((String)oldLayoutTemplateId)) {
            oldLayoutTemplateId = PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID;
        }
        this.getTypeSettingsProperties().setProperty("layout-template-id", newLayoutTemplateId);
        String themeId = null;
        try {
            Layout layout = this.getLayout();
            Theme theme = layout.getTheme();
            themeId = theme != null ? theme.getThemeId() : layout.getThemeId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        LayoutTemplate oldLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)oldLayoutTemplateId, (boolean)false, themeId);
        if (oldLayoutTemplate == null) {
            return;
        }
        LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)newLayoutTemplateId, (boolean)false, (String)themeId);
        List oldColumns = oldLayoutTemplate.getColumns();
        List newColumns = newLayoutTemplate.getColumns();
        this.reorganizePortlets(newColumns, oldColumns);
    }

    public void setModeAbout(String modeAbout) {
        this.getTypeSettingsProperties().setProperty("mode-about", modeAbout);
    }

    public void setModeConfig(String modeConfig) {
        this.getTypeSettingsProperties().setProperty("mode-config", modeConfig);
    }

    public void setModeEdit(String modeEdit) {
        this.getTypeSettingsProperties().setProperty("mode-edit", modeEdit);
    }

    public void setModeEditDefaults(String modeEditDefaults) {
        this.getTypeSettingsProperties().setProperty("mode-edit-defaults", modeEditDefaults);
    }

    public void setModeEditGuest(String modeEditGuest) {
        this.getTypeSettingsProperties().setProperty("mode-edit-guest", modeEditGuest);
    }

    public void setModeHelp(String modeHelp) {
        this.getTypeSettingsProperties().setProperty("mode-help", modeHelp);
    }

    public void setModePreview(String modePreview) {
        this.getTypeSettingsProperties().setProperty("mode-preview", modePreview);
    }

    public void setModePrint(String modePrint) {
        this.getTypeSettingsProperties().setProperty("mode-print", modePrint);
    }

    public void setPortletIds(String columnId, String portletIds) {
        this.getTypeSettingsProperties().setProperty(columnId, portletIds);
    }

    public void setStateMax(String stateMax) {
        this.getTypeSettingsProperties().setProperty("state-max", stateMax);
    }

    public void setStateMin(String stateMin) {
        this.getTypeSettingsProperties().setProperty("state-min", stateMin);
    }

    protected void addNestedColumn(String columnId) {
        String nestedColumnIds = this.getTypeSettingsProperties().getProperty("nested-column-ids", "");
        if (nestedColumnIds.indexOf(columnId) == -1) {
            nestedColumnIds = StringUtil.add((String)nestedColumnIds, (String)columnId);
            this.getTypeSettingsProperties().setProperty("nested-column-ids", nestedColumnIds);
        }
    }

    protected void deletePortletSetup(String portletId) {
        try {
            List list = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)this.getLayout().getPlid(), (String)portletId);
            int i = 0;
            while (i < list.size()) {
                PortletPreferences portletPreferences = (PortletPreferences)list.get(i);
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((long)portletPreferences.getPortletPreferencesId());
                ++i;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected List<String> getColumns() {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        ArrayList<String> columns = new ArrayList<String>();
        columns.addAll(layoutTemplate.getColumns());
        columns.addAll(this.getNestedColumns());
        return columns;
    }

    protected List<String> getNestedColumns() {
        String nestedColumnIds = this.getTypeSettingsProperties().getProperty("nested-column-ids");
        return ListUtil.fromArray((Object[])StringUtil.split((String)nestedColumnIds));
    }

    protected String[] getStaticPortletIds(String position) throws PortalException, SystemException {
        Layout layout = this.getLayout();
        String selector1 = "";
        Group group = layout.getGroup();
        if (group.isUser()) {
            selector1 = "user";
        } else if (group.isCommunity()) {
            selector1 = "community";
        } else if (group.isOrganization()) {
            selector1 = "organization";
        }
        String selector2 = layout.getFriendlyURL();
        String[] portletIds = PropsUtil.getArray(position, new Filter(selector1, selector2));
        int i = 0;
        while (i < portletIds.length) {
            portletIds[i] = JS.getSafeName((String)portletIds[i]);
            ++i;
        }
        return portletIds;
    }

    protected List<Portlet> getStaticPortlets(String position) throws PortalException, SystemException {
        String[] portletIds = this.getStaticPortletIds(position);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        int i = 0;
        while (i < portletIds.length) {
            Portlet portlet;
            String portletId = portletIds[i];
            if (!Validator.isNull((String)portletId) && !this.hasNonstaticPortletId(portletId) && (portlet = PortletLocalServiceUtil.getPortletById((long)this.getLayout().getCompanyId(), (String)portletId)) != null) {
                Portlet staticPortlet = portlet;
                if (!portlet.isInstanceable()) {
                    staticPortlet = (Portlet)staticPortlet.clone();
                }
                staticPortlet.setStatic(true);
                if (position.startsWith("layout.static.portlets.start")) {
                    staticPortlet.setStaticStart(true);
                }
                portlets.add(staticPortlet);
            }
            ++i;
        }
        return portlets;
    }

    protected boolean hasNonstaticPortletId(String portletId) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        List columns = layoutTemplate.getColumns();
        int i = 0;
        while (i < columns.size()) {
            String columnId = (String)columns.get(i);
            if (this.hasNonstaticPortletId(columnId, portletId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean hasNonstaticPortletId(String columnId, String portletId) {
        String columnValue = this.getTypeSettingsProperties().getProperty(columnId);
        return StringUtil.contains((String)columnValue, (String)portletId);
    }

    protected boolean hasStaticPortletId(String columnId, String portletId) throws PortalException, SystemException {
        Object[] staticPortletIdsStart = this.getStaticPortletIds("layout.static.portlets.start." + columnId);
        Object[] staticPortletIdsEnd = this.getStaticPortletIds("layout.static.portlets.end." + columnId);
        String[] staticPortletIds = (String[])ArrayUtil.append((Object[])staticPortletIdsStart, (Object[])staticPortletIdsEnd);
        int i = 0;
        while (i < staticPortletIds.length) {
            String staticPortletId = staticPortletIds[i];
            if (staticPortletId.equals(portletId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void onRemoveFromLayout(String portletId) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getLayout().getCompanyId(), (String)portletId);
        if (portlet == null) {
            return;
        }
        if (portlet.getRootPortletId().equals("118")) {
            UnicodeProperties props = this.getTypeSettingsProperties();
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(portlet.getPortletId())) continue;
                String portletIds = (String)entry.getValue();
                String[] portletIdsArray = StringUtil.split((String)portletIds);
                int i = 0;
                while (i < portletIdsArray.length) {
                    this.onRemoveFromLayout(portletIdsArray[i]);
                    ++i;
                }
            }
            this.removeNestedColumns(portletId);
        }
        if (this._enablePortletLayoutListener) {
            PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            long plid = this.getLayout().getPlid();
            if (portletLayoutListener != null) {
                portletLayoutListener.onRemoveFromLayout(portletId, plid);
            }
        }
        this.deletePortletSetup(portletId);
    }
}

