/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import java.util.Properties;

public class GAuthenticator {
    private static Log _log = LogFactoryUtil.getLog(GAuthenticator.class);
    private String _authenticationToken;
    private long _companyId;
    private String _domain;
    private long _initTime;
    private String _password;
    private String _userName;

    public GAuthenticator(long companyId) {
        this._companyId = companyId;
        this.init(true);
    }

    public String getAuthenticationToken() {
        this.init(false);
        return this._authenticationToken;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDomain() {
        return this._domain;
    }

    public void init(boolean manual) {
        if (manual || this.isStale()) {
            try {
                this.doInit();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void doInit() throws Exception {
        Company company = CompanyLocalServiceUtil.getCompany((long)this._companyId);
        this._domain = company.getMx();
        this._userName = PrefsPropsUtil.getString(this._companyId, "google.apps.username");
        this._password = PrefsPropsUtil.getString(this._companyId, "google.apps.password");
        if (!this._userName.contains("@")) {
            this._userName = String.valueOf(this._userName) + "@" + this._domain;
        }
        Http.Options options = new Http.Options();
        options.addPart("Email", this._userName);
        options.addPart("Passwd", this._password);
        options.addPart("accountType", "HOSTED");
        options.addPart("service", "apps");
        options.setLocation("https://www.google.com/accounts/ClientLogin");
        options.setPost(true);
        String content = HttpUtil.URLtoString((Http.Options)options);
        Properties properties = PropertiesUtil.load((String)content);
        this._authenticationToken = properties.getProperty("Auth");
        this._initTime = System.currentTimeMillis();
    }

    private boolean isStale() {
        return this._initTime + 82800000L <= System.currentTimeMillis();
    }
}

