/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.model.FileModel;
import com.liferay.documentlibrary.util.BaseHook;
import com.liferay.portal.cmis.CMISException;
import com.liferay.portal.cmis.CMISUtil;
import com.liferay.portal.cmis.model.CMISConstants;
import com.liferay.portal.cmis.model.CMISObject;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;

public class CMISHook
extends BaseHook {
    private static Log _log = LogFactoryUtil.getLog(CMISHook.class);
    private static CMISConstants _cmisConstants = CMISConstants.getInstance();

    public CMISHook() {
        try {
            String version = CMISUtil.verifyRepository();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("CMIS Service is running version " + version));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        Entry repositoryFolderEntry = this.getRepositoryFolderEntry(companyId, repositoryId);
        CMISUtil.createFolder(repositoryFolderEntry, dirName);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException {
        this.updateFile(companyId, portletId, groupId, repositoryId, fileName, "1.0", null, fileEntryId, properties, modifiedDate, serviceContext, is);
    }

    public void checkRoot(long companyId) {
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException {
        Entry repositoryFolderEntry = this.getRepositoryFolderEntry(companyId, repositoryId);
        Entry directory = CMISUtil.getFolder(repositoryFolderEntry, dirName);
        if (directory != null) {
            CMISUtil.delete(directory);
        }
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException {
        Entry versioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, fileName, false);
        if (versioningFolderEntry == null) {
            throw new NoSuchFileException();
        }
        CMISUtil.delete(versioningFolderEntry);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        FileModel fileModel = new FileModel();
        fileModel.setCompanyId(companyId);
        fileModel.setFileName(fileName);
        fileModel.setPortletId(portletId);
        fileModel.setRepositoryId(repositoryId);
        indexer.delete((Object)fileModel);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, String versionNumber) throws PortalException {
        Entry fileEntry = this.getVersionedFileEntry(companyId, repositoryId, fileName, versionNumber);
        CMISUtil.delete(fileEntry);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        FileModel fileModel = new FileModel();
        fileModel.setCompanyId(companyId);
        fileModel.setFileName(fileName);
        fileModel.setPortletId(portletId);
        fileModel.setRepositoryId(repositoryId);
        indexer.delete((Object)fileModel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException {
        if (Validator.isNull((String)versionNumber)) {
            versionNumber = this.getHeadVersionNumber(companyId, repositoryId, fileName);
        }
        Entry fileEntry = this.getVersionedFileEntry(companyId, repositoryId, fileName, versionNumber);
        return CMISUtil.getInputStream(fileEntry);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        Entry repositoryFolderEntry = this.getRepositoryFolderEntry(companyId, repositoryId);
        List<String> fileNames = CMISUtil.getFolders(repositoryFolderEntry);
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        String versionNumber = this.getHeadVersionNumber(companyId, repositoryId, fileName);
        Entry fileEntry = this.getVersionedFileEntry(companyId, repositoryId, fileName, versionNumber);
        CMISObject cmisObject = (CMISObject)fileEntry.getFirstChild(CMISHook._cmisConstants.OBJECT);
        return cmisObject.getContentStreamLength();
    }

    public String getHeadVersionNumber(long companyId, long repositoryId, String dirName) throws CMISException, NoSuchFileException {
        Entry versioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, dirName, false);
        if (versioningFolderEntry == null) {
            throw new NoSuchFileException();
        }
        List<String> versionNumbers = CMISUtil.getFolders(versioningFolderEntry);
        String headVersionNumber = "1.0";
        for (String versionNumber : versionNumbers) {
            if (DLUtil.compareVersions((String)versionNumber, (String)headVersionNumber) <= 0) continue;
            headVersionNumber = versionNumber;
        }
        return headVersionNumber;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException {
        Entry versioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, fileName, true);
        Link link = versioningFolderEntry.getLink(CMISHook._cmisConstants.LINK_DESCENDANTS);
        String url = link.getHref().toString();
        Entry fileEntry = CMISUtil.getEntry(url, versionNumber, CMISHook._cmisConstants.BASE_TYPE_DOCUMENT);
        return fileEntry != null;
    }

    public void move(String srcDir, String destDir) {
    }

    public void reindex(String[] ids) throws SearchException {
        ArrayList<Document> documents;
        long companyId;
        block3: {
            companyId = GetterUtil.getLong((String)ids[0]);
            String portletId = ids[1];
            long groupId = GetterUtil.getLong((String)ids[2]);
            long repositoryId = GetterUtil.getLong((String)ids[3]);
            documents = new ArrayList<Document>();
            try {
                Entry repositoryFolderEntry = this.getRepositoryFolderEntry(companyId, repositoryId);
                List<String> fileNames = CMISUtil.getFolders(repositoryFolderEntry);
                for (String fileName : fileNames) {
                    Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
                    FileModel fileModel = new FileModel();
                    fileModel.setCompanyId(companyId);
                    fileModel.setFileName(fileName);
                    fileModel.setGroupId(groupId);
                    fileModel.setPortletId(portletId);
                    fileModel.setRepositoryId(repositoryId);
                    Document document = indexer.getDocument((Object)fileModel);
                    if (document == null) continue;
                    documents.add(document);
                }
            }
            catch (CMISException cmise) {
                if (!_log.isErrorEnabled()) break block3;
                _log.error((Object)cmise, (Throwable)((Object)cmise));
            }
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws PortalException {
        Entry oldVersioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, fileName, true);
        Entry newVersioningFolderEntry = this.getVersioningFolderEntry(companyId, newRepositoryId, fileName, true);
        List<String> fileNames = CMISUtil.getFolders(oldVersioningFolderEntry);
        for (String curFileName : fileNames) {
            Entry entry = CMISUtil.getDocument(oldVersioningFolderEntry, curFileName);
            InputStream is = CMISUtil.getInputStream(entry);
            CMISUtil.createDocument(newVersioningFolderEntry, curFileName, is);
        }
        CMISUtil.delete(oldVersioningFolderEntry);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        FileModel fileModel = new FileModel();
        fileModel.setCompanyId(companyId);
        fileModel.setFileName(fileName);
        fileModel.setPortletId(portletId);
        fileModel.setRepositoryId(repositoryId);
        indexer.delete((Object)fileModel);
        fileModel.setRepositoryId(newRepositoryId);
        fileModel.setGroupId(groupId);
        indexer.reindex((Object)fileModel);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String newFileName, boolean reindex) throws PortalException {
        Entry oldVersioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, fileName, true);
        Entry newVersioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, newFileName, true);
        List<String> fileNames = CMISUtil.getFolders(oldVersioningFolderEntry);
        for (String curFileName : fileNames) {
            Entry entry = CMISUtil.getDocument(oldVersioningFolderEntry, curFileName);
            InputStream is = CMISUtil.getInputStream(entry);
            CMISUtil.createDocument(newVersioningFolderEntry, curFileName, is);
        }
        CMISUtil.delete(oldVersioningFolderEntry);
        if (reindex) {
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            FileModel fileModel = new FileModel();
            fileModel.setCompanyId(companyId);
            fileModel.setFileName(fileName);
            fileModel.setPortletId(portletId);
            fileModel.setRepositoryId(repositoryId);
            indexer.delete((Object)fileModel);
            fileModel.setFileName(newFileName);
            fileModel.setGroupId(groupId);
            indexer.reindex((Object)fileModel);
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException {
        String title;
        Entry versioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, fileName, true);
        Link link = versioningFolderEntry.getLink(CMISHook._cmisConstants.LINK_DESCENDANTS);
        String url = link.getHref().toString();
        Entry fileEntry = CMISUtil.getEntry(url, title = String.valueOf(versionNumber), CMISHook._cmisConstants.BASE_TYPE_DOCUMENT);
        if (fileEntry != null) {
            throw new DuplicateFileException();
        }
        fileEntry = CMISUtil.createDocument(url, title, is);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        FileModel fileModel = new FileModel();
        fileModel.setAssetCategoryIds(serviceContext.getAssetCategoryIds());
        fileModel.setAssetTagNames(serviceContext.getAssetTagNames());
        fileModel.setCompanyId(companyId);
        fileModel.setFileEntryId(fileEntryId);
        fileModel.setFileName(fileName);
        fileModel.setGroupId(groupId);
        fileModel.setModifiedDate(modifiedDate);
        fileModel.setPortletId(portletId);
        fileModel.setProperties(properties);
        fileModel.setRepositoryId(repositoryId);
        indexer.reindex((Object)fileModel);
    }

    protected Entry getCompanyFolderEntry(long companyId) throws CMISException {
        String title = String.valueOf(companyId);
        Entry companyFolderEntry = CMISUtil.getFolder(title);
        if (companyFolderEntry == null) {
            companyFolderEntry = CMISUtil.createFolder(title);
        }
        return companyFolderEntry;
    }

    protected Entry getRepositoryFolderEntry(long companyId, long repositoryId) throws CMISException {
        String title;
        Entry companyFolderEntry = this.getCompanyFolderEntry(companyId);
        Link link = companyFolderEntry.getLink(CMISHook._cmisConstants.LINK_DESCENDANTS);
        String url = link.getHref().toString();
        Entry repositoryFolderEntry = CMISUtil.getFolder(url, title = String.valueOf(repositoryId));
        if (repositoryFolderEntry == null) {
            repositoryFolderEntry = CMISUtil.createFolder(url, title);
        }
        return repositoryFolderEntry;
    }

    protected Entry getVersionedFileEntry(long companyId, long repositoryId, String fileName, String versionNumber) throws CMISException, NoSuchFileException {
        Entry versioningFolderEntry = this.getVersioningFolderEntry(companyId, repositoryId, fileName, false);
        if (versioningFolderEntry == null) {
            throw new NoSuchFileException();
        }
        Link link = versioningFolderEntry.getLink(CMISHook._cmisConstants.LINK_DESCENDANTS);
        String url = link.getHref().toString();
        Entry fileEntry = CMISUtil.getEntry(url, String.valueOf(versionNumber), CMISHook._cmisConstants.BASE_TYPE_DOCUMENT);
        if (fileEntry == null) {
            throw new NoSuchFileException();
        }
        return fileEntry;
    }

    protected Entry getVersioningFolderEntry(long companyId, long repositoryId, String fileName, boolean create) throws CMISException {
        Entry repositoryFolderEntry = this.getRepositoryFolderEntry(companyId, repositoryId);
        Link link = repositoryFolderEntry.getLink(CMISHook._cmisConstants.LINK_DESCENDANTS);
        String url = link.getHref().toString();
        Entry versioningFolderEntry = CMISUtil.getEntry(url, fileName, CMISHook._cmisConstants.BASE_TYPE_FOLDER);
        if (create && versioningFolderEntry == null) {
            versioningFolderEntry = CMISUtil.createFolder(url, fileName);
        }
        return versioningFolderEntry;
    }
}

