/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.service.impl;

import com.liferay.documentlibrary.FileNameException;
import com.liferay.documentlibrary.FileSizeException;
import com.liferay.documentlibrary.SourceFileNameException;
import com.liferay.documentlibrary.service.DLLocalService;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFolderService;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class DLLocalServiceImpl
implements DLLocalService {
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @BeanReference(type=DLFolderService.class)
    protected DLFolderService dlFolderService;
    @BeanReference(type=Hook.class)
    protected Hook hook;
    private static final String[] _KEYWORDS_FIELDS = new String[]{"assetTagNames", "content", "properties"};

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, boolean validateFileExtension, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException, SystemException {
        this.validate(fileName, validateFileExtension, is);
        this.hook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, serviceContext, is);
    }

    public void checkRoot(long companyId) throws SystemException {
        this.hook.checkRoot(companyId);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hook.getFileAsStream(companyId, repositoryId, fileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        return this.hook.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        return this.hook.hasFile(companyId, repositoryId, fileName, versionNumber);
    }

    public void move(String srcDir, String destDir) throws SystemException {
        this.hook.move(srcDir, destDir);
    }

    public Hits search(long companyId, String portletId, long groupId, long userId, long[] repositoryIds, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", portletId);
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (repositoryIds != null && repositoryIds.length > 0) {
                BooleanQuery repositoryIdsQuery = BooleanQueryFactoryUtil.create();
                long[] lArray = repositoryIds;
                int n = repositoryIds.length;
                int n2 = 0;
                while (n2 < n) {
                    long repositoryId = lArray[n2];
                    try {
                        if (userId > 0L) {
                            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                            DLFolderPermission.check(permissionChecker, groupId, repositoryId, "VIEW");
                        }
                        if (repositoryId == 0L) {
                            repositoryId = groupId;
                        }
                        TermQuery termQuery = TermQueryFactoryUtil.create((String)"repositoryId", (long)repositoryId);
                        repositoryIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                contextQuery.add((Query)repositoryIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            searchQuery.addTerms(_KEYWORDS_FIELDS, keywords);
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long[])new long[]{groupId}, (long)userId, (String)DLFileEntry.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException, SystemException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, is);
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, serviceContext, is);
    }

    public void validate(String fileName, boolean validateFileExtension) throws PortalException, SystemException {
        if (fileName.indexOf("\\\\") != -1 || fileName.indexOf("//") != -1 || fileName.indexOf(":") != -1 || fileName.indexOf("*") != -1 || fileName.indexOf("?") != -1 || fileName.indexOf("\"") != -1 || fileName.indexOf("<") != -1 || fileName.indexOf(">") != -1 || fileName.indexOf("|") != -1 || fileName.indexOf("[") != -1 || fileName.indexOf("]") != -1 || fileName.indexOf("'") != -1 || fileName.indexOf("..\\") != -1 || fileName.indexOf("../") != -1 || fileName.indexOf("\\..") != -1 || fileName.indexOf("/..") != -1) {
            throw new FileNameException(fileName);
        }
        if (validateFileExtension) {
            boolean validFileExtension = false;
            String[] fileExtensions = PrefsPropsUtil.getStringArray("dl.file.extensions", ",");
            int i = 0;
            while (i < fileExtensions.length) {
                if ("*".equals(fileExtensions[i]) || StringUtil.endsWith((String)fileName, (String)fileExtensions[i])) {
                    validFileExtension = true;
                    break;
                }
                ++i;
            }
            if (!validFileExtension) {
                throw new FileNameException(fileName);
            }
        }
    }

    public void validate(String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException, SystemException {
        this.validate(fileName, validateFileExtension);
        if (PrefsPropsUtil.getLong("dl.file.max.size") > 0L && (bytes == null || (long)bytes.length > PrefsPropsUtil.getLong("dl.file.max.size"))) {
            throw new FileSizeException(fileName);
        }
    }

    public void validate(String fileName, boolean validateFileExtension, File file) throws PortalException, SystemException {
        this.validate(fileName, validateFileExtension);
        if (PrefsPropsUtil.getLong("dl.file.max.size") > 0L && (file == null || file.length() > PrefsPropsUtil.getLong("dl.file.max.size"))) {
            throw new FileSizeException(fileName);
        }
    }

    public void validate(String fileName, boolean validateFileExtension, InputStream is) throws PortalException, SystemException {
        this.validate(fileName, validateFileExtension);
        try {
            if (PrefsPropsUtil.getLong("dl.file.max.size") > 0L && (is == null || (long)is.available() > PrefsPropsUtil.getLong("dl.file.max.size"))) {
                throw new FileSizeException(fileName);
            }
        }
        catch (IOException ioe) {
            throw new FileSizeException(ioe.getMessage());
        }
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream is) throws PortalException, SystemException {
        String sourceFileExtension = FileUtil.getExtension((String)sourceFileName);
        if (Validator.isNotNull((String)sourceFileName) && PropsValues.DL_FILE_EXTENSIONS_STRICT_CHECK && !fileExtension.equals(sourceFileExtension)) {
            throw new SourceFileNameException(sourceFileExtension);
        }
        this.validate(fileName, validateFileExtension);
        try {
            if (is != null && PrefsPropsUtil.getLong("dl.file.max.size") > 0L && (long)is.available() > PrefsPropsUtil.getLong("dl.file.max.size")) {
                throw new FileSizeException(fileName);
            }
        }
        catch (IOException ioe) {
            throw new FileSizeException(ioe.getMessage());
        }
    }
}

