/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ByteBufferServletResponse;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletResponseUtil {
    private static final String _CLIENT_ABORT_EXCEPTION = "org.apache.catalina.connector.ClientAbortException";
    private static Log _log = LogFactoryUtil.getLog(ServletResponseUtil.class);

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, bytes, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType);
        ServletResponseUtil.write(response, bytes);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, is, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is, int contentLength, String contentType) throws IOException {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType);
        ServletResponseUtil.write(response, is, contentLength);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, is, 0, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, bytes);
    }

    public static void sendFile(HttpServletResponse response, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, bytes, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, is);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is, int contentLength, String contentType) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, is, contentLength, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is, String contentType) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, is, contentType);
    }

    public static void write(HttpServletResponse response, byte[] bytes) throws IOException {
        ServletResponseUtil.write(response, bytes, 0, 0);
    }

    public static void write(HttpServletResponse response, byte[] bytes, int offset, int contentLength) throws IOException {
        try {
            if (!response.isCommitted()) {
                if (contentLength == 0) {
                    contentLength = bytes.length;
                }
                response.setContentLength(contentLength);
                if (response instanceof ByteBufferServletResponse) {
                    ByteBufferServletResponse byteBufferResponse = (ByteBufferServletResponse)response;
                    byteBufferResponse.setByteBuffer(ByteBuffer.wrap(bytes, offset, contentLength));
                } else {
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    servletOutputStream.write(bytes, offset, contentLength);
                }
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SocketException || ioe.getClass().getName().equals(_CLIENT_ABORT_EXCEPTION)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)ioe);
                }
            }
            throw ioe;
        }
    }

    public static void write(HttpServletResponse response, byte[][] bytesArray) throws IOException {
        try {
            if (!response.isCommitted()) {
                int contentLength = 0;
                byte[][] byArray = bytesArray;
                int n = bytesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] bytes = byArray[n2];
                    contentLength += bytes.length;
                    ++n2;
                }
                response.setContentLength(contentLength);
                ServletOutputStream servletOutputStream = response.getOutputStream();
                byte[][] byArray2 = bytesArray;
                int n3 = bytesArray.length;
                n = 0;
                while (n < n3) {
                    byte[] bytes = byArray2[n];
                    servletOutputStream.write(bytes);
                    ++n;
                }
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SocketException || ioe.getClass().getName().equals(_CLIENT_ABORT_EXCEPTION)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)ioe);
                }
            }
            throw ioe;
        }
    }

    public static void write(HttpServletResponse response, ByteBuffer byteBuffer) throws IOException {
        if (response instanceof ByteBufferServletResponse) {
            ByteBufferServletResponse byteBufferResponse = (ByteBufferServletResponse)response;
            byteBufferResponse.setByteBuffer(byteBuffer);
        } else {
            ServletResponseUtil.write(response, byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        }
    }

    public static void write(HttpServletResponse response, File file) throws IOException {
        if (response instanceof ByteBufferServletResponse) {
            ByteBufferServletResponse byteBufferResponse = (ByteBufferServletResponse)response;
            ByteBuffer byteBuffer = ByteBuffer.wrap(FileUtil.getBytes((File)file));
            byteBufferResponse.setByteBuffer(byteBuffer);
        } else if (response instanceof StringServletResponse) {
            StringServletResponse stringResponse = (StringServletResponse)response;
            String s = FileUtil.read((File)file);
            stringResponse.setString(s);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            try {
                int contentLength = (int)fileChannel.size();
                response.setContentLength(contentLength);
                fileChannel.transferTo(0L, contentLength, Channels.newChannel((OutputStream)response.getOutputStream()));
            }
            finally {
                fileChannel.close();
            }
        }
    }

    public static void write(HttpServletResponse response, InputStream is) throws IOException {
        ServletResponseUtil.write(response, is, 0);
    }

    public static void write(HttpServletResponse response, InputStream is, int contentLength) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        if (contentLength > 0) {
            response.setContentLength(contentLength);
        }
        StreamUtil.transfer((InputStream)is, (OutputStream)response.getOutputStream());
    }

    public static void write(HttpServletResponse response, String s) throws IOException {
        if (response instanceof StringServletResponse) {
            StringServletResponse stringResponse = (StringServletResponse)response;
            stringResponse.setString(s);
        } else {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (String)s);
            ServletResponseUtil.write(response, byteBuffer);
        }
    }

    public static void write(HttpServletResponse response, StringServletResponse stringResponse) throws IOException {
        if (stringResponse.isCalledGetOutputStream()) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = stringResponse.getUnsyncByteArrayOutputStream();
            ByteBuffer byteBuffer = unsyncByteArrayOutputStream.unsafeGetByteBuffer();
            ServletResponseUtil.write(response, byteBuffer);
        } else {
            ServletResponseUtil.write(response, stringResponse.getString());
        }
    }

    protected static void setHeaders(HttpServletRequest request, HttpServletResponse response, String fileName, String contentType) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending file of type " + contentType));
        }
        if (Validator.isNotNull((String)contentType)) {
            response.setContentType(contentType);
        }
        response.setHeader("Cache-Control", "public");
        response.setHeader("Pragma", "public");
        if (Validator.isNotNull((String)fileName)) {
            String contentDisposition;
            block11: {
                contentDisposition = "attachment; filename=\"" + fileName + "\"";
                boolean ascii = true;
                int i = 0;
                while (i < fileName.length()) {
                    if (!Validator.isAscii((char)fileName.charAt(i))) {
                        ascii = false;
                        break;
                    }
                    ++i;
                }
                try {
                    if (!ascii) {
                        String encodedFileName = HttpUtil.encodeURL((String)fileName, (boolean)true);
                        contentDisposition = BrowserSnifferUtil.isIe((HttpServletRequest)request) ? "attachment; filename=\"" + encodedFileName + "\"" : "attachment; filename*=UTF-8''" + encodedFileName;
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block11;
                    _log.warn((Throwable)e);
                }
            }
            String extension = GetterUtil.getString((String)FileUtil.getExtension((String)fileName)).toLowerCase();
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray((String)"mime.types.content.disposition.inline");
            }
            catch (Exception exception) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            if (ArrayUtil.contains((Object[])mimeTypesContentDispositionInline, (Object)extension)) {
                contentDisposition = StringUtil.replace((String)contentDisposition, (String)"attachment; ", (String)"inline; ");
            }
            response.setHeader("Content-Disposition", contentDisposition);
        }
    }
}

