package org.gcube.portal.custom.communitymanager.impl;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portal.custom.communitymanager.OrganizationManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.communitymanager.PortletsIdManager;
import org.gcube.portal.custom.communitymanager.components.GCUBELayoutTab;
import org.gcube.portal.custom.communitymanager.components.GCUBEPortlet;
import org.gcube.portal.custom.communitymanager.components.GCUBESiteLayout;
import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
/**
 * 
 * @author Massimiliano Assante, massimiliano.assante@isti.cnr.it
 * @version 1.0 - Jan 4 2012
 *
 */
public class OrganizationManagerImpl extends OrganizationsUtil implements OrganizationManager {

	private static Log _log = LogFactoryUtil.getLog(OrganizationManagerImpl.class);

	/**
	 * FIXME public as generic resource  
	 */
	protected static final String ORGANIZATION_DEFAULT_LOGO = "/org/gcube/portal/custom/communitymanager/resources/default_logo.png";

	ASLSession session = null;
	/**
	 * 
	 */
	private String screenName;
	/**
	 * 
	 */
	private static OrganizationManagerImpl singleton;
	/**
	 * 
	 * @return the singleton
	 */
	public static OrganizationManagerImpl get() {
		return singleton;
	}
	/**
	 * 
	 * @param session the ASL session
	 */
	private OrganizationManagerImpl(ASLSession session) {
		this.session = session;
		this.screenName = session.getUsername();
		singleton = this;
	}
	/**
	 * 
	 * @param session the session
	 * @return the singleton
	 */
	public static OrganizationManagerImpl getInstance(ASLSession session) {			
		return new OrganizationManagerImpl(session);		
	}

	/**
	 * 
	 * @param rootVoName the voName
	 * @param voDesc -
	 * @return the organizationid of the created VO
	 */
	public long createVO(String voName, String voDesc, long parentid, GCUBESiteLayout siteLayout,  String themeid)  {
		String email = "";
		Group voToCreate = null;
		try {			
			email = validateUser(screenName).getEmailAddress();	

			//create the Group		
			User creator = validateUser(screenName);
			GroupManager gm = new LiferayGroupManager();			
			GroupModel groupModel = null;
			_log.info("createVO " + voName + " with parentid " + parentid);	
			groupModel = gm.createVRE(voName, ""+parentid, ""+creator.getUserId(), "Description for "+voName);
			long groupModelid = Long.parseLong(groupModel.getGroupId());			
			voToCreate = OrganizationLocalServiceUtil.getOrganization(groupModelid).getGroup();

			//associate the layout to the group
			createLayout(voToCreate, validateUser(screenName), siteLayout);

			Theme themeToApply = ThemeLocalServiceUtil.getTheme(getCompany().getCompanyId(), themeid, false);

			//update theme
			LayoutSetLocalServiceUtil.updateLookAndFeel(voToCreate.getGroupId(), themeToApply.getThemeId(), "", "", false);
			_log.debug("LayoutSet Theme with id " + themeid +  " Applied Correctly");

			//update logo
			InputStream is = OrganizationManagerImpl.class.getResourceAsStream(ORGANIZATION_DEFAULT_LOGO);
			FileInputStream fis = new FileInputStream(writeTempLogo(is));
			LayoutSetLocalServiceUtil.updateLogo(voToCreate.getGroupId(), true, true, fis);

			_log.debug("Adding the Admin Role VO-Admin for this VO");			
			//add the role ADMIN
			UserManager uman = new LiferayUserManager();
			long uid = Long.parseLong(uman.getUserId(screenName));
			Role created = OrganizationsUtil.createRole("VO-Admin", voName, uid);
			_log.debug("Admin Role VO-Admin Created Successfully");	

			uman.assignUserToGroup(""+voToCreate.getClassPK(), ""+uid);
			_log.debug("Added user " + screenName + " to group " + voName + " with Success");	

			_log.debug("Assigning Role:  VO-Admin");		
			RoleManager rm = new LiferayRoleManager();
			rm.assignRoleToUser(""+voToCreate.getClassPK(), ""+created.getRoleId(), ""+uid);
			_log.debug("Admin Role VO-Admin Associated to user " + screenName +  " .... returning ...");		

		} catch (Exception e) {
			e.printStackTrace();
		} 
		_log.info("Created"  + voName  + " with id " + voToCreate.getOrganizationId());		
		return voToCreate.getOrganizationId();
	}


	/**
	 * create a VO with no parent (root VO)
	 * @param voName the voName
	 * @param voDesc -
	 * @return the id of the created VO
	 */
	public long createVO(String voName, String voDesc, GCUBESiteLayout siteLayout, String themeid) {
		return createVO(voName, voDesc, 0, siteLayout, themeid);
	}
	/**
	 * 
	 * @param rootVoName the voName
	 * @param voDesc -
	 * @return the organizationid of the created VO
	 */
	public long createVRE(String voName, String voDesc, long parentid, GCUBESiteLayout siteLayout, String themeid) {
		String email = "";
		Group voToCreate = null;
		try {			
			email = validateUser(screenName).getEmailAddress();	

			//create the Group		
			User creator = validateUser(screenName);
			GroupManager gm = new LiferayGroupManager();			
			GroupModel groupModel = null;
			_log.info("createVRE " + voName + " with parentid " + parentid);	
			groupModel = gm.createVRE(voName, ""+parentid, ""+creator.getUserId(), voDesc);
			long groupModelid = Long.parseLong(groupModel.getGroupId());			
			voToCreate = OrganizationLocalServiceUtil.getOrganization(groupModelid).getGroup();

			//associate the layout to the group
			createLayout(voToCreate, validateUser(screenName), siteLayout);

			Theme themeToApply = ThemeLocalServiceUtil.getTheme(getCompany().getCompanyId(), themeid, false);

			//update theme
			LayoutSetLocalServiceUtil.updateLookAndFeel(voToCreate.getGroupId(), themeToApply.getThemeId(), "", "", false);
			_log.debug("LayoutSet Theme with id " + themeid +  " Applied Correctly");

			//update logo
			InputStream is = OrganizationManagerImpl.class.getResourceAsStream(ORGANIZATION_DEFAULT_LOGO);
			FileInputStream fis = new FileInputStream(writeTempLogo(is));
			LayoutSetLocalServiceUtil.updateLogo(voToCreate.getGroupId(), true, true, fis);

			_log.debug("Adding the MANAGER Role VRE-Manager for this VRE");			
			//add the role ADMIN
			UserManager uman = new LiferayUserManager();
			long uid = Long.parseLong(uman.getUserId(screenName));
			Role created = OrganizationsUtil.createRole("VRE-Manager", voName, uid);
			_log.debug("Admin Role VRE-Manager Created Successfully");	

			uman.assignUserToGroup(""+voToCreate.getClassPK(), ""+uid);
			_log.debug("Added user " + screenName + " to group " + voName + " with Success");	

			_log.debug("Assigning Role:  VRE-Manager");		
			RoleManager rm = new LiferayRoleManager();
			rm.assignRoleToUser(""+voToCreate.getClassPK(), ""+created.getRoleId(), ""+uid);
			_log.debug("Admin Role VRE-Manager Associated to user " + screenName +  " .... returning ...");		

		} catch (Exception e) {
			e.printStackTrace();
		} 
		_log.info("Created"  + voName  + " with id " + voToCreate.getOrganizationId());		
		return voToCreate.getOrganizationId();
	}
	
	/**
	 * 
	 * @return the built layout of a rootVO
	 * @throws SystemException .
	 * @throws PortalException .
	 */
	public static GCUBESiteLayout getBaseLayout(String voName, OrganizationManagerImpl orgManager, boolean isVO, String username) throws PortalException, SystemException {
		GCUBESiteLayout siteLayout = null;
		String email = validateUser(username).getEmailAddress();
		siteLayout = new GCUBESiteLayout(OrganizationManagerImpl.getCompany(), voName, email);			
		siteLayout.addTab(new GCUBELayoutTab(voName, GCUBELayoutType.ONE_COL,
				new GCUBEPortlet("gCube Loggedin", PortletsIdManager.getLRPortletId(PortletsIdManager.GCUBE_LOGGEDIN))));

		//create tab Users and Roles with 2 subtabs
		GCUBELayoutTab usersAndRoles = new GCUBELayoutTab("Administration", GCUBELayoutType.ONE_COL, 
				new GCUBEPortlet("Navigation", PortletsIdManager.getLRPortletId(PortletsIdManager.LR_NAVIGATION)));
		GCUBELayoutTab usersTab = new GCUBELayoutTab("Manage User and Requests", GCUBELayoutType.ONE_COL, 
				new GCUBEPortlet("Users", PortletsIdManager.getLRPortletId(PortletsIdManager.GCUBE_USERS_MANAGE)));
		GCUBELayoutTab usersAddTab = new GCUBELayoutTab("Add new Users", GCUBELayoutType.ONE_COL, 
				new GCUBEPortlet("Users", PortletsIdManager.getLRPortletId(PortletsIdManager.GCUBE_ADD_USERS_MANAGE)));
		GCUBELayoutTab rolesTab = new GCUBELayoutTab("Add new Roles", GCUBELayoutType.ONE_COL, 
				new GCUBEPortlet("Roles", PortletsIdManager.getLRPortletId(PortletsIdManager.GCUBE_ROLES_MANAGE)));
		usersAndRoles.addSubTab(usersTab);
		usersAndRoles.addSubTab(usersAddTab);
		usersAndRoles.addSubTab(rolesTab);
		//add the tab
		siteLayout.addTab(usersAndRoles);
		if (isVO)
			siteLayout.addTab(new GCUBELayoutTab("Resources Management", GCUBELayoutType.ONE_COL, 
					new GCUBEPortlet("Resources Management", PortletsIdManager.getLRPortletId(PortletsIdManager.RESOURCES_MANAGEMENT))));
		else
			siteLayout.addTab(new GCUBELayoutTab("Calendar", GCUBELayoutType.ONE_COL, 
					new GCUBEPortlet("Calendar", PortletsIdManager.getLRPortletId(PortletsIdManager.LR_CALENDAR)), true));
		return siteLayout;
	}


	/***
	 * simple helper method
	 * @param inputStream
	 * @return
	 */
	private File writeTempLogo(InputStream inputStream) {
		try {
			File temp = File.createTempFile("logoimage", ".png");
			// write the inputStream to a FileOutputStream
			FileOutputStream out = new FileOutputStream(temp);
			int read = 0;
			byte[] bytes = new byte[1024];
			while ((read = inputStream.read(bytes)) != -1) 
				out.write(bytes, 0, read);
			inputStream.close();
			out.flush();
			out.close();
			return temp;
		} catch (IOException e) {
			return null;
		}
	}	
}
