/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Types;

public class StringChunk
extends Chunk {
    private String value;

    public StringChunk(int chunkId, boolean newStyleString) {
        this(chunkId, StringChunk.getStringType(newStyleString));
    }

    private static int getStringType(boolean newStyleString) {
        if (newStyleString) {
            return Types.NEW_STRING;
        }
        return Types.OLD_STRING;
    }

    public StringChunk(int chunkId, int type) {
        this.chunkId = chunkId;
        this.type = type;
    }

    public ByteArrayOutputStream getValueByteArray() {
        return null;
    }

    public void setValue(ByteArrayOutputStream value) {
        String tmpValue;
        if (this.type == Types.NEW_STRING) {
            try {
                tmpValue = new String(value.toByteArray(), "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Core encoding not found, JVM broken?", e);
            }
        }
        try {
            tmpValue = new String(value.toByteArray(), "CP1252");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Core encoding not found, JVM broken?", e);
        }
        this.value = tmpValue.replace("\u0000", "");
    }

    public String toString() {
        return this.value;
    }
}

