/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp;

import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.TCPWriterMirror;
import java.net.URI;
import java.net.URISyntaxException;

public class TCPWriterProxy
implements IWriterProxy {
    private String key = null;
    private URI locator = null;
    private String hostname = TCPConnectionManager.GetConnectionManagerHostName();
    private int port = TCPConnectionManager.GetConnectionManagerPort();
    private IMirror mirror = null;

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setKey(String key) throws GRS2ProxyInvalidOperationException {
        if (this.locator != null) {
            throw new GRS2ProxyInvalidOperationException("Key for locator already set");
        }
        this.key = key;
    }

    @Override
    public IMirror bind() throws GRS2ProxyInvalidOperationException {
        if (this.key == null || this.key.trim().length() == 0) {
            throw new GRS2ProxyInvalidOperationException("Buffer key is not set");
        }
        if (this.mirror == null) {
            this.mirror = new TCPWriterMirror();
        }
        return this.mirror;
    }

    @Override
    public URI getLocator() throws GRS2ProxyInvalidOperationException, GRS2ProxyInvalidArgumentException {
        if (this.locator != null) {
            return this.locator;
        }
        if (this.key == null || this.key.trim().length() == 0) {
            throw new GRS2ProxyInvalidOperationException("Buffer key is not set");
        }
        try {
            this.locator = new URI("grs2-proxy", null, this.hostname, this.port, null, "key=" + this.key, IProxy.ProxyType.TCP.toString());
        }
        catch (URISyntaxException e) {
            throw new GRS2ProxyInvalidArgumentException("Could not create locator URI", e);
        }
        return this.locator;
    }

    public static boolean isOfType(URI locator) {
        if (!locator.getScheme().equalsIgnoreCase("grs2-proxy".toString())) {
            return false;
        }
        return locator.getFragment().equalsIgnoreCase(IProxy.ProxyType.TCP.toString());
    }
}

