/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.abdera.protocol.client.util.NonOpTrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SimpleSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLContext context = null;

    public SimpleSSLProtocolSocketFactory(TrustManager trustManager) {
        this.init(trustManager);
    }

    public SimpleSSLProtocolSocketFactory() {
        this(new NonOpTrustManager());
    }

    private void init(TrustManager trustManager) {
        try {
            this.context = SSLContext.getInstance("SSL");
            this.context.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Socket createSocket(Socket socket, String host, int port, boolean close) throws IOException, UnknownHostException {
        return this.context.getSocketFactory().createSocket(socket, host, port, close);
    }

    public Socket createSocket(String host, int port, InetAddress chost, int cport) throws IOException, UnknownHostException {
        return this.context.getSocketFactory().createSocket(host, port, chost, cport);
    }

    public Socket createSocket(String host, int port, InetAddress chost, int cport, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        return this.context.getSocketFactory().createSocket(host, port, chost, cport);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.context.getSocketFactory().createSocket(host, port);
    }
}

