/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa;

import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.mapping.Cascade;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;

public abstract class AbstractCompassJpaEntityListener {
    protected Log log = LogFactory.getLog(this.getClass());
    private CompassTemplate compassTemplate;

    protected abstract Compass getCompass();

    protected boolean throwExceptionOnError() {
        return true;
    }

    protected boolean disable() {
        return false;
    }

    protected boolean hasMappingForEntity(Class clazz, Cascade cascade) {
        ResourceMapping resourceMapping = ((InternalCompass)this.getCompass()).getMapping().getMappingByClass(clazz);
        if (resourceMapping == null) {
            return false;
        }
        if (resourceMapping.isRoot()) {
            return true;
        }
        return resourceMapping.operationAllowed(cascade);
    }

    protected boolean hasMappingForEntity(String name, Cascade cascade) {
        ResourceMapping resourceMapping = ((InternalCompass)this.getCompass()).getMapping().getMappingByAlias(name);
        if (resourceMapping != null) {
            if (resourceMapping.isRoot()) {
                return true;
            }
            return resourceMapping.operationAllowed(cascade);
        }
        try {
            Class clazz = ClassUtils.forName(name, this.getCompass().getSettings().getClassLoader());
            resourceMapping = ((InternalCompass)this.getCompass()).getMapping().getMappingByClass(clazz);
            if (resourceMapping.isRoot()) {
                return true;
            }
            return resourceMapping.operationAllowed(cascade);
        }
        catch (Exception e) {
            return false;
        }
    }

    @PostPersist
    public void postPersist(final Object entity) throws CompassException {
        block5: {
            if (this.disable()) {
                return;
            }
            if (!this.hasMappingForEntity(entity.getClass(), Cascade.CREATE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Creating [" + entity + "]"));
                }
                this.getCompassTemplate().execute(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.create(entity);
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while creating [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while creating [" + entity + "]", e);
            }
        }
    }

    @PostUpdate
    public void postUpdate(final Object entity) throws CompassException {
        block5: {
            if (this.disable()) {
                return;
            }
            if (!this.hasMappingForEntity(entity.getClass(), Cascade.SAVE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Updating [" + entity + "]"));
                }
                this.getCompassTemplate().execute(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.save(entity);
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while updating [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while unpdating [" + entity + "]", e);
            }
        }
    }

    @PostRemove
    public void postRemove(final Object entity) throws CompassException {
        block5: {
            if (this.disable()) {
                return;
            }
            if (!this.hasMappingForEntity(entity.getClass(), Cascade.DELETE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Removing [" + entity + "]"));
                }
                this.getCompassTemplate().execute(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.delete(entity);
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while removing [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while removing [" + entity + "]", e);
            }
        }
    }

    private CompassTemplate getCompassTemplate() {
        if (this.compassTemplate == null) {
            this.compassTemplate = new CompassTemplate(this.getCompass());
        }
        return this.compassTemplate;
    }
}

