/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.embedded;

import java.util.Properties;
import org.compass.core.Compass;
import org.compass.core.CompassTemplate;
import org.compass.gps.CompassGps;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.embedded.CompassEventListener;
import org.compass.gps.impl.SingleCompassGps;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.impl.SessionFactoryImpl;

public abstract class HibernateHelper {
    private HibernateHelper() {
    }

    public static Compass getCompass(org.hibernate.Session session) {
        return HibernateHelper.findEventListener(session).getCompass();
    }

    public static CompassTemplate getCompassTempalte(org.hibernate.Session session) {
        return new CompassTemplate(HibernateHelper.findEventListener(session).getCompass());
    }

    public static Compass getCompass(SessionFactory sessionFactory) {
        return HibernateHelper.findEventListener(sessionFactory).getCompass();
    }

    public static CompassTemplate getCompassTempalte(SessionFactory sessionFactory) {
        return new CompassTemplate(HibernateHelper.findEventListener(sessionFactory).getCompass());
    }

    public static Properties getIndexSettings(org.hibernate.Session session) {
        return HibernateHelper.findEventListener(session).getIndexSettings();
    }

    public static Properties getIndexSettings(SessionFactory sessionFactory) {
        return HibernateHelper.findEventListener(sessionFactory).getIndexSettings();
    }

    public static CompassGps getCompassGps(SessionFactory sessionFactory) {
        HibernateGpsDevice device = new HibernateGpsDevice("hibernate", sessionFactory);
        return HibernateHelper.getCompassGps(device);
    }

    public static CompassGps getCompassGps(HibernateGpsDevice device) {
        SingleCompassGps gps = new SingleCompassGps(HibernateHelper.getCompass(device.getSessionFactory()));
        device.setMirrorDataChanges(false);
        gps.setIndexProperties(HibernateHelper.getIndexSettings(device.getSessionFactory()));
        gps.addGpsDevice(device);
        gps.start();
        return gps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompassEventListener findEventListener(SessionFactory sessionFactory) {
        if (sessionFactory instanceof SessionFactoryImpl) {
            PostInsertEventListener[] listeners = ((SessionFactoryImpl)sessionFactory).getEventListeners().getPostInsertEventListeners();
            return HibernateHelper.findEventListener(listeners);
        }
        Session session = sessionFactory.openSession();
        try {
            CompassEventListener compassEventListener = HibernateHelper.findEventListener((org.hibernate.Session)session);
            return compassEventListener;
        }
        finally {
            session.close();
        }
    }

    private static CompassEventListener findEventListener(org.hibernate.Session session) {
        PostInsertEventListener[] listeners = ((SessionImplementor)session).getListeners().getPostInsertEventListeners();
        return HibernateHelper.findEventListener(listeners);
    }

    private static CompassEventListener findEventListener(PostInsertEventListener[] listeners) {
        for (PostInsertEventListener candidate : listeners) {
            if (!(candidate instanceof CompassEventListener)) continue;
            return (CompassEventListener)candidate;
        }
        throw new HibernateException("Compass Event listeners not configured, please check the reference documentation and the application's hibernate.cfg.xml");
    }
}

