/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.jdom;

import java.util.Map;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.XmlXPathExpression;
import org.compass.core.xml.jdom.JDomXmlXPathExpression;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDomXmlObject
implements XmlObject {
    private Element element;
    private Attribute attribute;
    private Map<String, String> namespaces;

    public JDomXmlObject(Document document) {
        this.element = document.getRootElement();
    }

    public JDomXmlObject(Document document, Map<String, String> namespaces) {
        this.element = document.getRootElement();
        this.namespaces = namespaces;
    }

    public JDomXmlObject(Element element) {
        this.element = element;
    }

    public JDomXmlObject(Element element, Map<String, String> namespaces) {
        this.element = element;
        this.namespaces = namespaces;
    }

    public JDomXmlObject(Attribute attribute) {
        this.attribute = attribute;
    }

    public JDomXmlObject(Attribute attribute, Map<String, String> namespaces) {
        this.attribute = attribute;
        this.namespaces = namespaces;
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getName() {
        if (this.attribute != null) {
            return this.attribute.getName();
        }
        return this.element.getName();
    }

    @Override
    public String getValue() {
        if (this.attribute != null) {
            return this.attribute.getValue();
        }
        return this.element.getText();
    }

    @Override
    public XmlObject[] selectPath(String path) throws Exception {
        return this.compile(path).select(this);
    }

    @Override
    public boolean canCompileXpath() {
        return true;
    }

    @Override
    public XmlXPathExpression compile(String path) throws JDOMException {
        XPath xpath = XPath.newInstance((String)path);
        if (this.namespaces != null) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                xpath.addNamespace(entry.getKey(), entry.getValue());
            }
        }
        return new JDomXmlXPathExpression(xpath);
    }

    public Element getElement() {
        return this.element;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }
}

