/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.async;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.transaction.async.AsyncTransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.support.AbstractJobBasedTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJobs;

public class AsyncTransactionProcessor
extends AbstractJobBasedTransactionProcessor {
    private static final Log logger = LogFactory.getLog(AsyncTransactionProcessor.class);
    private final AsyncTransactionProcessorFactory processorFactory;
    private boolean committed = false;

    public AsyncTransactionProcessor(LuceneSearchEngine searchEngine, AsyncTransactionProcessorFactory processorFactory) {
        super(logger, searchEngine, true);
        this.processorFactory = processorFactory;
    }

    public String getName() {
        return "async";
    }

    protected void doPrepare(TransactionJobs jobs) throws SearchEngineException {
    }

    protected void doFlushCommit(TransactionJobs jobs) {
        this.processorFactory.add(jobs);
    }

    protected void doCommit(boolean onePhase, TransactionJobs jobs) throws SearchEngineException {
        this.processorFactory.add(jobs);
        this.committed = true;
    }

    protected void doRollback(TransactionJobs jobs) throws SearchEngineException {
        if (this.committed) {
            this.processorFactory.remove(jobs);
        }
    }
}

