/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.accessor.PropertyAccessorFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.internal.InternalObjectMapping;
import org.compass.core.util.reflection.ReflectionFactory;

public class PropertyAccessorMappingProcessor
implements MappingProcessor {
    private PropertyAccessorFactory propertyAccessorFactory;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.propertyAccessorFactory = new PropertyAccessorFactory();
        this.propertyAccessorFactory.configure(settings);
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            if (!(aliasMapping instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)aliasMapping;
            classMapping.setConstructor(ReflectionFactory.getDefaultConstructor(settings, classMapping.getClazz()));
            if (!(Modifier.isAbstract(classMapping.getClazz().getModifiers()) || Modifier.isInterface(classMapping.getClazz().getModifiers()) || classMapping.getClazz().isEnum() || classMapping.getConstructor() != null)) {
                throw new MappingException("No default constructor defined for class [" + classMapping.getName() + "]");
            }
            if (classMapping.getPolyClass() != null) {
                classMapping.setPolyConstructor(ReflectionFactory.getDefaultConstructor(settings, classMapping.getPolyClass()));
            }
            Class clazz = classMapping.getClazz();
            if (classMapping.isPoly() && classMapping.getPolyClass() != null) {
                clazz = classMapping.getPolyClass();
            }
            Iterator<Mapping> it = classMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping(it.next(), clazz, settings);
            }
        }
        return compassMapping;
    }

    private void processMapping(Mapping mapping, Class clazz, CompassSettings settings) throws MappingException {
        if (!(mapping instanceof ObjectMapping)) {
            return;
        }
        ObjectMapping objectMapping = (ObjectMapping)mapping;
        PropertyAccessor pAccessor = this.propertyAccessorFactory.getPropertyAccessor(objectMapping.getAccessor(), settings);
        ((InternalObjectMapping)objectMapping).setGetter(pAccessor.getGetter(clazz, objectMapping.getPropertyName()));
        ((InternalObjectMapping)objectMapping).setSetter(pAccessor.getSetter(clazz, objectMapping.getPropertyName()));
        if (mapping instanceof MultipleMapping) {
            MultipleMapping multipleMapping = (MultipleMapping)mapping;
            Iterator<Mapping> it = multipleMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping(it.next(), clazz, settings);
            }
        }
    }
}

