/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.StandardMetaDataImpl;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class StandardMBean
implements DynamicMBean {
    private static final String dbgTag = "StandardMBean";
    private Class mbeanInterface;
    private Object implementation;
    private final StandardMetaDataImpl meta;
    private MBeanInfo cachedMBeanInfo;

    private StandardMBean(Object object, Class clazz, boolean bl) throws NotCompliantMBeanException {
        if (object == null) {
            if (bl) {
                object = this;
            } else {
                throw new IllegalArgumentException("implementation is null");
            }
        }
        this.meta = new StandardMBeanMeta();
        this.setImplementation(object, clazz);
    }

    public StandardMBean(Object object, Class clazz) throws NotCompliantMBeanException {
        this(object, clazz, false);
    }

    protected StandardMBean(Class clazz) throws NotCompliantMBeanException {
        this(null, clazz, true);
    }

    public synchronized void setImplementation(Object object) throws NotCompliantMBeanException {
        this.setImplementation(object, this.getMBeanInterface());
    }

    private synchronized void setImplementation(Object object, Class clazz) throws NotCompliantMBeanException {
        if (object == null) {
            throw new IllegalArgumentException("implementation is null");
        }
        this.meta.testCompliance(object.getClass(), clazz);
        this.cacheMBeanInfo(null);
        this.implementation = object;
        this.mbeanInterface = clazz;
        if (this.mbeanInterface == null) {
            this.mbeanInterface = this.meta.getStandardMBeanInterface(object.getClass());
        }
    }

    public synchronized Object getImplementation() {
        return this.implementation;
    }

    public final synchronized Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public synchronized Class getImplementationClass() {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.getClass();
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.meta.getAttribute(this.getImplementation(), string);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.meta.setAttribute(this.getImplementation(), attribute);
    }

    public AttributeList getAttributes(String[] stringArray) {
        try {
            return this.meta.getAttributes(this.getImplementation(), stringArray);
        }
        catch (ReflectionException reflectionException) {
            UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(reflectionException, reflectionException.getMessage());
            throw new RuntimeOperationsException(undeclaredThrowableException, reflectionException.getMessage());
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        try {
            return this.meta.setAttributes(this.getImplementation(), attributeList);
        }
        catch (ReflectionException reflectionException) {
            UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(reflectionException, reflectionException.getMessage());
            throw new RuntimeOperationsException(undeclaredThrowableException, reflectionException.getMessage());
        }
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return this.meta.invoke(this.getImplementation(), string, objectArray, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo() {
        Object object;
        Object object2;
        MBeanInfo mBeanInfo;
        try {
            mBeanInfo = this.getCachedMBeanInfo();
            if (mBeanInfo != null) {
                return mBeanInfo;
            }
        }
        catch (RuntimeException runtimeException) {
            StandardMBean.debug("getMBeanInfo", "failed to get cached MBeanInfo: " + runtimeException);
            StandardMBean.debugX("getMBeanInfo", runtimeException);
        }
        if (StandardMBean.isTraceOn()) {
            StandardMBean.trace("getMBeanInfo", "Building MBeanInfo for " + this.getImplementationClass().getName());
        }
        try {
            object2 = this;
            synchronized (object2) {
                object = this.getImplementation();
                mBeanInfo = this.buildStandardMBeanInfo();
            }
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(notCompliantMBeanException, notCompliantMBeanException.getMessage());
            throw new RuntimeOperationsException(undeclaredThrowableException, notCompliantMBeanException.getMessage());
        }
        object2 = this.getClassName(mBeanInfo);
        String string = this.getDescription(mBeanInfo);
        MBeanConstructorInfo[] mBeanConstructorInfoArray = this.getConstructors(mBeanInfo, object);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.getAttributes(mBeanInfo);
        MBeanOperationInfo[] mBeanOperationInfoArray = this.getOperations(mBeanInfo);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.getNotifications(mBeanInfo);
        MBeanInfo mBeanInfo2 = new MBeanInfo((String)object2, string, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        try {
            this.cacheMBeanInfo(mBeanInfo2);
        }
        catch (RuntimeException runtimeException) {
            StandardMBean.debug("cacheMBeanInfo", "failed to cache MBeanInfo: " + runtimeException);
            StandardMBean.debugX("cacheMBeanInfo", runtimeException);
        }
        return mBeanInfo2;
    }

    protected String getClassName(MBeanInfo mBeanInfo) {
        if (mBeanInfo == null) {
            return this.getImplementationClass().getName();
        }
        return mBeanInfo.getClassName();
    }

    protected String getDescription(MBeanInfo mBeanInfo) {
        if (mBeanInfo == null) {
            return null;
        }
        return mBeanInfo.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo mBeanFeatureInfo) {
        if (mBeanFeatureInfo == null) {
            return null;
        }
        return mBeanFeatureInfo.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanConstructorInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getName();
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanOperationInfo);
    }

    protected int getImpact(MBeanOperationInfo mBeanOperationInfo) {
        if (mBeanOperationInfo == null) {
            return 3;
        }
        return mBeanOperationInfo.getImpact();
    }

    protected String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getName();
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        return mBeanParameterInfo.getDescription();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] mBeanConstructorInfoArray, Object object) {
        if (mBeanConstructorInfoArray == null) {
            return null;
        }
        if (object != null && object != this) {
            return null;
        }
        return mBeanConstructorInfoArray;
    }

    private MBeanNotificationInfo[] getNotifications(MBeanInfo mBeanInfo) {
        if (mBeanInfo == null) {
            return null;
        }
        return mBeanInfo.getNotifications();
    }

    protected synchronized MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    protected synchronized void cacheMBeanInfo(MBeanInfo mBeanInfo) {
        this.cachedMBeanInfo = mBeanInfo;
    }

    private synchronized MBeanInfo buildStandardMBeanInfo() throws NotCompliantMBeanException {
        return this.meta.buildMBeanInfo(this.getImplementationClass(), this.getMBeanInterface());
    }

    private MBeanConstructorInfo[] getConstructors(MBeanInfo mBeanInfo, Object object) {
        MBeanConstructorInfo[] mBeanConstructorInfoArray;
        MBeanConstructorInfo[] mBeanConstructorInfoArray2 = this.getConstructors(mBeanInfo.getConstructors(), object);
        if (mBeanConstructorInfoArray2 != null) {
            int n = mBeanConstructorInfoArray2.length;
            mBeanConstructorInfoArray = new MBeanConstructorInfo[n];
            for (int i = 0; i < n; ++i) {
                MBeanParameterInfo[] mBeanParameterInfoArray;
                MBeanConstructorInfo mBeanConstructorInfo = mBeanConstructorInfoArray2[i];
                MBeanParameterInfo[] mBeanParameterInfoArray2 = mBeanConstructorInfo.getSignature();
                if (mBeanParameterInfoArray2 != null) {
                    int n2 = mBeanParameterInfoArray2.length;
                    mBeanParameterInfoArray = new MBeanParameterInfo[n2];
                    for (int j = 0; j < n2; ++j) {
                        MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray2[j];
                        String string = this.getParameterName(mBeanConstructorInfo, mBeanParameterInfo, j);
                        String string2 = this.getDescription(mBeanConstructorInfo, mBeanParameterInfo, j);
                        mBeanParameterInfoArray[j] = new MBeanParameterInfo(string, mBeanParameterInfo.getType(), string2);
                    }
                } else {
                    mBeanParameterInfoArray = null;
                }
                mBeanConstructorInfoArray[i] = new MBeanConstructorInfo(mBeanConstructorInfo.getName(), this.getDescription(mBeanConstructorInfo), mBeanParameterInfoArray);
            }
        } else {
            mBeanConstructorInfoArray = null;
        }
        return mBeanConstructorInfoArray;
    }

    private MBeanOperationInfo[] getOperations(MBeanInfo mBeanInfo) {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray2 = mBeanInfo.getOperations();
        if (mBeanOperationInfoArray2 != null) {
            int n = mBeanOperationInfoArray2.length;
            mBeanOperationInfoArray = new MBeanOperationInfo[n];
            for (int i = 0; i < n; ++i) {
                MBeanParameterInfo[] mBeanParameterInfoArray;
                MBeanOperationInfo mBeanOperationInfo = mBeanOperationInfoArray2[i];
                MBeanParameterInfo[] mBeanParameterInfoArray2 = mBeanOperationInfo.getSignature();
                if (mBeanParameterInfoArray2 != null) {
                    int n2 = mBeanParameterInfoArray2.length;
                    mBeanParameterInfoArray = new MBeanParameterInfo[n2];
                    for (int j = 0; j < n2; ++j) {
                        MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray2[j];
                        String string = this.getParameterName(mBeanOperationInfo, mBeanParameterInfo, j);
                        String string2 = this.getDescription(mBeanOperationInfo, mBeanParameterInfo, j);
                        mBeanParameterInfoArray[j] = new MBeanParameterInfo(string, mBeanParameterInfo.getType(), string2);
                    }
                } else {
                    mBeanParameterInfoArray = null;
                }
                mBeanOperationInfoArray[i] = new MBeanOperationInfo(mBeanOperationInfo.getName(), this.getDescription(mBeanOperationInfo), mBeanParameterInfoArray, mBeanOperationInfo.getReturnType(), this.getImpact(mBeanOperationInfo));
            }
        } else {
            mBeanOperationInfoArray = null;
        }
        return mBeanOperationInfoArray;
    }

    private MBeanAttributeInfo[] getAttributes(MBeanInfo mBeanInfo) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = mBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray2 != null) {
            int n = mBeanAttributeInfoArray2.length;
            mBeanAttributeInfoArray = new MBeanAttributeInfo[n];
            for (int i = 0; i < n; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray2[i];
                mBeanAttributeInfoArray[i] = new MBeanAttributeInfo(mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), this.getDescription(mBeanAttributeInfo), mBeanAttributeInfo.isReadable(), mBeanAttributeInfo.isWritable(), mBeanAttributeInfo.isIs());
            }
        } else {
            mBeanAttributeInfoArray = null;
        }
        return mBeanAttributeInfoArray;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)16);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)16, (String)string, (String)string2, (String)string3);
    }

    private static void trace(String string, String string2) {
        StandardMBean.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)16);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)16, (String)string, (String)string2, (String)string3);
    }

    private static void debug(String string, String string2) {
        StandardMBean.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (StandardMBean.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            StandardMBean.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            StandardMBean.debug(dbgTag, string, string2);
        }
    }

    private final class StandardMBeanMeta
    extends StandardMetaDataImpl {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MBeanInfo getCachedMBeanInfo(Class clazz) {
            if (clazz == null) {
                return null;
            }
            StandardMBean standardMBean = StandardMBean.this;
            synchronized (standardMBean) {
                Class clazz2 = StandardMBean.this.getImplementationClass();
                if (clazz2 == null) {
                    return null;
                }
                if (!clazz.equals(clazz2)) {
                    return null;
                }
                return StandardMBean.this.getMBeanInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class getCachedMBeanInterface(Class clazz) {
            StandardMBean standardMBean = StandardMBean.this;
            synchronized (standardMBean) {
                Class clazz2 = StandardMBean.this.getImplementationClass();
                if (clazz2 == null) {
                    return null;
                }
                if (!clazz.equals(clazz2)) {
                    return null;
                }
                return StandardMBean.this.getMBeanInterface();
            }
        }

        protected void cacheMBeanInfo(Class clazz, Class clazz2, MBeanInfo mBeanInfo) {
        }
    }
}

