/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.net.CachingMessageProducer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DatacenterReadCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.RepairCallback;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    private static final boolean OPTIMIZE_LOCAL_REQUESTS = true;
    private static final LatencyTracker readStats = new LatencyTracker();
    private static final LatencyTracker rangeStats = new LatencyTracker();
    private static final LatencyTracker writeStats = new LatencyTracker();
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;
    private static volatile boolean hintedHandoffEnabled;
    private static volatile int maxHintWindow;
    private static volatile int maxHintsInProgress;
    private static final AtomicInteger totalHintsInProgress;
    private static final Map<InetAddress, AtomicInteger> hintsInProgress;
    private static final AtomicLong totalHints;

    private StorageProxy() {
    }

    public static void mutate(List<? extends IMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, TimeoutException {
        logger.debug("Mutations/ConsistencyLevel are {}/{}", mutations, (Object)consistency_level);
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        long startTime = System.nanoTime();
        ArrayList<IWriteResponseHandler> responseHandlers = new ArrayList<IWriteResponseHandler>();
        IMutation mostRecentMutation = null;
        try {
            Iterator<IMutation> i$ = mutations.iterator();
            while (i$.hasNext()) {
                IMutation mutation;
                mostRecentMutation = mutation = i$.next();
                if (mutation instanceof CounterMutation) {
                    responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)mutation, localDataCenter));
                    continue;
                }
                responseHandlers.add(StorageProxy.performWrite(mutation, consistency_level, localDataCenter, standardWritePerformer));
            }
            for (IWriteResponseHandler responseHandler : responseHandlers) {
                responseHandler.get();
            }
        }
        catch (TimeoutException ex) {
            ClientRequestMetrics.writeTimeouts.inc();
            if (logger.isDebugEnabled()) {
                ArrayList<String> mstrings = new ArrayList<String>();
                for (IMutation iMutation : mutations) {
                    mstrings.add(iMutation.toString(true));
                }
                logger.debug("Write timeout {} for one (or more) of: ", (Object)ex.toString(), mstrings);
            }
            throw ex;
        }
        catch (UnavailableException e) {
            ClientRequestMetrics.writeUnavailables.inc();
            throw e;
        }
        catch (IOException e) {
            assert (mostRecentMutation != null);
            throw new RuntimeException("error writing key " + ByteBufferUtil.bytesToHex(mostRecentMutation.key()), e);
        }
        finally {
            writeStats.addNano(System.nanoTime() - startTime);
        }
    }

    public static IWriteResponseHandler performWrite(IMutation mutation, ConsistencyLevel consistency_level, String localDataCenter, WritePerformer performer) throws UnavailableException, TimeoutException, IOException {
        String table = mutation.getTable();
        AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(table, mutation.key());
        IWriteResponseHandler responseHandler = rs.getWriteResponseHandler(writeEndpoints, consistency_level);
        responseHandler.assureSufficientLiveNodes();
        performer.apply(mutation, writeEndpoints, responseHandler, localDataCenter, consistency_level);
        return responseHandler;
    }

    private static Collection<InetAddress> getWriteEndpoints(String table, ByteBuffer key) {
        StorageService ss = StorageService.instance;
        Object tk = StorageService.getPartitioner().getToken(key);
        List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, (RingPosition)tk);
        return ss.getTokenMetadata().getWriteEndpoints((Token)tk, table, (Collection<InetAddress>)naturalEndpoints);
    }

    public static void sendToHintedEndpoints(RowMutation rm, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException, TimeoutException {
        HashMap<String, Multimap<Message, InetAddress>> dcMessages = new HashMap<String, Multimap<Message, InetAddress>>(targets.size());
        CachingMessageProducer producer = new CachingMessageProducer(rm);
        for (InetAddress destination : targets) {
            if (totalHintsInProgress.get() > maxHintsInProgress && hintsInProgress.get(destination).get() > 0 && StorageProxy.shouldHint(destination)) {
                throw new TimeoutException();
            }
            if (FailureDetector.instance.isAlive(destination)) {
                String dc;
                Multimap messages;
                if (destination.equals(FBUtilities.getBroadcastAddress())) {
                    StorageProxy.insertLocal(rm, responseHandler);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing key " + ByteBufferUtil.bytesToHex(rm.key()) + " to " + destination);
                }
                if ((messages = (Multimap)dcMessages.get(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination))) == null) {
                    messages = HashMultimap.create();
                    dcMessages.put(dc, (Multimap<Message, InetAddress>)messages);
                }
                messages.put((Object)producer.getMessage(Gossiper.instance.getVersion(destination)), (Object)destination);
                continue;
            }
            if (!StorageProxy.shouldHint(destination)) continue;
            StorageProxy.scheduleLocalHint(rm, destination, responseHandler, consistency_level);
        }
        StorageProxy.sendMessages(localDataCenter, dcMessages, responseHandler);
    }

    public static Future<Void> scheduleLocalHint(final RowMutation mutation, final InetAddress target, final IWriteResponseHandler responseHandler, final ConsistencyLevel consistencyLevel) throws IOException {
        assert (!target.equals(FBUtilities.getBroadcastAddress())) : target;
        totalHintsInProgress.incrementAndGet();
        final AtomicInteger targetHints = hintsInProgress.get(target);
        targetHints.incrementAndGet();
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding hint for " + target);
                }
                try {
                    Token token = StorageService.instance.getTokenMetadata().getToken(target);
                    ByteBuffer tokenbytes = StorageService.getPartitioner().getTokenFactory().toByteArray(token);
                    RowMutation hintedMutation = RowMutation.hintFor(mutation, tokenbytes);
                    hintedMutation.apply();
                    totalHints.incrementAndGet();
                    if (responseHandler != null && consistencyLevel == ConsistencyLevel.ANY) {
                        responseHandler.response(null);
                    }
                }
                finally {
                    totalHintsInProgress.decrementAndGet();
                    targetHints.decrementAndGet();
                }
            }
        };
        return StageManager.getStage(Stage.MUTATION).submit(runnable);
    }

    private static void sendMessages(String localDataCenter, Map<String, Multimap<Message, InetAddress>> dcMessages, IWriteResponseHandler handler) throws IOException {
        for (Map.Entry<String, Multimap<Message, InetAddress>> entry : dcMessages.entrySet()) {
            String dataCenter = entry.getKey();
            for (Map.Entry messages : entry.getValue().asMap().entrySet()) {
                Message message = (Message)messages.getKey();
                message = message.withHeaderRemoved("FORWARD");
                Iterator iter = ((Collection)messages.getValue()).iterator();
                InetAddress target = (InetAddress)iter.next();
                if (dataCenter.equals(localDataCenter) || Gossiper.instance.getVersion(target) < 4) {
                    MessagingService.instance().sendRR(message, target, (IMessageCallback)handler);
                    while (iter.hasNext()) {
                        target = (InetAddress)iter.next();
                        MessagingService.instance().sendRR(message, target, (IMessageCallback)handler);
                    }
                    continue;
                }
                FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeInt(((Collection)messages.getValue()).size() - 1);
                while (iter.hasNext()) {
                    InetAddress destination = (InetAddress)iter.next();
                    CompactEndpointSerializationHelper.serialize(destination, dos);
                    String id = MessagingService.instance().addCallback(handler, message, destination);
                    dos.writeUTF(id);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Adding FWD message to: " + destination + " with ID " + id);
                }
                message = message.withHeaderAdded("FORWARD", bos.toByteArray());
                String id = MessagingService.instance().sendRR(message, target, (IMessageCallback)handler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Sending message to: " + target + " with ID " + id);
            }
        }
    }

    private static void insertLocal(final RowMutation rm, final IWriteResponseHandler responseHandler) {
        if (logger.isDebugEnabled()) {
            logger.debug("insert writing local " + rm.toString(true));
        }
        DroppableRunnable runnable = new DroppableRunnable(StorageService.Verb.MUTATION){

            @Override
            public void runMayThrow() throws IOException {
                rm.apply();
                responseHandler.response(null);
            }
        };
        StageManager.getStage(Stage.MUTATION).execute(runnable);
    }

    public static IWriteResponseHandler mutateCounter(CounterMutation cm, String localDataCenter) throws UnavailableException, TimeoutException, IOException {
        InetAddress endpoint = StorageProxy.findSuitableEndpoint(cm.getTable(), cm.key(), localDataCenter);
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter);
        }
        String table = cm.getTable();
        AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(table, cm.key());
        rs.getWriteResponseHandler(writeEndpoints, cm.consistency()).assureSufficientLiveNodes();
        IWriteResponseHandler responseHandler = WriteResponseHandler.create(endpoint);
        Message message = cm.makeMutationMessage(Gossiper.instance.getVersion(endpoint));
        if (logger.isDebugEnabled()) {
            logger.debug("forwarding counter update of key " + ByteBufferUtil.bytesToHex(cm.key()) + " to " + endpoint);
        }
        MessagingService.instance().sendRR(message, endpoint, (IMessageCallback)responseHandler);
        return responseHandler;
    }

    private static InetAddress findSuitableEndpoint(String table, ByteBuffer key, String localDataCenter) throws UnavailableException {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(table, key);
        if (endpoints.isEmpty()) {
            throw new UnavailableException();
        }
        ArrayList<InetAddress> localEndpoints = new ArrayList<InetAddress>();
        for (InetAddress endpoint : endpoints) {
            if (!snitch.getDatacenter(endpoint).equals(localDataCenter)) continue;
            localEndpoints.add(endpoint);
        }
        if (localEndpoints.isEmpty()) {
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
            return endpoints.get(0);
        }
        return (InetAddress)localEndpoints.get(FBUtilities.threadLocalRandom().nextInt(localEndpoints.size()));
    }

    public static IWriteResponseHandler applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter) throws UnavailableException, TimeoutException, IOException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer);
    }

    public static IWriteResponseHandler applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter) throws UnavailableException, TimeoutException, IOException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final Collection<InetAddress> targets, final IWriteResponseHandler responseHandler, final String localDataCenter, final ConsistencyLevel consistency_level) {
        return new DroppableRunnable(StorageService.Verb.MUTATION){

            @Override
            public void runMayThrow() throws IOException {
                assert (mutation instanceof CounterMutation);
                final CounterMutation cm = (CounterMutation)mutation;
                cm.apply();
                responseHandler.response(null);
                targets.remove(FBUtilities.getBroadcastAddress());
                if (cm.shouldReplicateOnWrite() && !targets.isEmpty()) {
                    StageManager.getStage(Stage.REPLICATE_ON_WRITE).execute(new DroppableRunnable(StorageService.Verb.READ){

                        @Override
                        public void runMayThrow() throws IOException, TimeoutException {
                            StorageProxy.sendToHintedEndpoints(cm.makeReplicationMutation(), targets, responseHandler, localDataCenter, consistency_level);
                        }
                    });
                }
            }
        };
    }

    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException, InvalidRequestException {
        List<Row> rows;
        if (StorageService.instance.isBootstrapMode()) {
            ClientRequestMetrics.readUnavailables.inc();
            throw new UnavailableException();
        }
        long startTime = System.nanoTime();
        try {
            rows = StorageProxy.fetchRows(commands, consistency_level);
        }
        catch (UnavailableException e) {
            ClientRequestMetrics.readUnavailables.inc();
            throw e;
        }
        catch (TimeoutException e) {
            ClientRequestMetrics.readTimeouts.inc();
            throw e;
        }
        finally {
            readStats.addNano(System.nanoTime() - startTime);
        }
        return rows;
    }

    private static List<Row> fetchRows(List<ReadCommand> initialCommands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        ArrayList<Row> rows = new ArrayList<Row>(initialCommands.size());
        List commandsToRetry = Collections.emptyList();
        do {
            int i;
            IAsyncCallback handler;
            List<ReadCommand> commands = commandsToRetry.isEmpty() ? initialCommands : commandsToRetry;
            ReadCallback[] readCallbacks = new ReadCallback[commands.size()];
            if (!commandsToRetry.isEmpty()) {
                logger.debug("Retrying {} commands", (Object)commandsToRetry.size());
            }
            for (int i2 = 0; i2 < commands.size(); ++i2) {
                ReadCommand command = commands.get(i2);
                assert (!command.isDigestQuery());
                logger.debug("Command/ConsistencyLevel is {}/{}", (Object)command, (Object)consistency_level);
                List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(command.table, command.key);
                DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
                RowDigestResolver resolver = new RowDigestResolver(command.table, command.key);
                handler = StorageProxy.getReadCallback(resolver, command, consistency_level, endpoints);
                ((ReadCallback)handler).assureSufficientLiveNodes();
                assert (!((ReadCallback)handler).endpoints.isEmpty());
                readCallbacks[i2] = handler;
                InetAddress dataPoint = ((ReadCallback)handler).endpoints.get(0);
                if (dataPoint.equals(FBUtilities.getBroadcastAddress())) {
                    logger.debug("reading data locally");
                    StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(command, (ReadCallback<Row>)handler));
                } else {
                    logger.debug("reading data from {}", (Object)dataPoint);
                    MessagingService.instance().sendRR(command, dataPoint, handler);
                }
                if (((ReadCallback)handler).endpoints.size() == 1) continue;
                ReadCommand digestCommand = command.copy();
                digestCommand.setDigestQuery(true);
                CachingMessageProducer producer = null;
                for (InetAddress digestPoint : ((ReadCallback)handler).endpoints.subList(1, ((ReadCallback)handler).endpoints.size())) {
                    if (digestPoint.equals(FBUtilities.getBroadcastAddress())) {
                        logger.debug("reading digest locally");
                        StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(digestCommand, (ReadCallback<Row>)handler));
                        continue;
                    }
                    logger.debug("reading digest from {}", (Object)digestPoint);
                    if (producer == null) {
                        producer = new CachingMessageProducer(digestCommand);
                    }
                    MessagingService.instance().sendRR(producer, digestPoint, handler);
                }
            }
            ArrayList<ReadCommand> repairCommands = null;
            ArrayList<RepairCallback> repairResponseHandlers = null;
            for (i = 0; i < commands.size(); ++i) {
                ReadCallback handler2 = readCallbacks[i];
                ReadCommand command = commands.get(i);
                try {
                    long startTime2 = System.currentTimeMillis();
                    Row row = (Row)handler2.get();
                    if (row != null) {
                        command.maybeTrim(row);
                        rows.add(row);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Read: " + (System.currentTimeMillis() - startTime2) + " ms.");
                    continue;
                }
                catch (TimeoutException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Read timeout: {}", (Object)ex.toString());
                    }
                    throw ex;
                }
                catch (DigestMismatchException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Digest mismatch: {}", (Object)ex.toString());
                    }
                    RowRepairResolver resolver = new RowRepairResolver(command.table, command.key);
                    RepairCallback repairHandler = new RepairCallback(resolver, handler2.endpoints);
                    if (repairCommands == null) {
                        repairCommands = new ArrayList<ReadCommand>();
                        repairResponseHandlers = new ArrayList<RepairCallback>();
                    }
                    repairCommands.add(command);
                    repairResponseHandlers.add(repairHandler);
                    CachingMessageProducer producer = new CachingMessageProducer(command);
                    for (InetAddress endpoint : handler2.endpoints) {
                        MessagingService.instance().sendRR(producer, endpoint, repairHandler);
                    }
                }
            }
            if (commandsToRetry != Collections.EMPTY_LIST) {
                commandsToRetry.clear();
            }
            if (repairResponseHandlers == null) continue;
            for (i = 0; i < repairCommands.size(); ++i) {
                Row row;
                ReadCommand command = (ReadCommand)repairCommands.get(i);
                handler = (RepairCallback)repairResponseHandlers.get(i);
                FBUtilities.waitOnFutures(((RepairCallback)handler).resolver.repairResults, DatabaseDescriptor.getRpcTimeout());
                try {
                    row = ((RepairCallback)handler).get();
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                ReadCommand retryCommand = command.maybeGenerateRetryCommand((RepairCallback)handler, row);
                if (retryCommand != null) {
                    logger.debug("issuing retry for read command");
                    if (commandsToRetry == Collections.EMPTY_LIST) {
                        commandsToRetry = new ArrayList();
                    }
                    commandsToRetry.add(retryCommand);
                    continue;
                }
                if (row == null) continue;
                command.maybeTrim(row);
                rows.add(row);
            }
        } while (!commandsToRetry.isEmpty());
        return rows;
    }

    static <T> ReadCallback<T> getReadCallback(IResponseResolver<T> resolver, IReadCommand command, ConsistencyLevel consistencyLevel, List<InetAddress> endpoints) {
        if (consistencyLevel == ConsistencyLevel.LOCAL_QUORUM || consistencyLevel == ConsistencyLevel.EACH_QUORUM) {
            return new DatacenterReadCallback((IResponseResolver)resolver, consistencyLevel, command, endpoints);
        }
        return new ReadCallback<T>(resolver, consistencyLevel, command, endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> getRangeSlice(RangeSliceCommand command, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        ArrayList<Row> rows;
        if (logger.isDebugEnabled()) {
            logger.debug("Command/ConsistencyLevel is {}/{}", (Object)command.toString(), (Object)consistency_level);
        }
        long startTime = System.nanoTime();
        try {
            int columnsCount = 0;
            rows = new ArrayList<Row>();
            List<AbstractBounds<RowPosition>> ranges = StorageProxy.getRestrictedRanges(command.range);
            for (AbstractBounds<RowPosition> range : ranges) {
                int count;
                RangeSliceCommand nodeCmd = new RangeSliceCommand(command.keyspace, command.column_family, command.super_column, command.predicate, range, command.row_filter, command.maxResults, command.maxIsColumns, command.isPaging);
                List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(nodeCmd.keyspace, (RingPosition)range.right);
                DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), liveEndpoints);
                if (consistency_level == ConsistencyLevel.ONE && !liveEndpoints.isEmpty() && liveEndpoints.get(0).equals(FBUtilities.getBroadcastAddress())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("local range slice");
                    }
                    try {
                        rows.addAll(RangeSliceVerbHandler.executeLocally(nodeCmd));
                        for (Row row : rows) {
                            columnsCount += row.getLiveColumnCount();
                        }
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(nodeCmd.keyspace);
                ReadCallback<Iterable<Row>> handler = StorageProxy.getReadCallback(resolver, nodeCmd, consistency_level, liveEndpoints);
                handler.assureSufficientLiveNodes();
                resolver.setSources(handler.endpoints);
                for (InetAddress endpoint : handler.endpoints) {
                    MessagingService.instance().sendRR(nodeCmd, endpoint, handler);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("reading " + nodeCmd + " from " + endpoint);
                }
                try {
                    for (Row row : handler.get()) {
                        rows.add(row);
                        columnsCount += row.getLiveColumnCount();
                        logger.debug("range slices read {}", row.key);
                    }
                    FBUtilities.waitOnFutures(resolver.repairResults, DatabaseDescriptor.getRpcTimeout());
                }
                catch (TimeoutException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Range slice timeout: {}", (Object)ex.toString());
                    }
                    throw ex;
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                if ((count = nodeCmd.maxIsColumns ? columnsCount : rows.size()) < nodeCmd.maxResults) continue;
                break;
            }
        }
        finally {
            rangeStats.addNano(System.nanoTime() - startTime);
        }
        return StorageProxy.trim(command, rows);
    }

    private static List<Row> trim(RangeSliceCommand command, List<Row> rows) {
        if (command.maxIsColumns) {
            return rows;
        }
        return rows.size() > command.maxResults ? rows.subList(0, command.maxResults) : rows;
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = Schema.instance.getVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback cb = new IAsyncCallback(){

            @Override
            public void response(Message message) {
                logger.debug("Received schema check response from {}", (Object)message.getFrom().getHostAddress());
                UUID theirVersion = UUID.fromString(new String(message.getMessageBody()));
                versions.put(message.getFrom(), theirVersion);
                latch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        for (InetAddress endpoint : liveHosts) {
            Message message = new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.SCHEMA_CHECK, ArrayUtils.EMPTY_BYTE_ARRAY, Gossiper.instance.getVersion(endpoint));
            MessagingService.instance().sendRR(message, endpoint, (IMessageCallback)cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        logger.debug("My version is {}", (Object)myVersion);
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: {}", (Object)StringUtils.join((Collection)((Collection)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("{} disagrees ({})", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static <T extends RingPosition> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        Token upperBoundToken;
        Object upperBound;
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.isMinimum(StorageService.getPartitioner())) {
            if (logger.isDebugEnabled()) {
                logger.debug("restricted single token match for query {}", queryRange);
            }
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<T>> ranges = new ArrayList<AbstractBounds<T>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left.getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (remainder.left.equals(upperBound = (upperBoundToken = ringIter.next()).upperBound(queryRange.left.getClass())) || remainder.contains(upperBound))) {
            Pair<AbstractBounds<T>, AbstractBounds<T>> splits = remainder.split(upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<T>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        if (logger.isDebugEnabled()) {
            logger.debug("restricted ranges for query {} are {}", queryRange, ranges);
        }
        return ranges;
    }

    @Override
    public long getReadOperations() {
        return readStats.getOpCount();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return readStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalReadLatencyHistogramMicros() {
        return readStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return readStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getRangeOperations() {
        return rangeStats.getOpCount();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return rangeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalRangeLatencyHistogramMicros() {
        return rangeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentRangeLatencyHistogramMicros() {
        return rangeStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getWriteOperations() {
        return writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalWriteLatencyHistogramMicros() {
        return writeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return writeStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        hintedHandoffEnabled = b;
    }

    @Override
    public int getMaxHintWindow() {
        return maxHintWindow;
    }

    @Override
    public void setMaxHintWindow(int ms) {
        maxHintWindow = ms;
    }

    public static boolean shouldHint(InetAddress ep) {
        boolean hintWindowExpired;
        if (!hintedHandoffEnabled) {
            return false;
        }
        boolean bl = hintWindowExpired = Gossiper.instance.getEndpointDowntime(ep) > (long)maxHintWindow;
        if (hintWindowExpired) {
            logger.debug("not hinting {} which has been down {}ms", (Object)ep, (Object)Gossiper.instance.getEndpointDowntime(ep));
        }
        return !hintWindowExpired;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF ", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            throw new UnavailableException();
        }
        Set<InetAddress> allEndpoints = Gossiper.instance.getLiveMembers();
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        logger.debug("Starting to send truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        CachingMessageProducer producer = new CachingMessageProducer(truncation);
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(producer, endpoint, responseHandler);
        }
        logger.debug("Sent all truncate messages, now waiting for {} responses", (Object)blockFor);
        responseHandler.get();
        logger.debug("truncate done");
    }

    private static boolean isAnyHostDown() {
        return !Gossiper.instance.getUnreachableMembers().isEmpty();
    }

    @Override
    public long getTotalHints() {
        return totalHints.get();
    }

    @Override
    public int getMaxHintsInProgress() {
        return maxHintsInProgress;
    }

    @Override
    public void setMaxHintsInProgress(int qs) {
        maxHintsInProgress = qs;
    }

    @Override
    public int getHintsInProgress() {
        return totalHintsInProgress.get();
    }

    public void verifyNoHintsInProgress() {
        if (this.getHintsInProgress() > 0) {
            logger.warn("Some hints were not written before shutdown.  This is not supposed to happen.  You should (a) run repair, and (b) file a bug report");
        }
    }

    @Override
    public Long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout();
    }

    @Override
    public void setRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRpcTimeout(timeoutInMillis);
    }

    static {
        instance = new StorageProxy();
        hintedHandoffEnabled = DatabaseDescriptor.hintedHandoffEnabled();
        maxHintWindow = DatabaseDescriptor.getMaxHintWindow();
        maxHintsInProgress = 1024 * Runtime.getRuntime().availableProcessors();
        totalHintsInProgress = new AtomicInteger();
        hintsInProgress = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new Function<InetAddress, AtomicInteger>(){

            public AtomicInteger apply(InetAddress inetAddress) {
                return new AtomicInteger(0);
            }
        });
        totalHints = new AtomicLong();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName("org.apache.cassandra.db:type=StorageProxy"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        standardWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException, TimeoutException {
                assert (mutation instanceof RowMutation);
                StorageProxy.sendToHintedEndpoints((RowMutation)mutation, targets, responseHandler, localDataCenter, consistency_level);
            }
        };
        counterWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing local & replicate " + mutation.toString(true));
                }
                Runnable runnable = StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter, consistency_level);
                runnable.run();
            }
        };
        counterWriteOnCoordinatorPerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing local & replicate " + mutation.toString(true));
                }
                Runnable runnable = StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter, consistency_level);
                StageManager.getStage(Stage.MUTATION).execute(runnable);
            }
        };
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        private final long constructionTime = System.currentTimeMillis();
        private final StorageService.Verb verb;

        public DroppableRunnable(StorageService.Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            if (System.currentTimeMillis() > this.constructionTime + DatabaseDescriptor.getRpcTimeout()) {
                MessagingService.instance().incrementDroppedMessages(this.verb);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, Collection<InetAddress> var2, IWriteResponseHandler var3, String var4, ConsistencyLevel var5) throws IOException, TimeoutException;
    }

    static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback<Row> handler;
        private final long start = System.currentTimeMillis();

        LocalReadRunnable(ReadCommand command, ReadCallback<Row> handler) {
            super(StorageService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("LocalReadRunnable reading " + this.command);
            }
            Table table = Table.open(this.command.table);
            Row r = this.command.getRow(table);
            ReadResponse result = ReadVerbHandler.getResponse(this.command, r);
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), System.currentTimeMillis() - this.start);
            this.handler.response(result);
        }
    }
}

