/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.MigrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRequestVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRequestVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        logger.debug("Received migration request from {}.", (Object)message.getFrom());
        try {
            Message response = message.getInternalReply(MigrationManager.serializeSchema(SystemTable.serializeSchema(), message.getVersion()), message.getVersion());
            MessagingService.instance().sendReply(response, id, message.getFrom());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

