/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.filetransfer;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.channel.rendezvous.GetFileRendezvous;
import org.walluck.oscar.channel.rendezvous.SendFileRendezvous;
import org.walluck.oscar.handlers.ICBMHandler;
import org.walluck.oscar.handlers.filetransfer.FTTLV;
import org.walluck.oscar.handlers.filetransfer.FileTransferTool;

public class FileTransfer {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$filetransfer$FileTransfer == null ? (class$org$walluck$oscar$handlers$filetransfer$FileTransfer = FileTransfer.class$("org.walluck.oscar.handlers.filetransfer.FileTransfer")) : class$org$walluck$oscar$handlers$filetransfer$FileTransfer).getName());
    private AIMSession sess;
    private static HashMap transfers;
    private String localIPAddress;
    private byte[] byteIPAddress;
    private int localPort = 1024 + new Random().nextInt(64512);
    private boolean wantResponse;
    static /* synthetic */ Class class$org$walluck$oscar$handlers$filetransfer$FileTransfer;

    public FileTransfer(AIMSession sess) {
        try {
            this.sess = sess;
            this.localIPAddress = InetAddress.getLocalHost().getHostAddress();
            this.byteIPAddress = InetAddress.getLocalHost().getAddress();
            transfers = new HashMap(1);
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"UnknownHostException", (Throwable)uhe);
        }
    }

    public static long calculateChecksum(String name, long start, long stop) throws IOException {
        if (start > stop) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        long checksum = -65536L;
        long check = checksum >> 16 & 0xFFFFL;
        DataInputStream dis = new DataInputStream(new FileInputStream(name));
        if (start > 0L) {
            byte[] tmp = new byte[(int)start];
            dis.read(tmp, 0, (int)start);
            i = (int)((long)i + start);
        }
        while (dis.available() > 0 && (long)i != stop) {
            long oldcheck = check;
            int byteVal = dis.read() & 0xFF;
            int val = (i & 1) != 0 ? byteVal : byteVal << 8;
            if ((check -= (long)val) > oldcheck) {
                --check;
            }
            ++i;
        }
        dis.close();
        check = (check & 0xFFFFL) + (check >> 16);
        check = (check & 0xFFFFL) + (check >> 16);
        checksum = check << 16 & 0xFFFFFFFFFFFFFFFFL;
        return checksum;
    }

    public void getFileRequest(byte[] cookie, String screenname) {
        FTTLV fttlv = new FTTLV(18, 2, 1L, null);
        GetFileRendezvous rv = new GetFileRendezvous();
        rv.setFTTLV(fttlv);
        rv.setPort(this.localPort);
        try {
            rv.setRequest();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            LOG.debug((Object)("GET FILE ==> " + screenname + "::" + fttlv.getName()));
            im.sendRendezvous(this.sess, screenname, rv);
            LOG.debug((Object)"GET FILE ==> starting thread");
            FileTransferTool ft = new FileTransferTool(this.sess, this, null, cookie, screenname, fttlv, this.localIPAddress, this.localPort);
            transfers.put(cookie, ft);
            ft.setListener(true);
            ft.setSender(false);
            ft.setGetFile(true);
            ft.setSendFile(false);
            ft.start();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void getFileAccept(byte[] cookie, byte[] rCookie, String screenname, String remoteIPAddress, int remotePort) {
        transfers.remove(rCookie);
        GetFileRendezvous rv = new GetFileRendezvous();
        rv.setCookie(rCookie);
        try {
            rv.setAccept();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, screenname, rv);
            FileTransferTool ft = new FileTransferTool(this.sess, this, cookie, rCookie, screenname, null, remoteIPAddress, remotePort);
            ft.setSendFile(false);
            ft.setGetFile(true);
            ft.setListener(false);
            ft.setSender(true);
            ft.start();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void getFileCancel(byte[] cookie, byte[] rCookie, String screenname, String remoteIPAddress, int remotePort) {
        transfers.remove(rCookie);
        GetFileRendezvous rv = new GetFileRendezvous();
        rv.setCookie(rCookie);
        try {
            rv.setCancel();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void sendFileRequest(byte[] cookie, String screenname, int type, int fileCount, int dirSize, String fileName, String message) {
        FTTLV fttlv = new FTTLV(type, fileCount, dirSize, AIMUtil.dirSysToAOL(fileName));
        SendFileRendezvous rv = new SendFileRendezvous();
        rv.setCookie(cookie);
        rv.setFTTLV(fttlv);
        rv.setPort(this.localPort);
        try {
            rv.setRequest();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            LOG.debug((Object)("SEND FILE ==> " + screenname + "::" + fttlv.getName()));
            im.sendRendezvous(this.sess, screenname, rv);
            LOG.debug((Object)"SEND FILE ==> starting thread");
            FileTransferTool ft = new FileTransferTool(this.sess, this, null, cookie, screenname, fttlv, this.localIPAddress, this.localPort);
            transfers.put(cookie, ft);
            ft.setSendFile(true);
            ft.setGetFile(false);
            ft.setListener(true);
            ft.setSender(true);
            ft.start();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void sendFileAccept(byte[] cookie, byte[] rCookie, String screenname, String remoteIPAddress, int remotePort) {
        transfers.remove(rCookie);
        SendFileRendezvous rv = new SendFileRendezvous();
        rv.setCookie(rCookie);
        try {
            rv.setAccept();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            LOG.debug((Object)"Sending SendFile Accept...");
            im.sendRendezvous(this.sess, screenname, rv);
            LOG.debug((Object)"Starting File Transfer tool...");
            FileTransferTool ft = new FileTransferTool(this.sess, this, cookie, rCookie, screenname, null, remoteIPAddress, remotePort);
            ft.setSendFile(true);
            ft.setGetFile(false);
            ft.setListener(false);
            ft.setSender(false);
            ft.start();
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void sendFileCancel(byte[] cookie, byte[] rCookie, String screenname, String remoteIPAddress, int remotePort) {
        transfers.remove(rCookie);
        SendFileRendezvous rv = new SendFileRendezvous();
        rv.setCookie(rCookie);
        try {
            rv.setCancel();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public void removeTransfer(byte[] rCookie) {
        transfers.remove(rCookie);
    }

    public boolean wantResponse() {
        return this.wantResponse;
    }

    public void setWantResponse(boolean wantResponse) {
        this.wantResponse = wantResponse;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

