/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.dyn.CallSite;
import java.dyn.Linkage;
import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.MethodVisitor;

public class InvokeDynamicSupport {
    private static final MethodType BOOTSTRAP_TYPE = MethodType.make(CallSite.class, Class.class, (Class[])new Class[]{String.class, MethodType.class});
    private static final MethodHandle BOOTSTRAP = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "bootstrap", BOOTSTRAP_TYPE);
    private static final MethodHandle GETMETHOD;
    private static final MethodHandle PGC;
    private static final MethodHandle TEST;
    private static final MethodHandle PGC_0;
    private static final MethodHandle GETMETHOD_0;
    private static final MethodHandle TEST_0;
    private static final MethodHandle TARGET_0;
    private static final MethodHandle FALLBACK_0;
    private static final MethodHandle PGC_1;
    private static final MethodHandle GETMETHOD_1;
    private static final MethodHandle TEST_1;
    private static final MethodHandle TARGET_1;
    private static final MethodHandle FALLBACK_1;
    private static final MethodHandle PGC_2;
    private static final MethodHandle GETMETHOD_2;
    private static final MethodHandle TEST_2;
    private static final MethodHandle TARGET_2;
    private static final MethodHandle FALLBACK_2;
    private static final MethodHandle PGC_3;
    private static final MethodHandle GETMETHOD_3;
    private static final MethodHandle TEST_3;
    private static final MethodHandle TARGET_3;
    private static final MethodHandle FALLBACK_3;
    private static final MethodHandle PGC_N;
    private static final MethodHandle GETMETHOD_N;
    private static final MethodHandle TEST_N;
    private static final MethodHandle TARGET_N;
    private static final MethodHandle FALLBACK_N;
    private static final MethodHandle BREAKJUMP;
    private static final MethodHandle RETRYJUMP;
    private static final MethodHandle PGC_0_B;
    private static final MethodHandle GETMETHOD_0_B;
    private static final MethodHandle TEST_0_B;
    private static final MethodHandle TARGET_0_B;
    private static final MethodHandle FALLBACK_0_B;
    private static final MethodHandle PGC_1_B;
    private static final MethodHandle GETMETHOD_1_B;
    private static final MethodHandle TEST_1_B;
    private static final MethodHandle TARGET_1_B;
    private static final MethodHandle FALLBACK_1_B;
    private static final MethodHandle PGC_2_B;
    private static final MethodHandle GETMETHOD_2_B;
    private static final MethodHandle TEST_2_B;
    private static final MethodHandle TARGET_2_B;
    private static final MethodHandle FALLBACK_2_B;
    private static final MethodHandle PGC_3_B;
    private static final MethodHandle GETMETHOD_3_B;
    private static final MethodHandle TEST_3_B;
    private static final MethodHandle TARGET_3_B;
    private static final MethodHandle FALLBACK_3_B;
    private static final MethodHandle PGC_N_B;
    private static final MethodHandle GETMETHOD_N_B;
    private static final MethodHandle TEST_N_B;
    private static final MethodHandle TARGET_N_B;
    private static final MethodHandle FALLBACK_N_B;

    public static CallSite bootstrap(Class caller, String name2, MethodType type2) {
        JRubyCallSite site = name2 == "call" ? new JRubyCallSite(caller, name2, type2, CallType.NORMAL) : new JRubyCallSite(caller, name2, type2, CallType.FUNCTIONAL);
        MethodType fallbackType = type2.insertParameterType(0, JRubyCallSite.class);
        MethodHandle myFallback = MethodHandles.insertArguments((MethodHandle)MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", fallbackType), (int)0, (Object[])new Object[]{site});
        site.setTarget(myFallback);
        return site;
    }

    public static void registerBootstrap(Class cls) {
        Linkage.registerBootstrapMethod((Class)cls, (MethodHandle)BOOTSTRAP);
    }

    public static void installBytecode(MethodVisitor method2, String classname) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(method2);
        mv.ldc(CodegenUtils.c(classname));
        mv.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        mv.invokestatic(CodegenUtils.p(InvokeDynamicSupport.class), "registerBootstrap", CodegenUtils.sig(Void.TYPE, Class.class));
    }

    private static MethodHandle createGWT(MethodHandle test2, MethodHandle target, MethodHandle fallback, CacheEntry entry, CallSite site) {
        MethodHandle myTest = MethodHandles.insertArguments((MethodHandle)test2, (int)0, (Object[])new Object[]{entry});
        MethodHandle myTarget = MethodHandles.insertArguments((MethodHandle)target, (int)0, (Object[])new Object[]{entry});
        MethodHandle myFallback = MethodHandles.insertArguments((MethodHandle)fallback, (int)0, (Object[])new Object[]{site});
        MethodHandle guardWithTest = MethodHandles.guardWithTest((MethodHandle)myTest, (MethodHandle)myTarget, (MethodHandle)myFallback);
        return MethodHandles.convertArguments((MethodHandle)guardWithTest, (MethodType)site.type());
    }

    public static boolean test(CacheEntry entry, IRubyObject self) {
        return entry.typeOk(self.getMetaClass());
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_0, TARGET_0, FALLBACK_0, entry, site));
        return entry.method.call(context, self, selfClass, name2);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject arg0) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_1, TARGET_1, FALLBACK_1, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_2, TARGET_2, FALLBACK_2, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_3, TARGET_3, FALLBACK_3, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, arg2);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject[] args2) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_N, TARGET_N, FALLBACK_N, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, Block block) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        try {
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, block);
                return iRubyObject;
            }
            site.setTarget(InvokeDynamicSupport.createGWT(TEST_0_B, TARGET_0_B, FALLBACK_0_B, entry, site));
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        try {
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, block);
                return iRubyObject;
            }
            site.setTarget(InvokeDynamicSupport.createGWT(TEST_1_B, TARGET_1_B, FALLBACK_1_B, entry, site));
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        try {
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, block);
                return iRubyObject;
            }
            site.setTarget(InvokeDynamicSupport.createGWT(TEST_2_B, TARGET_2_B, FALLBACK_2_B, entry, site));
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        try {
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            site.setTarget(InvokeDynamicSupport.createGWT(TEST_3_B, TARGET_3_B, FALLBACK_3_B, entry, site));
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        try {
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2, block);
                return iRubyObject;
            }
            site.setTarget(InvokeDynamicSupport.createGWT(TEST_N_B, TARGET_N_B, FALLBACK_N_B, entry, site));
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, args2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    protected static boolean methodMissing(CacheEntry entry, CallType callType, String name2, IRubyObject caller) {
        DynamicMethod method2 = entry.method;
        return method2.isUndefined() || callType == CallType.NORMAL && !name2.equals("method_missing") && !method2.isCallableFrom(caller, callType);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, args2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, args2, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    public static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    public static IRubyObject handleBreakJump(JumpException.BreakJump bj, ThreadContext context) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    private static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject retryJumpError(ThreadContext context) {
        throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }

    public static final DynamicMethod getMethod(CacheEntry entry) {
        return entry.method;
    }

    private static MethodHandle dropNameAndArgs(MethodHandle original, int index2, int count2, boolean block) {
        switch (count2) {
            case -1: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject[].class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject[].class});
            }
            case 0: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class});
            }
            case 1: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class});
            }
            case 2: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class});
            }
            case 3: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class});
            }
        }
        throw new RuntimeException("Invalid arg count (" + count2 + ") while preparing method handle:\n\t" + original);
    }

    static {
        MethodHandle getMethod = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "getMethod", MethodType.make(DynamicMethod.class, CacheEntry.class));
        getMethod = MethodHandles.dropArguments((MethodHandle)getMethod, (int)0, (Class[])new Class[]{RubyClass.class});
        GETMETHOD = getMethod = MethodHandles.dropArguments((MethodHandle)getMethod, (int)2, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class});
        PGC = MethodHandles.dropArguments((MethodHandle)MethodHandles.dropArguments((MethodHandle)MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "pollAndGetClass", MethodType.make(RubyClass.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class})), (int)1, (Class[])new Class[]{IRubyObject.class}), (int)0, (Class[])new Class[]{CacheEntry.class});
        TEST = MethodHandles.dropArguments((MethodHandle)MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "test", MethodType.make(Boolean.TYPE, CacheEntry.class, (Class[])new Class[]{IRubyObject.class})), (int)1, (Class[])new Class[]{ThreadContext.class, IRubyObject.class});
        PGC_0 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 0, false);
        GETMETHOD_0 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 0, false);
        TEST_0 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 0, false);
        MethodHandle target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class}), (int[])new int[]{0, 3, 5, 1, 6});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_0);
        TARGET_0 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_0);
        FALLBACK_0 = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class}));
        PGC_1 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 1, false);
        GETMETHOD_1 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 1, false);
        TEST_1 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 1, false);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class}), (int[])new int[]{0, 3, 5, 1, 6, 7});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_1);
        TARGET_1 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_1);
        FALLBACK_1 = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class}));
        PGC_2 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 2, false);
        GETMETHOD_2 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 2, false);
        TEST_2 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 2, false);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_2);
        TARGET_2 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_2);
        FALLBACK_2 = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class}));
        PGC_3 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 3, false);
        GETMETHOD_3 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 3, false);
        TEST_3 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 3, false);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8, 9});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_3);
        TARGET_3 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_3);
        FALLBACK_3 = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}));
        PGC_N = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, -1, false);
        GETMETHOD_N = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, -1, false);
        TEST_N = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, -1, false);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject[].class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class}), (int[])new int[]{0, 3, 5, 1, 6, 7});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_N);
        TARGET_N = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_N);
        FALLBACK_N = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class}));
        MethodHandle breakJump = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "handleBreakJump", MethodType.make(IRubyObject.class, JumpException.BreakJump.class, (Class[])new Class[]{ThreadContext.class}));
        BREAKJUMP = breakJump = MethodHandles.permuteArguments((MethodHandle)breakJump, (MethodType)MethodType.make(IRubyObject.class, JumpException.BreakJump.class, (Class[])new Class[]{CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{0, 2});
        MethodHandle retryJump = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "retryJumpError", MethodType.make(IRubyObject.class, ThreadContext.class));
        RETRYJUMP = retryJump = MethodHandles.permuteArguments((MethodHandle)retryJump, (MethodType)MethodType.make(IRubyObject.class, JumpException.RetryJump.class, (Class[])new Class[]{CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{2});
        PGC_0_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 0, true);
        GETMETHOD_0_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 0, true);
        TEST_0_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 0, true);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_0_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_0_B);
        MethodHandle breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 0, true);
        MethodHandle retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 0, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_0_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_0_B = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, Block.class}));
        PGC_1_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 1, true);
        GETMETHOD_1_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 1, true);
        TEST_1_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 1, true);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_1_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_1_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 1, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 1, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_1_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_1_B = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, Block.class}));
        PGC_2_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 2, true);
        GETMETHOD_2_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 2, true);
        TEST_2_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 2, true);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8, 9});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_2_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_2_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 2, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 2, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_2_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_2_B = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}));
        PGC_3_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 3, true);
        GETMETHOD_3_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 3, true);
        TEST_3_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 3, true);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8, 9, 10});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_3_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_3_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 3, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 3, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_3_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_3_B = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}));
        PGC_N_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, -1, true);
        GETMETHOD_N_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, -1, true);
        TEST_N_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, -1, true);
        target = MethodHandles.lookup().findVirtual(DynamicMethod.class, "call", MethodType.make(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject[].class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.make(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_N_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_N_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, -1, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, -1, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_N_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_N_B = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "fallback", MethodType.make(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class}));
    }

    public static class JRubyCallSite
    extends CallSite {
        private final CallType callType;

        public JRubyCallSite(Class caller, String name2, MethodType type2, CallType callType) {
            super((Object)caller, name2, type2);
            this.callType = callType;
        }

        public CallType callType() {
            return this.callType;
        }
    }
}

