/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JittedMethod
extends DynamicMethod
implements PositionAware {
    private final StaticScope staticScope;
    private final Script jitCompiledScript;
    private final ISourcePosition position;
    private final Arity arity;
    private final DefaultMethod realMethod;

    public JittedMethod(RubyModule implementationClass, StaticScope staticScope, Script jitCompiledScript, CallConfiguration jitCallConfig, Visibility visibility, Arity arity2, ISourcePosition position, DefaultMethod realMethod) {
        super(implementationClass, visibility, jitCallConfig);
        this.position = position;
        this.jitCompiledScript = jitCompiledScript;
        this.staticScope = staticScope;
        this.arity = arity2;
        this.realMethod = realMethod;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public DynamicMethod getRealMethod() {
        return this.realMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, block, args2.length);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args2, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, args2.length);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 0);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, block, 0);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 1);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, block, 1);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 2);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, block, 2);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 3);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, self, name2, block, 3);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    protected void pre(ThreadContext context, IRubyObject self, String name2, Block block, int argsLength) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name2, block, this.staticScope);
        this.getArity().checkArity(context.getRuntime(), argsLength);
    }

    protected void post(Ruby runtime2, ThreadContext context, String name2) {
        this.callConfig.post(context);
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public int getLine() {
        return this.position.getLine();
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new JittedMethod(this.getImplementationClass(), this.staticScope, this.jitCompiledScript, this.callConfig, this.getVisibility(), this.arity, this.position, this.realMethod);
    }
}

