/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.HeapStruct;
import org.jruby.ext.posix.POSIX;

public abstract class BaseHeapFileStat
extends HeapStruct
implements FileStat {
    protected final POSIX posix;

    public BaseHeapFileStat(POSIX posix) {
        this.posix = posix;
    }

    public String ftype() {
        if (this.isFile()) {
            return "file";
        }
        if (this.isDirectory()) {
            return "directory";
        }
        if (this.isCharDev()) {
            return "characterSpecial";
        }
        if (this.isBlockDev()) {
            return "blockSpecial";
        }
        if (this.isFifo()) {
            return "fifo";
        }
        if (this.isSymlink()) {
            return "link";
        }
        if (this.isSocket()) {
            return "socket";
        }
        return "unknown";
    }

    public boolean groupMember(int gid2) {
        return this.posix.getgid() == gid2 || this.posix.getegid() == gid2;
    }

    public boolean isBlockDev() {
        return (this.mode() & 0xF000) == 24576;
    }

    public boolean isCharDev() {
        return (this.mode() & 0xF000) == 8192;
    }

    public boolean isDirectory() {
        return (this.mode() & 0xF000) == 16384;
    }

    public boolean isEmpty() {
        return this.st_size() == 0L;
    }

    public boolean isExecutable() {
        if (this.posix.geteuid() == 0) {
            return (this.mode() & 0x49) != 0;
        }
        if (this.isOwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) != 0;
    }

    public boolean isExecutableReal() {
        if (this.posix.getuid() == 0) {
            return (this.mode() & 0x49) != 0;
        }
        if (this.isROwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) != 0;
    }

    public boolean isFile() {
        return (this.mode() & 0xF000) == 32768;
    }

    public boolean isFifo() {
        return (this.mode() & 0xF000) == 4096;
    }

    public boolean isGroupOwned() {
        return this.groupMember(this.gid());
    }

    public boolean isIdentical(FileStat other) {
        return this.dev() == other.dev() && this.ino() == other.ino();
    }

    public boolean isNamedPipe() {
        return (this.mode() & 0x1000) != 0;
    }

    public boolean isOwned() {
        return this.posix.geteuid() == this.uid();
    }

    public boolean isROwned() {
        return this.posix.getuid() == this.uid();
    }

    public boolean isReadable() {
        if (this.posix.geteuid() == 0) {
            return true;
        }
        if (this.isOwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) != 0;
    }

    public boolean isReadableReal() {
        if (this.posix.getuid() == 0) {
            return true;
        }
        if (this.isROwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) != 0;
    }

    public boolean isSetgid() {
        return (this.mode() & 0x400) != 0;
    }

    public boolean isSetuid() {
        return (this.mode() & 0x800) != 0;
    }

    public boolean isSocket() {
        return (this.mode() & 0xF000) == 49152;
    }

    public boolean isSticky() {
        return (this.mode() & 0x200) != 0;
    }

    public boolean isSymlink() {
        return (this.mode() & 0xF000) == 40960;
    }

    public boolean isWritable() {
        if (this.posix.geteuid() == 0) {
            return true;
        }
        if (this.isOwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) != 0;
    }

    public boolean isWritableReal() {
        if (this.posix.getuid() == 0) {
            return true;
        }
        if (this.isROwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) != 0;
    }

    public int major(long dev2) {
        return (int)(dev2 >> 24) & 0xFF;
    }

    public int minor(long dev2) {
        return (int)(dev2 & 0xFFFFFFL);
    }
}

