/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.collect.Iterables;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.thrift.AbstractThriftAllRowsQueryImpl;
import com.netflix.astyanax.thrift.model.ThriftColumnOrSuperColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowImpl;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;

public class ThriftAllRowsImpl<K, C>
implements Rows<K, C> {
    private ColumnFamily<K, C> columnFamily;
    private AbstractThriftAllRowsQueryImpl<K, C> query;
    private final RandomPartitioner partitioner = new RandomPartitioner();

    public ThriftAllRowsImpl(AbstractThriftAllRowsQueryImpl<K, C> query, ColumnFamily<K, C> columnFamily) {
        this.columnFamily = columnFamily;
        this.query = query;
    }

    @Override
    public Iterator<Row<K, C>> iterator() {
        return new Iterator<Row<K, C>>(){
            private KeyRange range = new KeyRange().setCount(ThriftAllRowsImpl.access$000(ThriftAllRowsImpl.this).getBlockSize()).setStart_token("0").setEnd_token("0");
            private KeySlice lastRow;
            private List<KeySlice> list = null;
            private Iterator<KeySlice> iter = null;
            private boolean bContinueSearch = true;
            private boolean bIgnoreTombstones = true;
            {
                if (ThriftAllRowsImpl.this.query.getIncludeEmptyRows() == null) {
                    if (ThriftAllRowsImpl.this.query.getPredicate().isSetSlice_range() && ThriftAllRowsImpl.this.query.getPredicate().getSlice_range().getCount() == 0) {
                        this.bIgnoreTombstones = false;
                    }
                } else {
                    this.bIgnoreTombstones = ThriftAllRowsImpl.this.query.getIncludeEmptyRows() == false;
                }
            }

            @Override
            public boolean hasNext() {
                while (this.iter == null || !this.iter.hasNext() && this.bContinueSearch) {
                    if (this.lastRow != null) {
                        String token = ThriftAllRowsImpl.this.partitioner.getToken(ByteBuffer.wrap(this.lastRow.getKey())).toString();
                        if (ThriftAllRowsImpl.this.query.getRepeatLastToken()) {
                            BigInteger intToken = new BigInteger(token).subtract(new BigInteger("1"));
                            this.range.setStart_token(intToken.toString());
                        } else {
                            this.range.setStart_token(token);
                        }
                    }
                    this.list = ThriftAllRowsImpl.this.query.getNextBlock(this.range);
                    if (this.list == null) {
                        return false;
                    }
                    this.bContinueSearch = this.list.size() == ThriftAllRowsImpl.this.query.getBlockSize();
                    this.iter = this.list.iterator();
                    if (this.iter == null || !this.iter.hasNext()) {
                        return false;
                    }
                    if (ThriftAllRowsImpl.this.query.getRepeatLastToken() && this.lastRow != null) {
                        this.iter.next();
                        this.iter.remove();
                    }
                    if (!this.iter.hasNext()) continue;
                    KeySlice currLastRow = (KeySlice)Iterables.getLast(this.list);
                    if (this.bIgnoreTombstones) {
                        while (this.iter.hasNext()) {
                            KeySlice row = this.iter.next();
                            if (!row.getColumns().isEmpty()) continue;
                            this.iter.remove();
                        }
                    }
                    if (currLastRow != null && ThriftAllRowsImpl.this.query.getRepeatLastToken() && this.iter.hasNext()) {
                        this.iter.next();
                    }
                    this.lastRow = currLastRow;
                    this.iter = this.list.iterator();
                }
                return this.iter.hasNext();
            }

            @Override
            public Row<K, C> next() {
                KeySlice row = this.iter.next();
                return new ThriftRowImpl(ThriftAllRowsImpl.this.columnFamily.getKeySerializer().fromBytes(row.getKey()), ByteBuffer.wrap(row.getKey()), new ThriftColumnOrSuperColumnListImpl(row.getColumns(), ThriftAllRowsImpl.this.columnFamily.getColumnSerializer()));
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };
    }

    @Override
    public Row<K, C> getRow(K key) {
        throw new IllegalStateException();
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public boolean isEmpty() {
        throw new IllegalStateException();
    }

    @Override
    public Row<K, C> getRowByIndex(int i) {
        throw new IllegalStateException();
    }

    @Override
    public Collection<K> getKeys() {
        throw new IllegalStateException();
    }
}

