/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.CompositeParser;
import com.netflix.astyanax.model.Composites;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.RunOnce;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.util.RangeBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ReverseIndexQuery<K, C, V> {
    private final Keyspace ks;
    private final ColumnFamily<K, C> cfData;
    private final Serializer<V> valSerializer;
    private Collection<ByteBuffer> shardKeys;
    private final ColumnFamily<ByteBuffer, ByteBuffer> cfIndex;
    private ExecutorService executor;
    private V startValue;
    private V endValue;
    private int keyLimit = 100;
    private int columnLimit = 1000;
    private int shardColumnLimit = 0;
    private final AtomicLong pendingTasks = new AtomicLong();
    private Function<Row<K, C>, Void> callback;
    private IndexEntryCallback<K, V> indexCallback;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.CL_ONE;
    private RetryPolicy retry = RunOnce.get();
    private Collection<C> columnSlice;
    private CountDownLatch latch = new CountDownLatch(1);

    public static <K, C, V> ReverseIndexQuery<K, C, V> newQuery(Keyspace ks, ColumnFamily<K, C> cf, String indexCf, Serializer<V> valSerializer) {
        return new ReverseIndexQuery<K, C, V>(ks, cf, indexCf, valSerializer);
    }

    public ReverseIndexQuery(Keyspace ks, ColumnFamily<K, C> cfData, String indexCf, Serializer<V> valSerializer) {
        this.ks = ks;
        this.cfData = cfData;
        this.valSerializer = valSerializer;
        this.startValue = null;
        this.endValue = null;
        this.cfIndex = ColumnFamily.newColumnFamily(indexCf, ByteBufferSerializer.get(), ByteBufferSerializer.get());
    }

    public ReverseIndexQuery<K, C, V> useExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public ReverseIndexQuery<K, C, V> useRetryPolicy(RetryPolicy retry) {
        this.retry = retry;
        return this;
    }

    public ReverseIndexQuery<K, C, V> withIndexShards(Collection<ByteBuffer> shardKeys) {
        this.shardKeys = shardKeys;
        return this;
    }

    public ReverseIndexQuery<K, C, V> fromIndexValue(V startValue) {
        this.startValue = startValue;
        return this;
    }

    public ReverseIndexQuery<K, C, V> toIndexValue(V endValue) {
        this.endValue = endValue;
        return this;
    }

    public ReverseIndexQuery<K, C, V> forEach(Function<Row<K, C>, Void> callback) {
        this.callback = callback;
        return this;
    }

    public ReverseIndexQuery<K, C, V> forEachIndexEntry(IndexEntryCallback<K, V> callback) {
        this.indexCallback = callback;
        return this;
    }

    public ReverseIndexQuery<K, C, V> withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ReverseIndexQuery<K, C, V> withColumnSlice(Collection<C> columnSlice) {
        this.columnSlice = columnSlice;
        return this;
    }

    public ReverseIndexQuery<K, C, V> setShardBlockSize(int size) {
        this.keyLimit = size;
        return this;
    }

    public ReverseIndexQuery<K, C, V> setShardPageSize(int size) {
        this.columnLimit = size;
        return this;
    }

    public ReverseIndexQuery<K, C, V> setShardNextPageSize(int size) {
        this.shardColumnLimit = size;
        return this;
    }

    public void execute() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).build());
        }
        ArrayList batch = Lists.newArrayListWithCapacity((int)this.keyLimit);
        for (ByteBuffer shard : this.shardKeys) {
            batch.add(shard);
            if (batch.size() != this.keyLimit) continue;
            this.fetchFirstIndexBatch(batch);
            batch = Lists.newArrayListWithCapacity((int)this.keyLimit);
        }
        if (!batch.isEmpty()) {
            this.fetchFirstIndexBatch(batch);
        }
        if (this.pendingTasks.get() > 0L) {
            try {
                this.latch.await(1000L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void fetchFirstIndexBatch(final Collection<ByteBuffer> keys) {
        new Task(){

            @Override
            protected void internalRun() {
                RangeBuilder range = new RangeBuilder();
                if (ReverseIndexQuery.this.startValue != null) {
                    range.setStart(Composites.newCompositeBuilder().greaterThanEquals().add(ReverseIndexQuery.this.startValue, ReverseIndexQuery.this.valSerializer).build());
                }
                if (ReverseIndexQuery.this.endValue != null) {
                    range.setEnd(Composites.newCompositeBuilder().lessThanEquals().add(ReverseIndexQuery.this.endValue, ReverseIndexQuery.this.valSerializer).build());
                }
                OperationResult result = null;
                try {
                    result = ReverseIndexQuery.this.ks.prepareQuery(ReverseIndexQuery.this.cfIndex).setConsistencyLevel(ReverseIndexQuery.this.consistencyLevel).withRetryPolicy(ReverseIndexQuery.this.retry).getKeySlice(keys).withColumnRange(range.setLimit(ReverseIndexQuery.this.columnLimit).build()).execute();
                }
                catch (ConnectionException e) {
                    e.printStackTrace();
                    return;
                }
                ArrayList batch = Lists.newArrayListWithCapacity((int)ReverseIndexQuery.this.keyLimit);
                for (Row row : (Rows)result.getResult()) {
                    if (row.getColumns().isEmpty()) continue;
                    Object lastValue = null;
                    for (Column column : row.getColumns()) {
                        CompositeParser parser = Composites.newCompositeParser((ByteBuffer)column.getName());
                        lastValue = parser.read(ReverseIndexQuery.this.valSerializer);
                        Object key = parser.read(ReverseIndexQuery.this.cfData.getKeySerializer());
                        if (ReverseIndexQuery.this.indexCallback != null && !ReverseIndexQuery.this.indexCallback.handleEntry(key, lastValue, column.getByteBufferValue()) || ReverseIndexQuery.this.callback == null) continue;
                        batch.add(key);
                        if (batch.size() != ReverseIndexQuery.this.keyLimit) continue;
                        ReverseIndexQuery.this.fetchDataBatch(batch);
                        batch = Lists.newArrayListWithCapacity((int)ReverseIndexQuery.this.keyLimit);
                    }
                    if (row.getColumns().size() != ReverseIndexQuery.this.columnLimit) continue;
                    ReverseIndexQuery.this.paginateIndexShard((ByteBuffer)row.getKey(), lastValue);
                }
                if (!batch.isEmpty()) {
                    ReverseIndexQuery.this.fetchDataBatch(batch);
                }
            }
        };
    }

    private void paginateIndexShard(final ByteBuffer shard, final V value) {
        new Task(){

            @Override
            protected void internalRun() {
                Object nextValue = value;
                ColumnList result = null;
                ArrayList batch = Lists.newArrayListWithCapacity((int)ReverseIndexQuery.this.keyLimit);
                int pageSize = ReverseIndexQuery.this.shardColumnLimit;
                if (pageSize == 0) {
                    pageSize = ReverseIndexQuery.this.columnLimit;
                }
                do {
                    RangeBuilder range = new RangeBuilder().setStart(Composites.newCompositeBuilder().greaterThanEquals().addBytes(ReverseIndexQuery.this.valSerializer.getNext(ReverseIndexQuery.this.valSerializer.toByteBuffer(nextValue))).build());
                    if (ReverseIndexQuery.this.endValue != null) {
                        range.setEnd(Composites.newCompositeBuilder().lessThanEquals().add(ReverseIndexQuery.this.endValue, ReverseIndexQuery.this.valSerializer).build());
                    }
                    try {
                        result = (ColumnList)ReverseIndexQuery.this.ks.prepareQuery(ReverseIndexQuery.this.cfIndex).setConsistencyLevel(ReverseIndexQuery.this.consistencyLevel).withRetryPolicy(ReverseIndexQuery.this.retry).getKey(shard).withColumnRange(range.setLimit(pageSize).build()).execute().getResult();
                    }
                    catch (ConnectionException e) {
                        e.printStackTrace();
                        return;
                    }
                    for (Column column : result) {
                        CompositeParser parser = Composites.newCompositeParser((ByteBuffer)column.getName());
                        nextValue = parser.read(ReverseIndexQuery.this.valSerializer);
                        Object key = parser.read(ReverseIndexQuery.this.cfData.getKeySerializer());
                        if (ReverseIndexQuery.this.indexCallback != null && !ReverseIndexQuery.this.indexCallback.handleEntry(key, nextValue, column.getByteBufferValue()) || ReverseIndexQuery.this.callback == null) continue;
                        batch.add(key);
                        if (batch.size() != ReverseIndexQuery.this.keyLimit) continue;
                        ReverseIndexQuery.this.fetchDataBatch(batch);
                        batch = Lists.newArrayListWithCapacity((int)ReverseIndexQuery.this.keyLimit);
                    }
                } while (result != null && result.size() == pageSize);
                if (!batch.isEmpty()) {
                    ReverseIndexQuery.this.fetchDataBatch(batch);
                }
            }
        };
    }

    private void fetchDataBatch(final Collection<K> keys) {
        new Task(){

            @Override
            protected void internalRun() {
                try {
                    OperationResult result = ReverseIndexQuery.this.ks.prepareQuery(ReverseIndexQuery.this.cfData).withRetryPolicy(ReverseIndexQuery.this.retry).setConsistencyLevel(ReverseIndexQuery.this.consistencyLevel).getKeySlice(keys).withColumnSlice(new ColumnSlice(ReverseIndexQuery.this.columnSlice)).execute();
                    for (Row row : (Rows)result.getResult()) {
                        ReverseIndexQuery.this.callback.apply((Object)row);
                    }
                }
                catch (ConnectionException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public abstract class Task
    implements Runnable {
        public Task() {
            ReverseIndexQuery.this.pendingTasks.incrementAndGet();
            ReverseIndexQuery.this.executor.submit(this);
        }

        @Override
        public final void run() {
            try {
                this.internalRun();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ReverseIndexQuery.this.pendingTasks.decrementAndGet() == 0L) {
                ReverseIndexQuery.this.latch.countDown();
            }
        }

        protected abstract void internalRun();
    }

    public static interface IndexEntryCallback<K, V> {
        public boolean handleEntry(K var1, V var2, ByteBuffer var3);
    }
}

