/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.JSONRPCBridge;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ReferenceSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ReferenceSerializer.class.getName());
    private JSONRPCBridge bridge;
    private static Class[] _serializableClasses = new Class[0];
    private static Class[] _JSONClasses = new Class[0];

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public ReferenceSerializer(JSONRPCBridge bridge) {
        this.bridge = bridge;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return !(clazz.isArray() || clazz.isPrimitive() || clazz.isInterface() || !this.bridge.isReference(clazz) && !this.bridge.isCallableReference(clazz) || jsonClazz != null && jsonClazz != JSONObject.class);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        return ObjectMatch.OKAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        Object ref = null;
        String json_type = jso.getString("JSONRPCType");
        int object_id = jso.getInt("objectID");
        if (json_type != null && json_type.equals("Reference")) {
            HashMap hashMap = this.bridge.referenceMap;
            synchronized (hashMap) {
                ref = this.bridge.referenceMap.get(new Integer(object_id));
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object marshall(SerializerState state, Object o) throws MarshallException {
        Class<?> clazz = o.getClass();
        Integer identity = new Integer(System.identityHashCode(o));
        if (this.bridge.isReference(clazz)) {
            if (this.ser.isDebug()) {
                log.fine("marshalling reference to object " + identity + " of class " + clazz.getName());
            }
            HashMap hashMap = this.bridge.referenceMap;
            synchronized (hashMap) {
                this.bridge.referenceMap.put(identity, o);
            }
            JSONObject jso = new JSONObject();
            jso.put("JSONRPCType", (Object)"Reference");
            jso.put("javaClass", (Object)clazz.getName());
            jso.put("objectID", (Object)identity);
            return jso;
        }
        if (this.bridge.isCallableReference(clazz)) {
            if (this.ser.isDebug()) {
                log.fine("marshalling callable reference to object " + identity + " of class " + clazz.getName());
            }
            this.bridge.registerObject(identity, o);
            JSONObject jso = new JSONObject();
            jso.put("JSONRPCType", (Object)"CallableReference");
            jso.put("javaClass", (Object)clazz.getName());
            jso.put("objectID", (Object)identity);
            return jso;
        }
        return null;
    }
}

