/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;

public class JCRImageDocument
extends JCRDocument
implements ImageDocument {
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    protected String nodeId;

    public JCRImageDocument(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node, ContentType.IMAGE);
        this.nodeId = node.getIdentifier();
    }

    public JCRImageDocument(JCRWorkspace workspace, Node node, String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description, oid, mimeType, ContentType.IMAGE, documentData, metadata, annotations, collectionName);
        try {
            node.setProperty("hl:workspaceItemType", FolderItemType.IMAGE_DOCUMENT.toString());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public int getWidth() {
        return ((JCRImage)this.documentContent).getWidth();
    }

    public int getHeight() {
        return ((JCRImage)this.documentContent).getWidth();
    }

    public InputStream getThumbnail() throws InternalErrorException {
        return ((JCRImage)this.documentContent).getThumbnail();
    }

    public int getThumbnailWidth() {
        return ((JCRImage)this.documentContent).getThumbnailWidth();
    }

    public int getThumbnailHeight() {
        return ((JCRImage)this.documentContent).getThumbnailHeight();
    }

    public long getThumbnailLength() throws InternalErrorException {
        return ((JCRImage)this.documentContent).getThumbnailLength();
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.IMAGE_DOCUMENT;
    }

    public String getPublicLink() throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace("Old retrieve content method");
            }
            String string = GCUBEStorage.getPublicLink(remotePath, this.workspace.getOwner().getPortalLogin());
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void getHardLink(String linkName) throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.nodeId);
                try {
                    remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
                }
                catch (PathNotFoundException e) {
                    logger.trace("Old retrieve content method");
                }
                GCUBEStorage.createHardLink(remotePath, linkName, this.workspace.getOwner().getPortalLogin());
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void updateInfo(String mimeType) throws InternalErrorException {
        ((JCRImage)this.documentContent).updateInfo(mimeType);
    }
}

