/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.words.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Randomizer;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portlet.words.ScramblerException;
import com.liferay.portlet.words.util.Scrambler;
import com.liferay.util.jazzy.BasicSpellCheckListener;
import com.liferay.util.jazzy.InvalidWord;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.DefaultWordFinder;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordsUtil {
    private static Log _log = LogFactoryUtil.getLog(WordsUtil.class);
    private static WordsUtil _instance = new WordsUtil();
    private List<String> _dictionaryList = new UnmodifiableList(this._dictionaryList);
    private Set<String> _dictionarySet = new HashSet<String>(this._dictionaryList.size());
    private SpellDictionaryHashMap _spellDictionary;

    public static List<InvalidWord> checkSpelling(String text) {
        return _instance._checkSpelling(text);
    }

    public static List<String> getDictionaryList() {
        return _instance._getDictionaryList();
    }

    public static Set<String> getDictionarySet() {
        return _instance._getDictionarySet();
    }

    public static String getRandomWord() {
        return _instance._getRandomWord();
    }

    public static boolean isDictionaryWord(String word) {
        return _instance._isDictionaryWord(word);
    }

    public static String[] scramble(String word) throws ScramblerException {
        Scrambler scrambler = new Scrambler(word);
        return scrambler.scramble();
    }

    public static String[] unscramble(String word) throws ScramblerException {
        return _instance._unscramble(word);
    }

    private WordsUtil() {
        this._dictionarySet.addAll(this._dictionaryList);
        this._dictionarySet = Collections.unmodifiableSet(this._dictionarySet);
        try {
            this._spellDictionary = new SpellDictionaryHashMap();
            String[] dics = new String[]{"center.dic", "centre.dic", "color.dic", "colour.dic", "eng_com.dic", "english.0", "english.1", "ise.dic", "ize.dic", "labeled.dic", "labelled.dic", "yse.dic", "yze.dic"};
            int i = 0;
            while (i < dics.length) {
                this._spellDictionary.addDictionary((Reader)new UnsyncStringReader(ContentUtil.get("com/liferay/portlet/words/dependencies/" + dics[i])));
                ++i;
            }
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
    }

    private List<InvalidWord> _checkSpelling(String text) {
        SpellChecker checker = new SpellChecker((SpellDictionary)this._spellDictionary);
        BasicSpellCheckListener listener = new BasicSpellCheckListener(text);
        checker.addSpellCheckListener((SpellCheckListener)listener);
        checker.checkSpelling((WordTokenizer)new StringWordTokenizer((WordFinder)new DefaultWordFinder(text)));
        return listener.getInvalidWords();
    }

    private List<String> _getDictionaryList() {
        return this._dictionaryList;
    }

    private Set<String> _getDictionarySet() {
        return this._dictionarySet;
    }

    private String _getRandomWord() {
        int pos = Randomizer.getInstance().nextInt(this._dictionaryList.size());
        return this._dictionaryList.get(pos);
    }

    private boolean _isDictionaryWord(String word) {
        return this._dictionarySet.contains(word);
    }

    private String[] _unscramble(String word) throws ScramblerException {
        ArrayList<String> validWords = new ArrayList<String>();
        String[] words = WordsUtil.scramble(word);
        int i = 0;
        while (i < words.length) {
            if (this._dictionarySet.contains(words[i])) {
                validWords.add(words[i]);
            }
            ++i;
        }
        return validWords.toArray(new String[validWords.size()]);
    }
}

