/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tasks.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.tasks.model.TasksProposal;
import com.liferay.portlet.tasks.model.impl.TasksProposalModelImpl;
import com.liferay.portlet.tasks.service.TasksReviewLocalServiceUtil;
import java.util.List;
import java.util.Locale;

public class TasksProposalImpl
extends TasksProposalModelImpl
implements TasksProposal {
    private static final String _STATUS_APPROVED = "stage-x-review-approved";
    private static final String _STATUS_PENDING = "stage-x-pending-review";
    private static final String _STATUS_REJECTED = "stage-x-review-rejected";
    private static final String _STATUS_UNASSIGNED = "stage-x-review-unassigned";

    public String getStatus(Locale locale) throws PortalException, SystemException {
        String status = null;
        int stage = 1;
        Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
        int stages = group.getWorkflowStages();
        while (stage <= stages) {
            status = this.getStatus(stage);
            if (!status.equals(_STATUS_APPROVED) && (status.equals(_STATUS_PENDING) || status.equals(_STATUS_REJECTED) || (!status.equals(_STATUS_UNASSIGNED) || stage <= 1) && stage == 0) || stage == stages) break;
            ++stage;
        }
        return LanguageUtil.format((Locale)locale, (String)status, (Object)String.valueOf(stage + 1));
    }

    protected String getStatus(int stage) throws SystemException {
        List reviews = TasksReviewLocalServiceUtil.getReviews((long)this.getProposalId(), (int)stage);
        if (reviews.size() <= 0) {
            return _STATUS_UNASSIGNED;
        }
        List completedReviews = TasksReviewLocalServiceUtil.getReviews((long)this.getProposalId(), (int)stage, (boolean)true);
        if (completedReviews.size() < reviews.size()) {
            return _STATUS_PENDING;
        }
        List completedRejectedReviews = TasksReviewLocalServiceUtil.getReviews((long)this.getProposalId(), (int)stage, (boolean)true, (boolean)true);
        if (completedRejectedReviews.size() > 0) {
            return _STATUS_REJECTED;
        }
        return _STATUS_APPROVED;
    }
}

