/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ImagePersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.shopping.NoSuchItemException;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.model.impl.ShoppingItemImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingItemModelImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingItemPriceImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingItemPriceModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistenceImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingItemPersistenceImpl
extends BasePersistenceImpl<ShoppingItem>
implements ShoppingItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List";
    public static final FinderPath FINDER_PATH_FETCH_BY_SMALLIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchBySmallImageId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_SMALLIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countBySmallImageId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_MEDIUMIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByMediumImageId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_MEDIUMIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByMediumImageId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_LARGEIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByLargeImageId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_LARGEIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByLargeImageId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_C_S = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByC_S", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_C_S = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByC_S", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_GET_SHOPPINGITEMPRICES = new FinderPath(ShoppingItemPriceModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemPriceModelImpl.FINDER_CACHE_ENABLED, ShoppingItemPricePersistenceImpl.FINDER_CLASS_NAME_LIST, "getShoppingItemPrices", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_GET_SHOPPINGITEMPRICES_SIZE = new FinderPath(ShoppingItemPriceModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemPriceModelImpl.FINDER_CACHE_ENABLED, ShoppingItemPricePersistenceImpl.FINDER_CLASS_NAME_LIST, "getShoppingItemPricesSize", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_CONTAINS_SHOPPINGITEMPRICE = new FinderPath(ShoppingItemPriceModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemPriceModelImpl.FINDER_CACHE_ENABLED, ShoppingItemPricePersistenceImpl.FINDER_CLASS_NAME_LIST, "containsShoppingItemPrice", new String[]{Long.class.getName(), Long.class.getName()});
    @BeanReference(type=ShoppingCartPersistence.class)
    protected ShoppingCartPersistence shoppingCartPersistence;
    @BeanReference(type=ShoppingCategoryPersistence.class)
    protected ShoppingCategoryPersistence shoppingCategoryPersistence;
    @BeanReference(type=ShoppingCouponPersistence.class)
    protected ShoppingCouponPersistence shoppingCouponPersistence;
    @BeanReference(type=ShoppingItemPersistence.class)
    protected ShoppingItemPersistence shoppingItemPersistence;
    @BeanReference(type=ShoppingItemFieldPersistence.class)
    protected ShoppingItemFieldPersistence shoppingItemFieldPersistence;
    @BeanReference(type=ShoppingItemPricePersistence.class)
    protected ShoppingItemPricePersistence shoppingItemPricePersistence;
    @BeanReference(type=ShoppingOrderPersistence.class)
    protected ShoppingOrderPersistence shoppingOrderPersistence;
    @BeanReference(type=ShoppingOrderItemPersistence.class)
    protected ShoppingOrderItemPersistence shoppingOrderItemPersistence;
    @BeanReference(type=ImagePersistence.class)
    protected ImagePersistence imagePersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    protected ContainsShoppingItemPrice containsShoppingItemPrice;
    private static final String _SQL_SELECT_SHOPPINGITEM = "SELECT shoppingItem FROM ShoppingItem shoppingItem";
    private static final String _SQL_SELECT_SHOPPINGITEM_WHERE = "SELECT shoppingItem FROM ShoppingItem shoppingItem WHERE ";
    private static final String _SQL_COUNT_SHOPPINGITEM = "SELECT COUNT(shoppingItem) FROM ShoppingItem shoppingItem";
    private static final String _SQL_COUNT_SHOPPINGITEM_WHERE = "SELECT COUNT(shoppingItem) FROM ShoppingItem shoppingItem WHERE ";
    private static final String _SQL_GETSHOPPINGITEMPRICES = "SELECT {ShoppingItemPrice.*} FROM ShoppingItemPrice INNER JOIN ShoppingItem ON (ShoppingItem.itemId = ShoppingItemPrice.itemId) WHERE (ShoppingItem.itemId = ?)";
    private static final String _SQL_GETSHOPPINGITEMPRICESSIZE = "SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItemPrice WHERE itemId = ?";
    private static final String _SQL_CONTAINSSHOPPINGITEMPRICE = "SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItemPrice WHERE itemId = ? AND itemPriceId = ?";
    private static final String _FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2 = "shoppingItem.smallImageId = ?";
    private static final String _FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2 = "shoppingItem.mediumImageId = ?";
    private static final String _FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2 = "shoppingItem.largeImageId = ?";
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "shoppingItem.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_CATEGORYID_2 = "shoppingItem.categoryId = ?";
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "shoppingItem.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SKU_1 = "shoppingItem.sku IS NULL";
    private static final String _FINDER_COLUMN_C_S_SKU_2 = "shoppingItem.sku = ?";
    private static final String _FINDER_COLUMN_C_S_SKU_3 = "(shoppingItem.sku IS NULL OR shoppingItem.sku = ?)";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_WHERE = "SELECT DISTINCT {shoppingItem.*} FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {ShoppingItem.*} FROM (SELECT DISTINCT shoppingItem.itemId FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN ShoppingItem ON TEMP_TABLE.itemId = ShoppingItem.itemId";
    private static final String _FILTER_SQL_COUNT_SHOPPINGITEM_WHERE = "SELECT COUNT(DISTINCT shoppingItem.itemId) AS COUNT_VALUE FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_COLUMN_PK = "shoppingItem.itemId";
    private static final String _FILTER_COLUMN_USERID = "shoppingItem.userId";
    private static final String _FILTER_ENTITY_ALIAS = "shoppingItem";
    private static final String _FILTER_ENTITY_TABLE = "ShoppingItem";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingItem.";
    private static final String _ORDER_BY_ENTITY_TABLE = "ShoppingItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingItem exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(ShoppingItemPersistenceImpl.class);

    public void cacheResult(ShoppingItem shoppingItem) {
        EntityCacheUtil.putResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getSmallImageId())}, (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getMediumImageId())}, (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getLargeImageId())}, (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])new Object[]{new Long(shoppingItem.getCompanyId()), shoppingItem.getSku()}, (Object)shoppingItem);
    }

    public void cacheResult(List<ShoppingItem> shoppingItems) {
        for (ShoppingItem shoppingItem : shoppingItems) {
            if (EntityCacheUtil.getResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(shoppingItem);
        }
    }

    public void clearCache() {
        CacheRegistryUtil.clear((String)ShoppingItemImpl.class.getName());
        EntityCacheUtil.clearCache((String)ShoppingItemImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public void clearCache(ShoppingItem shoppingItem) {
        EntityCacheUtil.removeResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()));
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getSmallImageId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getMediumImageId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getLargeImageId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])new Object[]{new Long(shoppingItem.getCompanyId()), shoppingItem.getSku()});
    }

    public ShoppingItem create(long itemId) {
        ShoppingItemImpl shoppingItem = new ShoppingItemImpl();
        shoppingItem.setNew(true);
        shoppingItem.setPrimaryKey(itemId);
        return shoppingItem;
    }

    public ShoppingItem remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public ShoppingItem remove(long itemId) throws NoSuchItemException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, (Serializable)new Long(itemId));
            if (shoppingItem == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + itemId));
                }
                throw new NoSuchItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + itemId);
            }
            ShoppingItem shoppingItem2 = (ShoppingItem)this.remove((BaseModel)shoppingItem);
            return shoppingItem2;
        }
        catch (NoSuchItemException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem removeImpl(ShoppingItem shoppingItem) throws SystemException {
        shoppingItem = this.toUnwrappedModel(shoppingItem);
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)shoppingItem);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        ShoppingItemModelImpl shoppingItemModelImpl = (ShoppingItemModelImpl)shoppingItem;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])new Object[]{new Long(shoppingItemModelImpl.getSmallImageId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])new Object[]{new Long(shoppingItemModelImpl.getMediumImageId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])new Object[]{new Long(shoppingItemModelImpl.getLargeImageId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])new Object[]{new Long(shoppingItemModelImpl.getCompanyId()), shoppingItemModelImpl.getSku()});
        EntityCacheUtil.removeResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()));
        return shoppingItem;
    }

    public ShoppingItem updateImpl(ShoppingItem shoppingItem, boolean merge) throws SystemException {
        shoppingItem = this.toUnwrappedModel(shoppingItem);
        boolean isNew = shoppingItem.isNew();
        ShoppingItemModelImpl shoppingItemModelImpl = (ShoppingItemModelImpl)shoppingItem;
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)shoppingItem, (boolean)merge);
                shoppingItem.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (Object)shoppingItem);
        if (!isNew && shoppingItem.getSmallImageId() != shoppingItemModelImpl.getOriginalSmallImageId()) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])new Object[]{new Long(shoppingItemModelImpl.getOriginalSmallImageId())});
        }
        if (isNew || shoppingItem.getSmallImageId() != shoppingItemModelImpl.getOriginalSmallImageId()) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getSmallImageId())}, (Object)shoppingItem);
        }
        if (!isNew && shoppingItem.getMediumImageId() != shoppingItemModelImpl.getOriginalMediumImageId()) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])new Object[]{new Long(shoppingItemModelImpl.getOriginalMediumImageId())});
        }
        if (isNew || shoppingItem.getMediumImageId() != shoppingItemModelImpl.getOriginalMediumImageId()) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getMediumImageId())}, (Object)shoppingItem);
        }
        if (!isNew && shoppingItem.getLargeImageId() != shoppingItemModelImpl.getOriginalLargeImageId()) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])new Object[]{new Long(shoppingItemModelImpl.getOriginalLargeImageId())});
        }
        if (isNew || shoppingItem.getLargeImageId() != shoppingItemModelImpl.getOriginalLargeImageId()) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])new Object[]{new Long(shoppingItem.getLargeImageId())}, (Object)shoppingItem);
        }
        if (!(isNew || shoppingItem.getCompanyId() == shoppingItemModelImpl.getOriginalCompanyId() && Validator.equals((Object)shoppingItem.getSku(), (Object)shoppingItemModelImpl.getOriginalSku()))) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])new Object[]{new Long(shoppingItemModelImpl.getOriginalCompanyId()), shoppingItemModelImpl.getOriginalSku()});
        }
        if (isNew || shoppingItem.getCompanyId() != shoppingItemModelImpl.getOriginalCompanyId() || !Validator.equals((Object)shoppingItem.getSku(), (Object)shoppingItemModelImpl.getOriginalSku())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])new Object[]{new Long(shoppingItem.getCompanyId()), shoppingItem.getSku()}, (Object)shoppingItem);
        }
        return shoppingItem;
    }

    protected ShoppingItem toUnwrappedModel(ShoppingItem shoppingItem) {
        if (shoppingItem instanceof ShoppingItemImpl) {
            return shoppingItem;
        }
        ShoppingItemImpl shoppingItemImpl = new ShoppingItemImpl();
        shoppingItemImpl.setNew(shoppingItem.isNew());
        shoppingItemImpl.setPrimaryKey(shoppingItem.getPrimaryKey());
        shoppingItemImpl.setItemId(shoppingItem.getItemId());
        shoppingItemImpl.setGroupId(shoppingItem.getGroupId());
        shoppingItemImpl.setCompanyId(shoppingItem.getCompanyId());
        shoppingItemImpl.setUserId(shoppingItem.getUserId());
        shoppingItemImpl.setUserName(shoppingItem.getUserName());
        shoppingItemImpl.setCreateDate(shoppingItem.getCreateDate());
        shoppingItemImpl.setModifiedDate(shoppingItem.getModifiedDate());
        shoppingItemImpl.setCategoryId(shoppingItem.getCategoryId());
        shoppingItemImpl.setSku(shoppingItem.getSku());
        shoppingItemImpl.setName(shoppingItem.getName());
        shoppingItemImpl.setDescription(shoppingItem.getDescription());
        shoppingItemImpl.setProperties(shoppingItem.getProperties());
        shoppingItemImpl.setFields(shoppingItem.isFields());
        shoppingItemImpl.setFieldsQuantities(shoppingItem.getFieldsQuantities());
        shoppingItemImpl.setMinQuantity(shoppingItem.getMinQuantity());
        shoppingItemImpl.setMaxQuantity(shoppingItem.getMaxQuantity());
        shoppingItemImpl.setPrice(shoppingItem.getPrice());
        shoppingItemImpl.setDiscount(shoppingItem.getDiscount());
        shoppingItemImpl.setTaxable(shoppingItem.isTaxable());
        shoppingItemImpl.setShipping(shoppingItem.getShipping());
        shoppingItemImpl.setUseShippingFormula(shoppingItem.isUseShippingFormula());
        shoppingItemImpl.setRequiresShipping(shoppingItem.isRequiresShipping());
        shoppingItemImpl.setStockQuantity(shoppingItem.getStockQuantity());
        shoppingItemImpl.setFeatured(shoppingItem.isFeatured());
        shoppingItemImpl.setSale(shoppingItem.isSale());
        shoppingItemImpl.setSmallImage(shoppingItem.isSmallImage());
        shoppingItemImpl.setSmallImageId(shoppingItem.getSmallImageId());
        shoppingItemImpl.setSmallImageURL(shoppingItem.getSmallImageURL());
        shoppingItemImpl.setMediumImage(shoppingItem.isMediumImage());
        shoppingItemImpl.setMediumImageId(shoppingItem.getMediumImageId());
        shoppingItemImpl.setMediumImageURL(shoppingItem.getMediumImageURL());
        shoppingItemImpl.setLargeImage(shoppingItem.isLargeImage());
        shoppingItemImpl.setLargeImageId(shoppingItem.getLargeImageId());
        shoppingItemImpl.setLargeImageURL(shoppingItem.getLargeImageURL());
        return shoppingItemImpl;
    }

    public ShoppingItem findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public ShoppingItem findByPrimaryKey(long itemId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByPrimaryKey(itemId);
        if (shoppingItem == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + itemId));
            }
            throw new NoSuchItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + itemId);
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public ShoppingItem fetchByPrimaryKey(long itemId) throws SystemException {
        ShoppingItem shoppingItem = (ShoppingItem)EntityCacheUtil.getResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(itemId), (SessionFactory)this);
        if (shoppingItem == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, (Serializable)new Long(itemId));
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (shoppingItem != null) {
                    this.cacheResult(shoppingItem);
                }
                this.closeSession(session);
            }
        }
        return shoppingItem;
    }

    public ShoppingItem findBySmallImageId(long smallImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchBySmallImageId(smallImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("smallImageId=");
            msg.append(smallImageId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchBySmallImageId(long smallImageId) throws SystemException {
        return this.fetchBySmallImageId(smallImageId, true);
    }

    public ShoppingItem fetchBySmallImageId(long smallImageId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{smallImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2);
            query.append(" ORDER BY shoppingItem.itemId ASC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(smallImageId);
                List list = q.list();
                result = list;
                ShoppingItem shoppingItem = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingItem = (ShoppingItem)list.get(0);
                    this.cacheResult(shoppingItem);
                    if (shoppingItem.getSmallImageId() != smallImageId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs, (Object)shoppingItem);
                    }
                }
                ShoppingItem shoppingItem2 = shoppingItem;
                return shoppingItem2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem findByMediumImageId(long mediumImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByMediumImageId(mediumImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mediumImageId=");
            msg.append(mediumImageId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByMediumImageId(long mediumImageId) throws SystemException {
        return this.fetchByMediumImageId(mediumImageId, true);
    }

    public ShoppingItem fetchByMediumImageId(long mediumImageId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{mediumImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2);
            query.append(" ORDER BY shoppingItem.itemId ASC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(mediumImageId);
                List list = q.list();
                result = list;
                ShoppingItem shoppingItem = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingItem = (ShoppingItem)list.get(0);
                    this.cacheResult(shoppingItem);
                    if (shoppingItem.getMediumImageId() != mediumImageId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs, (Object)shoppingItem);
                    }
                }
                ShoppingItem shoppingItem2 = shoppingItem;
                return shoppingItem2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem findByLargeImageId(long largeImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByLargeImageId(largeImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("largeImageId=");
            msg.append(largeImageId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByLargeImageId(long largeImageId) throws SystemException {
        return this.fetchByLargeImageId(largeImageId, true);
    }

    public ShoppingItem fetchByLargeImageId(long largeImageId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{largeImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2);
            query.append(" ORDER BY shoppingItem.itemId ASC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(largeImageId);
                List list = q.list();
                result = list;
                ShoppingItem shoppingItem = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingItem = (ShoppingItem)list.get(0);
                    this.cacheResult(shoppingItem);
                    if (shoppingItem.getLargeImageId() != largeImageId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs, (Object)shoppingItem);
                    }
                }
                ShoppingItem shoppingItem2 = shoppingItem;
                return shoppingItem2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId) throws SystemException {
        return this.findByG_C(groupId, categoryId, -1, -1, null);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end) throws SystemException {
        return this.findByG_C(groupId, categoryId, start, end, null);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, categoryId, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_G_C, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_G_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY shoppingItem.itemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(categoryId);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_G_C, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_C, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingItem findByG_C_First(long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        List<ShoppingItem> list = this.findByG_C(groupId, categoryId, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", categoryId=");
            msg.append(categoryId);
            msg.append("}");
            throw new NoSuchItemException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingItem findByG_C_Last(long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        int count = this.countByG_C(groupId, categoryId);
        List<ShoppingItem> list = this.findByG_C(groupId, categoryId, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", categoryId=");
            msg.append(categoryId);
            msg.append("}");
            throw new NoSuchItemException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingItem[] findByG_C_PrevAndNext(long itemId, long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByPrimaryKey(itemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem[] array = new ShoppingItemImpl[]{this.getByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, true), shoppingItem, this.getByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, false)};
            ShoppingItem[] shoppingItemArray = array;
            return shoppingItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem getByG_C_PrevAndNext(Session session, ShoppingItem shoppingItem, long groupId, long categoryId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        } else {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(categoryId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)shoppingItem);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingItem)list.get(1);
        }
        return null;
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId) throws SystemException {
        return this.filterFindByG_C(groupId, categoryId, -1, -1, null);
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId, int start, int end) throws SystemException {
        return this.filterFindByG_C(groupId, categoryId, start, end, null);
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_C(groupId, categoryId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        } else {
            query.append(" ORDER BY ShoppingItem.itemId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingItemImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingItemImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(categoryId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingItem findByC_S(long companyId, String sku) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByC_S(companyId, sku);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", sku=");
            msg.append(sku);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByC_S(long companyId, String sku) throws SystemException {
        return this.fetchByC_S(companyId, sku, true);
    }

    public ShoppingItem fetchByC_S(long companyId, String sku, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{companyId, sku};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            if (sku == null) {
                query.append(_FINDER_COLUMN_C_S_SKU_1);
            } else if (sku.equals("")) {
                query.append(_FINDER_COLUMN_C_S_SKU_3);
            } else {
                query.append(_FINDER_COLUMN_C_S_SKU_2);
            }
            query.append(" ORDER BY shoppingItem.itemId ASC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (sku != null) {
                    qPos.add(sku);
                }
                List list = q.list();
                result = list;
                ShoppingItem shoppingItem = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingItem = (ShoppingItem)list.get(0);
                    this.cacheResult(shoppingItem);
                    if (shoppingItem.getCompanyId() != companyId || shoppingItem.getSku() == null || !shoppingItem.getSku().equals(sku)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs, (Object)shoppingItem);
                    }
                }
                ShoppingItem shoppingItem2 = shoppingItem;
                return shoppingItem2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public List<ShoppingItem> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingItem> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingItem> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_SHOPPINGITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGITEM.concat(" ORDER BY shoppingItem.itemId ASC");
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeBySmallImageId(long smallImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findBySmallImageId(smallImageId);
        this.remove((BaseModel)shoppingItem);
    }

    public void removeByMediumImageId(long mediumImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByMediumImageId(mediumImageId);
        this.remove((BaseModel)shoppingItem);
    }

    public void removeByLargeImageId(long largeImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByLargeImageId(largeImageId);
        this.remove((BaseModel)shoppingItem);
    }

    public void removeByG_C(long groupId, long categoryId) throws SystemException {
        for (ShoppingItem shoppingItem : this.findByG_C(groupId, categoryId)) {
            this.remove((BaseModel)shoppingItem);
        }
    }

    public void removeByC_S(long companyId, String sku) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByC_S(companyId, sku);
        this.remove((BaseModel)shoppingItem);
    }

    public void removeAll() throws SystemException {
        for (ShoppingItem shoppingItem : this.findAll()) {
            this.remove((BaseModel)shoppingItem);
        }
    }

    public int countBySmallImageId(long smallImageId) throws SystemException {
        Object[] finderArgs = new Object[]{smallImageId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_SMALLIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(smallImageId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_SMALLIMAGEID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByMediumImageId(long mediumImageId) throws SystemException {
        Object[] finderArgs = new Object[]{mediumImageId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(mediumImageId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByLargeImageId(long largeImageId) throws SystemException {
        Object[] finderArgs = new Object[]{largeImageId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_LARGEIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(largeImageId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LARGEIMAGEID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_C(long groupId, long categoryId) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, categoryId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_C, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_G_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(categoryId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_C, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_C(long groupId, long categoryId) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_C(groupId, categoryId);
        }
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_SHOPPINGITEM_WHERE);
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(categoryId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_S(long companyId, String sku) throws SystemException {
        Object[] finderArgs = new Object[]{companyId, sku};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_C_S, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            if (sku == null) {
                query.append(_FINDER_COLUMN_C_S_SKU_1);
            } else if (sku.equals("")) {
                query.append(_FINDER_COLUMN_C_S_SKU_3);
            } else {
                query.append(_FINDER_COLUMN_C_S_SKU_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(companyId);
                    if (sku != null) {
                        qPos.add(sku);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_C_S, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_SHOPPINGITEM);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingItemPrice> getShoppingItemPrices(long pk) throws SystemException {
        return this.getShoppingItemPrices(pk, -1, -1);
    }

    public List<ShoppingItemPrice> getShoppingItemPrices(long pk, int start, int end) throws SystemException {
        return this.getShoppingItemPrices(pk, start, end, null);
    }

    public List<ShoppingItemPrice> getShoppingItemPrices(long pk, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{pk, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SHOPPINGITEMPRICES, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    String sql = null;
                    sql = orderByComparator != null ? _SQL_GETSHOPPINGITEMPRICES.concat(" ORDER BY ").concat(orderByComparator.getOrderBy()) : _SQL_GETSHOPPINGITEMPRICES.concat(" ORDER BY ShoppingItemPrice.itemId ASC, ShoppingItemPrice.itemPriceId ASC");
                    SQLQuery q = session.createSQLQuery(sql);
                    q.addEntity("ShoppingItemPrice", ShoppingItemPriceImpl.class);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(pk);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_GET_SHOPPINGITEMPRICES, (Object[])finderArgs);
                } else {
                    this.shoppingItemPricePersistence.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SHOPPINGITEMPRICES, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public int getShoppingItemPricesSize(long pk) throws SystemException {
        Object[] finderArgs = new Object[]{pk};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SHOPPINGITEMPRICES_SIZE, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    SQLQuery q = session.createSQLQuery(_SQL_GETSHOPPINGITEMPRICESSIZE);
                    q.addScalar("COUNT_VALUE", Type.LONG);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(pk);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SHOPPINGITEMPRICES_SIZE, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public boolean containsShoppingItemPrice(long pk, long shoppingItemPricePK) throws SystemException {
        Object[] finderArgs = new Object[]{pk, shoppingItemPricePK};
        Boolean value = (Boolean)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_CONTAINS_SHOPPINGITEMPRICE, (Object[])finderArgs, (SessionFactory)this);
        if (value == null) {
            try {
                try {
                    value = this.containsShoppingItemPrice.contains(pk, shoppingItemPricePK);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_CONTAINS_SHOPPINGITEMPRICE, (Object[])finderArgs, (Object)value);
            }
        }
        return value;
    }

    public boolean containsShoppingItemPrices(long pk) throws SystemException {
        return this.getShoppingItemPricesSize(pk) > 0;
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingItem")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        this.containsShoppingItemPrice = new ContainsShoppingItemPrice(this);
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)ShoppingItemImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST);
    }

    protected class ContainsShoppingItemPrice {
        private MappingSqlQuery<Integer> _mappingSqlQuery;

        protected ContainsShoppingItemPrice(ShoppingItemPersistenceImpl persistenceImpl) {
            this._mappingSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery((DataSource)ShoppingItemPersistenceImpl.this.getDataSource(), (String)ShoppingItemPersistenceImpl._SQL_CONTAINSSHOPPINGITEMPRICE, (int[])new int[]{-5, -5}, (RowMapper)RowMapper.COUNT);
        }

        protected boolean contains(long itemId, long itemPriceId) {
            Integer count;
            List results = this._mappingSqlQuery.execute(new Object[]{new Long(itemId), new Long(itemPriceId)});
            return results.size() > 0 && (count = (Integer)results.get(0)) > 0;
        }
    }
}

