/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class MBActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{MBMessage.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!MBMessagePermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), themeDisplay);
        int activityType = activity.getType();
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)activity.getClassPK());
        String link = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/message_boards/find_message?messageId=" + message.getMessageId();
        String titlePattern = null;
        if (activityType == 1) {
            titlePattern = "activity-message-boards-add-message";
        } else if (activityType == 2) {
            titlePattern = "activity-message-boards-reply-message";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = String.valueOf(titlePattern) + "-in";
        }
        String messageSubject = this.wrapLink(link, HtmlUtil.escape((String)this.cleanContent(message.getSubject())));
        Object[] titleArguments = new Object[]{groupName, creatorUserName, receiverUserName, messageSubject};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String categoryLink = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/message_boards/find_category?mbCategoryId=" + message.getCategoryId();
        String body = this.wrapLink(categoryLink, "go-to-category", themeDisplay);
        return new SocialActivityFeedEntry(link, title, body);
    }
}

