/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.util;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journalcontent.util.JournalContent;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.StopWatch;

public class JournalContentImpl
implements JournalContent {
    protected static Pattern lifecycleRenderPhasePatern = Pattern.compile("<lifecycle>\\s*RENDER_PHASE\\s*</lifecycle>");
    protected static PortalCache portalCache = MultiVMPoolUtil.getCache((String)CACHE_NAME);
    private static Log _log = LogFactoryUtil.getLog(JournalContentUtil.class);

    public void clearCache() {
        portalCache.removeAll();
    }

    public void clearCache(long groupId, String articleId, String templateId) {
        this.clearCache();
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, String xmlRequest) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, null, xmlRequest);
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public String getContent(long groupId, String articleId, String templateId, String viewMode, String languageId, String xmlRequest) {
        return this.getContent(groupId, articleId, templateId, viewMode, languageId, null, xmlRequest);
    }

    public String getContent(long groupId, String articleId, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, templateId, viewMode, languageId, themeDisplay, null);
    }

    public String getContent(long groupId, String articleId, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay, String xmlRequest) {
        JournalArticleDisplay articleDisplay = this.getDisplay(groupId, articleId, templateId, viewMode, languageId, themeDisplay, 1, xmlRequest);
        if (articleDisplay != null) {
            return articleDisplay.getContent();
        }
        return null;
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, String xmlRequest) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, null, 1, xmlRequest);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, viewMode, languageId, themeDisplay, 1);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay, int page) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, themeDisplay, page, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String templateId, String viewMode, String languageId, String xmlRequest) {
        return this.getDisplay(groupId, articleId, templateId, viewMode, languageId, null, 1, xmlRequest);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, templateId, viewMode, languageId, themeDisplay, 1, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay, int page, String xmlRequest) {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        articleId = GetterUtil.getString((String)articleId).toUpperCase();
        templateId = GetterUtil.getString((String)templateId).toUpperCase();
        long layoutSetId = 0L;
        boolean secure = false;
        if (themeDisplay != null) {
            try {
                Layout layout = themeDisplay.getLayout();
                LayoutSet layoutSet = layout.getLayoutSet();
                layoutSetId = layoutSet.getLayoutSetId();
            }
            catch (Exception exception) {}
            secure = themeDisplay.isSecure();
        }
        String key = this.encodeKey(groupId, articleId, templateId, layoutSetId, viewMode, languageId, page, secure);
        JournalArticleDisplay articleDisplay = (JournalArticleDisplay)portalCache.get(key);
        boolean lifecycleRender = this.isLifecycleRender(themeDisplay, xmlRequest);
        if ((articleDisplay == null || !lifecycleRender) && (articleDisplay = this.getArticleDisplay(groupId, articleId, templateId, viewMode, languageId, page, xmlRequest, themeDisplay)) != null && articleDisplay.isCacheable() && lifecycleRender) {
            portalCache.put(key, (Serializable)articleDisplay);
        }
        try {
            if (PropsValues.JOURNAL_ARTICLE_VIEW_PERMISSION_CHECK_ENABLED && articleDisplay != null && themeDisplay != null && !JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), groupId, articleId, "VIEW")) {
                articleDisplay = null;
            }
        }
        catch (Exception exception) {}
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + groupId + ", " + articleId + ", " + templateId + ", " + viewMode + ", " + languageId + ", " + page + "} takes " + stopWatch.getTime() + " ms"));
        }
        return articleDisplay;
    }

    protected String encodeKey(long groupId, String articleId, String templateId, long layoutSetId, String viewMode, String languageId, int page, boolean secure) {
        StringBundler sb = new StringBundler();
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(groupId);
        sb.append("_ARTICLE_");
        sb.append(articleId);
        sb.append("_TEMPLATE_");
        sb.append(templateId);
        if (layoutSetId > 0L) {
            sb.append("_LAYOUT_SET_");
            sb.append(layoutSetId);
        }
        if (Validator.isNotNull((String)viewMode)) {
            sb.append("_VIEW_MODE_");
            sb.append(viewMode);
        }
        if (Validator.isNotNull((String)languageId)) {
            sb.append("_LANGUAGE_");
            sb.append(languageId);
        }
        if (page > 0) {
            sb.append("_PAGE_");
            sb.append(page);
        }
        sb.append("_SECURE_");
        sb.append(secure);
        return sb.toString();
    }

    protected JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String templateId, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get article display {" + groupId + ", " + articleId + ", " + templateId + "}"));
            }
            return JournalArticleLocalServiceUtil.getArticleDisplay((long)groupId, (String)articleId, (String)templateId, (String)viewMode, (String)languageId, (int)page, (String)xmlRequest, (ThemeDisplay)themeDisplay);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get display for " + groupId + " " + articleId + " " + languageId));
            }
            return null;
        }
    }

    protected boolean isLifecycleRender(ThemeDisplay themeDisplay, String xmlRequest) {
        if (themeDisplay != null) {
            return themeDisplay.isLifecycleRender();
        }
        if (Validator.isNotNull((String)xmlRequest)) {
            Matcher matcher = lifecycleRenderPhasePatern.matcher(xmlRequest);
            return matcher.find();
        }
        return false;
    }
}

