/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.TransformerListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesTransformerListener
extends TransformerListener {
    private static final String _GLOBAL_PROPERTIES = "GLOBAL-PROPERTIES";
    private static Log _log = LogFactoryUtil.getLog(PropertiesTransformerListener.class);

    public String onXml(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        return s;
    }

    public String onScript(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        s = this.replace(s);
        return s;
    }

    public String onOutput(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        s = this.replace(s);
        return s;
    }

    protected String replace(String s) {
        Properties props;
        block5: {
            Map<String, String> tokens = this.getTokens();
            String templateId = tokens.get("template_id");
            if (templateId == null || templateId != null && templateId.equals(_GLOBAL_PROPERTIES)) {
                return s;
            }
            props = new Properties();
            try {
                HashMap<String, String> newTokens = new HashMap<String, String>();
                MapUtil.copy(tokens, newTokens);
                newTokens.put("template_id", _GLOBAL_PROPERTIES);
                long groupId = GetterUtil.getLong((String)tokens.get("group_id"));
                String script = JournalUtil.getTemplateScript(groupId, _GLOBAL_PROPERTIES, newTokens, this.getLanguageId());
                PropertiesUtil.load((Properties)props, (String)script);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Throwable)e);
            }
        }
        if (props.size() == 0) {
            return s;
        }
        String[] escapedKeys = new String[props.size()];
        String[] escapedValues = new String[props.size()];
        String[] keys = new String[props.size()];
        String[] values = new String[props.size()];
        String[] tempEscapedKeys = new String[props.size()];
        String[] tempEscapedValues = new String[props.size()];
        int counter = 0;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String escapedKey = "@@" + key + "@" + "@";
            String actualKey = "@" + key + "@";
            String tempEscapedKey = "[$TEMP_ESCAPED_AT_OPEN$]" + key + "[$_TEMP_ESCAPED_AT_CLOSE$]";
            escapedKeys[counter] = escapedKey;
            escapedValues[counter] = tempEscapedKey;
            keys[counter] = actualKey;
            values[counter] = value;
            tempEscapedKeys[counter] = tempEscapedKey;
            tempEscapedValues[counter] = actualKey;
            ++counter;
        }
        s = StringUtil.replace((String)s, (String[])escapedKeys, (String[])escapedValues);
        s = StringUtil.replace((String)s, (String[])keys, (String[])values);
        s = StringUtil.replace((String)s, (String[])tempEscapedKeys, (String[])tempEscapedValues);
        return s;
    }
}

