/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.PortletURL;

public class JournalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    public static final String PORTLET_ID = "15";
    protected static final String _FIELD_NAMESPACE = "web_content";
    private static Log _log = LogFactoryUtil.getLog(JournalIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String groupId = document.get("groupId");
        String articleId = document.get("entryClassPK");
        String version = document.get("version");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("articleId", articleId);
        portletURL.setParameter("version", version);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, article.getGroupId(), article.getArticleId());
        SearchEngineUtil.deleteDocument((long)article.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        long companyId = article.getCompanyId();
        long groupId = this.getParentGroupId(article.getGroupId());
        long scopeGroupId = article.getGroupId();
        long userId = article.getUserId();
        long resourcePrimKey = article.getResourcePrimKey();
        String articleId = article.getArticleId();
        double version = article.getVersion();
        String title = article.getTitle();
        String description = article.getDescription();
        String content = article.getContent();
        String type = article.getType();
        Date displayDate = article.getDisplayDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)JournalArticle.class.getName(), (long)resourcePrimKey);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)JournalArticle.class.getName(), (long)resourcePrimKey);
        ExpandoBridge expandoBridge = article.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, groupId, articleId);
        document.addModifiedDate(displayDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("title", title);
        document.addText("content", this.processContent((Document)document, content));
        document.addText("description", description);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("entryClassName", JournalArticle.class.getName());
        document.addKeyword("entryClassPK", articleId);
        document.addKeyword("rootEntryClassPK", resourcePrimKey);
        document.addKeyword("version", version);
        document.addKeyword("type", type);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        if (!article.isApproved() || !article.isIndexable()) {
            return;
        }
        Document document = this.getDocument(article);
        SearchEngineUtil.updateDocument((long)article.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK, (int)0);
        this.doReindex(article);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexArticles(companyId);
    }

    protected String encodeFieldName(String name) {
        return _FIELD_NAMESPACE.concat("/").concat(name);
    }

    protected String getIndexableContent(Document document, Element rootElement) throws Exception {
        StringBundler sb = new StringBundler();
        LinkedList queue = new LinkedList(rootElement.elements());
        Element element = null;
        while ((element = (Element)queue.poll()) != null) {
            String elType = element.attributeValue("type", "");
            String elIndexType = element.attributeValue("index-type", "");
            this.indexField(document, element, elType, elIndexType);
            if (elType.equals("text") || elType.equals("text_box") || elType.equals("text_area")) {
                for (Element dynamicContentElement : element.elements("dynamic-content")) {
                    String text = dynamicContentElement.getText();
                    sb.append(text);
                    sb.append(" ");
                }
            } else if (element.getName().equals("static-content")) {
                String text = element.getText();
                sb.append(text);
                sb.append(" ");
            }
            queue.addAll(element.elements());
        }
        return sb.toString();
    }

    protected String getIndexableContent(Document document, String content) {
        try {
            com.liferay.portal.kernel.xml.Document contentDocument = SAXReaderUtil.read((String)content);
            Element rootElement = contentDocument.getRootElement();
            return this.getIndexableContent(document, rootElement);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return content;
        }
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void indexField(Document document, Element element, String elType, String elIndexType) {
        if (Validator.isNull((String)elIndexType)) {
            return;
        }
        Element dynamicContentElement = element.element("dynamic-content");
        String fieldName = this.encodeFieldName(element.attributeValue("name", ""));
        Object[] value = new String[]{dynamicContentElement.getText()};
        if (elType.equals("multi-list")) {
            List optionElements = dynamicContentElement.elements();
            value = new String[optionElements.size()];
            int i = 0;
            while (i < optionElements.size()) {
                value[i] = ((Element)optionElements.get(i)).getText();
                ++i;
            }
        }
        if (elIndexType.equals("keyword")) {
            document.addKeyword(fieldName, (String[])value);
        } else if (elIndexType.equals("text")) {
            document.addText(fieldName, StringUtil.merge((Object[])value, (String)" "));
        }
    }

    protected String processContent(Document document, String content) {
        if (content != null && (content.indexOf("<dynamic-content") != -1 || content.indexOf("<static-content") != -1)) {
            content = this.getIndexableContent(document, content);
            content = StringUtil.replace((String)content, (String)"<![CDATA[", (String)"");
            content = StringUtil.replace((String)content, (String)"]]>", (String)"");
        }
        content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        content = StringUtil.replace((String)content, (String)"&lt;", (String)"<");
        content = StringUtil.replace((String)content, (String)"&gt;", (String)">");
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected void reindexArticles(long companyId) throws Exception {
        int count = JournalArticleLocalServiceUtil.getCompanyArticlesCount((long)companyId, (int)0);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexArticles(companyId, start, end);
            ++i;
        }
    }

    protected void reindexArticles(long companyId, int start, int end) throws Exception {
        List articles = JournalArticleLocalServiceUtil.getCompanyArticles((long)companyId, (int)0, (int)start, (int)end);
        if (articles.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (JournalArticle article : articles) {
            Document document = this.getDocument(article);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

