/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;

public class JournalStructurePermission {
    public static void check(PermissionChecker permissionChecker, JournalStructure structure, String actionId) throws PortalException {
        if (!JournalStructurePermission.contains(permissionChecker, structure, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long id, String actionId) throws PortalException, SystemException {
        if (!JournalStructurePermission.contains(permissionChecker, id, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String structureId, String actionId) throws PortalException, SystemException {
        if (!JournalStructurePermission.contains(permissionChecker, groupId, structureId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalStructure structure, String actionId) {
        if (permissionChecker.hasOwnerPermission(structure.getCompanyId(), JournalStructure.class.getName(), structure.getId(), structure.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(structure.getGroupId(), JournalStructure.class.getName(), structure.getId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long id, String actionId) throws PortalException, SystemException {
        JournalStructure structure = JournalStructureLocalServiceUtil.getStructure((long)id);
        return JournalStructurePermission.contains(permissionChecker, structure, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String structureId, String actionId) throws PortalException, SystemException {
        JournalStructure structure = JournalStructureLocalServiceUtil.getStructure((long)groupId, (String)structureId);
        return JournalStructurePermission.contains(permissionChecker, structure, actionId);
    }
}

