/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.DuplicateStructureIdException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.RequiredStructureException;
import com.liferay.portlet.journal.StructureDescriptionException;
import com.liferay.portlet.journal.StructureIdException;
import com.liferay.portlet.journal.StructureInheritanceException;
import com.liferay.portlet.journal.StructureNameException;
import com.liferay.portlet.journal.StructureXsdException;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.base.JournalStructureLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalStructureLocalServiceImpl
extends JournalStructureLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalStructureLocalServiceImpl.class);

    public JournalStructure addStructure(long userId, long groupId, String structureId, boolean autoStructureId, String parentStructureId, String name, String description, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        structureId = structureId.trim().toUpperCase();
        Date now = new Date();
        try {
            xsd = JournalUtil.formatXML(xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        if (autoStructureId) {
            structureId = String.valueOf(this.counterLocalService.increment());
        }
        this.validate(groupId, structureId, autoStructureId, parentStructureId, name, description, xsd);
        long id = this.counterLocalService.increment();
        JournalStructure structure = this.journalStructurePersistence.create(id);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setCreateDate(serviceContext.getCreateDate(now));
        structure.setModifiedDate(serviceContext.getModifiedDate(now));
        structure.setStructureId(structureId);
        structure.setParentStructureId(parentStructureId);
        structure.setName(name);
        structure.setDescription(description);
        structure.setXsd(xsd);
        this.journalStructurePersistence.update((BaseModel)structure, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        ExpandoBridge expandoBridge = structure.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return structure;
    }

    public void addStructureResources(long groupId, String structureId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        this.addStructureResources(structure, addCommunityPermissions, addGuestPermissions);
    }

    public void addStructureResources(JournalStructure structure, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), JournalStructure.class.getName(), structure.getId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addStructureResources(long groupId, String structureId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        this.addStructureResources(structure, communityPermissions, guestPermissions);
    }

    public void addStructureResources(JournalStructure structure, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), JournalStructure.class.getName(), structure.getId(), communityPermissions, guestPermissions);
    }

    public void checkNewLine(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        String xsd = structure.getXsd();
        if (xsd != null && xsd.indexOf("\\n") != -1) {
            xsd = StringUtil.replace((String)xsd, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            structure.setXsd(xsd);
            this.journalStructurePersistence.update((BaseModel)structure, false);
        }
    }

    public JournalStructure copyStructure(long userId, long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldStructureId = oldStructureId.trim().toUpperCase();
        newStructureId = newStructureId.trim().toUpperCase();
        Date now = new Date();
        JournalStructure oldStructure = this.journalStructurePersistence.findByG_S(groupId, oldStructureId);
        if (autoStructureId) {
            newStructureId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validateStructureId(newStructureId);
            JournalStructure newStructure = this.journalStructurePersistence.fetchByG_S(groupId, newStructureId);
            if (newStructure != null) {
                throw new DuplicateStructureIdException();
            }
        }
        long id = this.counterLocalService.increment();
        JournalStructure newStructure = this.journalStructurePersistence.create(id);
        newStructure.setGroupId(groupId);
        newStructure.setCompanyId(user.getCompanyId());
        newStructure.setUserId(user.getUserId());
        newStructure.setUserName(user.getFullName());
        newStructure.setCreateDate(now);
        newStructure.setModifiedDate(now);
        newStructure.setStructureId(newStructureId);
        newStructure.setName(oldStructure.getName());
        newStructure.setDescription(oldStructure.getDescription());
        newStructure.setXsd(oldStructure.getXsd());
        this.journalStructurePersistence.update((BaseModel)newStructure, false);
        this.addStructureResources(newStructure, true, true);
        return newStructure;
    }

    public void deleteStructure(long groupId, String structureId) throws PortalException, SystemException {
        structureId = structureId.trim().toUpperCase();
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        this.deleteStructure(structure);
    }

    public void deleteStructure(JournalStructure structure) throws PortalException, SystemException {
        if (this.journalArticlePersistence.countByG_S(structure.getGroupId(), structure.getStructureId()) > 0) {
            throw new RequiredStructureException();
        }
        if (this.journalStructurePersistence.countByG_P(structure.getGroupId(), structure.getStructureId()) > 0) {
            throw new RequiredStructureException();
        }
        if (this.journalTemplatePersistence.countByG_S(structure.getGroupId(), structure.getStructureId()) > 0) {
            throw new RequiredStructureException();
        }
        this.webDAVPropsLocalService.deleteWebDAVProps(JournalStructure.class.getName(), structure.getId());
        this.expandoValueLocalService.deleteValues(JournalStructure.class.getName(), structure.getId());
        this.resourceLocalService.deleteResource(structure.getCompanyId(), JournalStructure.class.getName(), 4, structure.getId());
        this.journalStructurePersistence.remove((BaseModel)structure);
    }

    public void deleteStructures(long groupId) throws PortalException, SystemException {
        for (JournalStructure structure : this.journalStructurePersistence.findByGroupId(groupId)) {
            this.deleteStructure(structure);
        }
    }

    public JournalStructure getStructure(long id) throws PortalException, SystemException {
        return this.journalStructurePersistence.findByPrimaryKey(id);
    }

    public JournalStructure getStructure(long groupId, String structureId) throws PortalException, SystemException {
        structureId = structureId.trim().toUpperCase();
        if (groupId == 0L) {
            _log.error((Object)("No group id was passed for " + structureId + ". Group id is " + "required since 4.2.0. Please update all custom code and " + "data that references structures without a group id."));
            List structures = this.journalStructurePersistence.findByStructureId(structureId);
            if (structures.size() == 0) {
                throw new NoSuchStructureException("No JournalStructure exists with the structure id " + structureId);
            }
            return (JournalStructure)structures.get(0);
        }
        return this.journalStructurePersistence.findByG_S(groupId, structureId);
    }

    public List<JournalStructure> getStructures() throws SystemException {
        return this.journalStructurePersistence.findAll();
    }

    public List<JournalStructure> getStructures(long groupId) throws SystemException {
        return this.journalStructurePersistence.findByGroupId(groupId);
    }

    public List<JournalStructure> getStructures(long groupId, int start, int end) throws SystemException {
        return this.journalStructurePersistence.findByGroupId(groupId, start, end);
    }

    public int getStructuresCount(long groupId) throws SystemException {
        return this.journalStructurePersistence.countByGroupId(groupId);
    }

    public List<JournalStructure> search(long companyId, long groupId, String keywords, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalStructureFinder.findByKeywords(companyId, groupId, keywords, start, end, obc);
    }

    public List<JournalStructure> search(long companyId, long groupId, String structureId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalStructureFinder.findByC_G_S_N_D(companyId, groupId, structureId, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long groupId, String keywords) throws SystemException {
        return this.journalStructureFinder.countByKeywords(companyId, groupId, keywords);
    }

    public int searchCount(long companyId, long groupId, String structureId, String name, String description, boolean andOperator) throws SystemException {
        return this.journalStructureFinder.countByC_G_S_N_D(companyId, groupId, structureId, name, description, andOperator);
    }

    public JournalStructure updateStructure(long groupId, String structureId, String parentStructureId, String name, String description, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        structureId = structureId.trim().toUpperCase();
        try {
            xsd = JournalUtil.formatXML(xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        this.validateParentStructureId(groupId, structureId, parentStructureId);
        this.validate(name, description, xsd);
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        structure.setModifiedDate(serviceContext.getModifiedDate(null));
        structure.setParentStructureId(parentStructureId);
        structure.setName(name);
        structure.setDescription(description);
        structure.setXsd(xsd);
        this.journalStructurePersistence.update((BaseModel)structure, false);
        ExpandoBridge expandoBridge = structure.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return structure;
    }

    protected void validate(long groupId, String structureId, boolean autoStructureId, String parentStructureId, String name, String description, String xsd) throws PortalException, SystemException {
        if (!autoStructureId) {
            this.validateStructureId(structureId);
            JournalStructure structure = this.journalStructurePersistence.fetchByG_S(groupId, structureId);
            if (structure != null) {
                throw new DuplicateStructureIdException();
            }
        }
        this.validateParentStructureId(groupId, structureId, parentStructureId);
        this.validate(name, description, xsd);
    }

    protected void validate(String name, String description, String xsd) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new StructureNameException();
        }
        if (Validator.isNull((String)description)) {
            throw new StructureDescriptionException();
        }
        if (Validator.isNull((String)xsd)) {
            throw new StructureXsdException();
        }
        try {
            Document doc = SAXReaderUtil.read((String)xsd);
            Element root = doc.getRootElement();
            List children = root.elements();
            if (children.size() == 0) {
                throw new StructureXsdException();
            }
            HashSet<String> elNames = new HashSet<String>();
            this.validate(children, elNames);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
    }

    protected void validate(List<Element> children, Set<String> elNames) throws PortalException {
        for (Element el : children) {
            if (el.getName().equals("meta-data")) continue;
            String elName = el.attributeValue("name", "");
            String elType = el.attributeValue("type", "");
            if (Validator.isNull((String)elName) || elName.startsWith("reserved")) {
                throw new StructureXsdException();
            }
            char[] c = elName.toCharArray();
            int i = 0;
            while (i < c.length) {
                if (!Validator.isChar((char)c[i]) && !Validator.isDigit((char)c[i]) && c[i] != '-' && c[i] != '_') {
                    throw new StructureXsdException();
                }
                ++i;
            }
            String completePath = elName;
            Element parent = el.getParent();
            while (!parent.isRootElement()) {
                completePath = String.valueOf(parent.attributeValue("name", "")) + "/" + completePath;
                parent = parent.getParent();
            }
            String elNameLowerCase = completePath.toLowerCase();
            if (elNames.contains(elNameLowerCase)) {
                throw new StructureXsdException();
            }
            elNames.add(elNameLowerCase);
            if (Validator.isNull((String)elType)) {
                throw new StructureXsdException();
            }
            this.validate(el.elements(), elNames);
        }
    }

    protected void validateParentStructureId(long groupId, String structureId, String parentStructureId) throws PortalException, SystemException {
        if (Validator.isNull((String)parentStructureId)) {
            return;
        }
        if (parentStructureId.equals(structureId)) {
            throw new StructureInheritanceException();
        }
        JournalStructure parentStructure = this.journalStructurePersistence.fetchByG_S(groupId, parentStructureId);
        while (parentStructure != null) {
            if (parentStructure != null && parentStructure.getStructureId().equals(structureId) || parentStructure.getParentStructureId().equals(structureId)) {
                throw new StructureInheritanceException();
            }
            parentStructure = this.journalStructurePersistence.fetchByG_S(groupId, parentStructure.getParentStructureId());
        }
    }

    protected void validateStructureId(String structureId) throws PortalException {
        if (Validator.isNull((String)structureId) || Validator.isNumber((String)structureId) || structureId.indexOf(32) != -1) {
            throw new StructureIdException();
        }
    }
}

