/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.persistence;

import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.model.impl.IGImageImpl;
import com.liferay.portlet.imagegallery.service.persistence.IGImageFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageFinderImpl
extends BasePersistenceImpl<IGImage>
implements IGImageFinder {
    public static String FIND_BY_ANY_IMAGE_ID = String.valueOf(IGImageFinder.class.getName()) + ".findByAnyImageId";
    public static String FIND_BY_NO_ASSETS = String.valueOf(IGImageFinder.class.getName()) + ".findByNoAssets";

    public IGImage fetchByAnyImageId(long imageId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ANY_IMAGE_ID);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("IGImage", IGImageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(imageId);
            qPos.add(imageId);
            qPos.add(imageId);
            qPos.add(imageId);
            List list = q.list();
            if (list.isEmpty()) {
                return null;
            }
            IGImage iGImage = (IGImage)list.get(0);
            return iGImage;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public IGImage findByAnyImageId(long imageId) throws NoSuchImageException, SystemException {
        IGImage image = this.fetchByAnyImageId(imageId);
        if (image == null) {
            throw new NoSuchImageException("No IGImage exists with the imageId " + imageId);
        }
        return image;
    }

    public List<IGImage> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("IGImage", IGImageImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

