/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoRow;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.base.ExpandoRowLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoRowLocalServiceImpl
extends ExpandoRowLocalServiceBaseImpl {
    public ExpandoRow addRow(long tableId, long classPK) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        long rowId = this.counterLocalService.increment();
        ExpandoRow row = this.expandoRowPersistence.create(rowId);
        row.setCompanyId(table.getCompanyId());
        row.setTableId(tableId);
        row.setClassPK(classPK);
        this.expandoRowPersistence.update((BaseModel)row, false);
        return row;
    }

    public void deleteRow(long rowId) throws PortalException, SystemException {
        this.expandoRowPersistence.remove(rowId);
        this.expandoValueLocalService.deleteRowValues(rowId);
    }

    public void deleteRow(long tableId, long classPK) throws PortalException, SystemException {
        ExpandoRow row = this.expandoRowPersistence.findByT_C(tableId, classPK);
        this.deleteRow(row.getRowId());
    }

    public void deleteRow(long companyId, long classNameId, String tableName, long classPK) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.deleteRow(table.getTableId(), classPK);
    }

    public void deleteRow(long companyId, String className, String tableName, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteRow(companyId, classNameId, tableName, classPK);
    }

    public List<ExpandoRow> getDefaultTableRows(long companyId, long classNameId, int start, int end) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "CUSTOM_FIELDS");
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoRowPersistence.findByTableId(table.getTableId(), start, end);
    }

    public List<ExpandoRow> getDefaultTableRows(long companyId, String className, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDefaultTableRows(companyId, classNameId, start, end);
    }

    public int getDefaultTableRowsCount(long companyId, long classNameId) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "CUSTOM_FIELDS");
        if (table == null) {
            return 0;
        }
        return this.expandoRowPersistence.countByTableId(table.getTableId());
    }

    public int getDefaultTableRowsCount(long companyId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDefaultTableRowsCount(companyId, classNameId);
    }

    public ExpandoRow getRow(long rowId) throws PortalException, SystemException {
        return this.expandoRowPersistence.findByPrimaryKey(rowId);
    }

    public ExpandoRow getRow(long tableId, long classPK) throws PortalException, SystemException {
        return this.expandoRowPersistence.findByT_C(tableId, classPK);
    }

    public ExpandoRow getRow(long companyId, long classNameId, String tableName, long classPK) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        return this.expandoRowPersistence.fetchByT_C(table.getTableId(), classPK);
    }

    public ExpandoRow getRow(long companyId, String className, String tableName, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRow(companyId, classNameId, tableName, classPK);
    }

    public List<ExpandoRow> getRows(long tableId, int start, int end) throws SystemException {
        return this.expandoRowPersistence.findByTableId(tableId, start, end);
    }

    public List<ExpandoRow> getRows(long companyId, long classNameId, String tableName, int start, int end) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoRowPersistence.findByTableId(table.getTableId(), start, end);
    }

    public List<ExpandoRow> getRows(long companyId, String className, String tableName, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRows(companyId, classNameId, tableName, start, end);
    }

    public List<ExpandoRow> getRows(String className, String tableName, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.getRows(companyId, className, tableName, start, end);
    }

    public int getRowsCount(long tableId) throws SystemException {
        return this.expandoRowPersistence.countByTableId(tableId);
    }

    public int getRowsCount(long companyId, long classNameId, String tableName) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoRowPersistence.countByTableId(table.getTableId());
    }

    public int getRowsCount(long companyId, String className, String tableName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRowsCount(companyId, classNameId, tableName);
    }

    public int getRowsCount(String className, String tableName) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.getRowsCount(companyId, className, tableName);
    }
}

