/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.LockException;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import com.liferay.portlet.documentlibrary.webdav.DLFileEntryResourceImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private static Log _log = LogFactoryUtil.getLog(DLWebDAVStorageImpl.class);

    public int copyCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
        long companyId = webDavRequest.getCompanyId();
        long parentFolderId = 0L;
        try {
            parentFolderId = this.getParentFolderId(companyId, destinationArray);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return 409;
        }
        try {
            DLFolder folder = (DLFolder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDavRequest.getLockUuid())) {
                status = 204;
            }
            if (depth == 0L) {
                DLFolderServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            } else {
                DLFolderServiceUtil.copyFolder((long)groupId, (long)folder.getFolderId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int copySimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        File file = null;
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long companyId = webDavRequest.getCompanyId();
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(companyId, destinationArray);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                if (file != null) {
                    file.delete();
                }
                return 409;
            }
            DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            long userId = webDavRequest.getUserId();
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String title = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = fileEntry.getDescription();
            String changeLog = "";
            String extraSettings = fileEntry.getExtraSettings();
            file = FileUtil.createTempFile((String)FileUtil.getExtension((String)fileEntry.getName()));
            InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)userId, (long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
            FileUtil.write((File)file, (InputStream)is);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDavRequest.getLockUuid())) {
                status = 204;
            }
            DLFileEntryServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)name, (String)title, (String)description, (String)changeLog, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            int n = status;
            return n;
        }
        catch (DuplicateFileException duplicateFileException) {
            return 412;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (LockException lockException) {
            return 423;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public int deleteResource(WebDAVRequest webDavRequest) throws WebDAVException {
        block7: {
            DLFileEntry fileEntry;
            block8: {
                Resource resource;
                block6: {
                    resource = this.getResource(webDavRequest);
                    if (resource != null) break block6;
                    return 404;
                }
                Object model = resource.getModel();
                if (model instanceof DLFolder) {
                    DLFolder folder = (DLFolder)model;
                    DLFolderServiceUtil.deleteFolder((long)folder.getFolderId());
                    break block7;
                }
                fileEntry = (DLFileEntry)model;
                if (!this.isLocked(fileEntry, webDavRequest.getLockUuid())) break block8;
                return 423;
            }
            try {
                DLFileEntryServiceUtil.deleteFileEntry((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
            }
            catch (PrincipalException principalException) {
                return 403;
            }
            catch (Exception e) {
                throw new WebDAVException((Throwable)e);
            }
        }
        return 204;
    }

    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            String[] pathArray = webDavRequest.getPathArray();
            long companyId = webDavRequest.getCompanyId();
            long parentFolderId = this.getParentFolderId(companyId, pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            if (Validator.isNull((String)name)) {
                String path = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            try {
                DLFolder folder = DLFolderServiceUtil.getFolder((long)webDavRequest.getGroupId(), (long)parentFolderId, (String)name);
                if (folder.getParentFolderId() != parentFolderId || webDavRequest.getGroupId() != folder.getGroupId()) {
                    throw new NoSuchFolderException();
                }
                return this.toResource(webDavRequest, folder, false);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                try {
                    String titleWithExtension = name;
                    DLFileEntry fileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)webDavRequest.getGroupId(), (long)parentFolderId, (String)titleWithExtension);
                    return this.toResource(webDavRequest, fileEntry, false);
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            long folderId = this.getFolderId(webDavRequest.getCompanyId(), webDavRequest.getPathArray());
            List<Resource> folders = this.getFolders(webDavRequest, folderId);
            List<Resource> fileEntries = this.getFileEntries(webDavRequest, folderId);
            ArrayList<Resource> resources = new ArrayList<Resource>(folders.size() + fileEntries.size());
            resources.addAll(folders);
            resources.addAll(fileEntries);
            return resources;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public boolean isSupportsClassTwo() {
        return true;
    }

    public Status lockResource(WebDAVRequest webDavRequest, String owner, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        Lock lock = null;
        int status = 200;
        try {
            if (resource == null) {
                String name;
                status = 201;
                String[] pathArray = webDavRequest.getPathArray();
                long companyId = webDavRequest.getCompanyId();
                long groupId = webDavRequest.getGroupId();
                long parentFolderId = this.getParentFolderId(companyId, pathArray);
                String title = name = WebDAVUtil.getResourceName((String[])pathArray);
                String description = "";
                String changeLog = "";
                String extraSettings = "";
                File file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                file.createNewFile();
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
                serviceContext.setAddGuestPermissions(true);
                DLFileEntry fileEntry = DLFileEntryServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)name, (String)title, (String)description, (String)changeLog, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
                resource = this.toResource(webDavRequest, fileEntry, false);
            }
            if (resource instanceof DLFileEntryResourceImpl) {
                DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
                lock = DLFileEntryServiceUtil.lockFileEntry((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName(), (String)owner, (long)timeout);
            } else {
                boolean inheritable = false;
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDavRequest.getHttpServletRequest());
                if (depth != 0L) {
                    inheritable = true;
                }
                DLFolder folder = (DLFolder)resource.getModel();
                lock = DLFolderServiceUtil.lockFolder((long)folder.getFolderId(), (String)owner, (boolean)inheritable, (long)timeout);
            }
        }
        catch (Exception e) {
            if (!(e instanceof DuplicateLockException)) {
                throw new WebDAVException((Throwable)e);
            }
            status = 423;
        }
        return new Status(lock, status);
    }

    public Status makeCollection(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            if (request.getContentLength() > 0) {
                return new Status(415);
            }
            Object[] pathArray = webDavRequest.getPathArray();
            long companyId = webDavRequest.getCompanyId();
            long groupId = webDavRequest.getGroupId();
            long parentFolderId = this.getParentFolderId(companyId, (String[])pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            DLFolderServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            String location = StringUtil.merge((Object[])pathArray, (String)"/");
            return new Status((Object)location, 201);
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return new Status(405);
        }
        catch (DuplicateFileException duplicateFileException) {
            return new Status(405);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return new Status(409);
        }
        catch (PrincipalException principalException) {
            return new Status(403);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            DLFolder folder = (DLFolder)resource.getModel();
            long companyId = webDavRequest.getCompanyId();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])destinationArray);
            long folderId = folder.getFolderId();
            long parentFolderId = this.getParentFolderId(companyId, destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDavRequest.getLockUuid())) {
                status = 204;
            }
            DLFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            return status;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveSimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        DLFileEntry fileEntry;
        String[] destinationArray;
        block12: {
            destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            fileEntry = (DLFileEntry)resource.getModel();
            if (!this.isLocked(fileEntry, webDavRequest.getLockUuid())) break block12;
            return 423;
        }
        try {
            long companyId = webDavRequest.getCompanyId();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])destinationArray);
            long userId = webDavRequest.getUserId();
            long parentFolderId = this.getParentFolderId(companyId, destinationArray);
            String name = fileEntry.getName();
            String sourceFileName = WebDAVUtil.getResourceName((String[])destinationArray);
            String title = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = fileEntry.getDescription();
            String changeLog = "";
            String extraSettings = fileEntry.getExtraSettings();
            byte[] bytes = null;
            String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAssetTagNames(assetTagNames);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDavRequest.getLockUuid())) {
                status = 204;
            }
            if (webDavRequest.isMac()) {
                try {
                    DLFileEntry destFileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)parentFolderId, (String)title);
                    InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)userId, (long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
                    bytes = FileUtil.getBytes((InputStream)is);
                    DLFileEntryServiceUtil.updateFileEntry((long)groupId, (long)parentFolderId, (String)destFileEntry.getName(), (String)destFileEntry.getTitle(), (String)destFileEntry.getTitle(), (String)destFileEntry.getDescription(), (String)changeLog, (boolean)false, (String)destFileEntry.getExtraSettings(), (byte[])bytes, (ServiceContext)serviceContext);
                    DLFileEntryServiceUtil.deleteFileEntry((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
                    return status;
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {}
            }
            DLFileEntryServiceUtil.updateFileEntry((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)name, (String)sourceFileName, (String)title, (String)description, (String)changeLog, (boolean)false, (String)extraSettings, (byte[])bytes, (ServiceContext)serviceContext);
            if (fileEntry.getFolderId() != parentFolderId) {
                fileEntry = DLFileEntryServiceUtil.moveFileEntry((long)groupId, (long)fileEntry.getFolderId(), (long)parentFolderId, (String)name, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (DuplicateFileException duplicateFileException) {
            return 412;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (LockException lockException) {
            return 423;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDavRequest) throws WebDAVException {
        File file = null;
        try {
            DLFileEntry fileEntry;
            ServiceContext serviceContext;
            String extraSettings;
            String changeLog;
            String description;
            String title;
            String name;
            long parentFolderId;
            long groupId;
            HttpServletRequest request;
            block18: {
                request = webDavRequest.getHttpServletRequest();
                String[] pathArray = webDavRequest.getPathArray();
                long companyId = webDavRequest.getCompanyId();
                groupId = webDavRequest.getGroupId();
                parentFolderId = this.getParentFolderId(companyId, pathArray);
                title = name = WebDAVUtil.getResourceName((String[])pathArray);
                description = "";
                changeLog = "";
                extraSettings = "";
                serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
                serviceContext.setAddGuestPermissions(true);
                if (PropsValues.DL_WEBDAV_SAVE_TO_SINGLE_VERSION) {
                    serviceContext.setWorkflowAction(2);
                }
                fileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)parentFolderId, (String)name);
                if (!this.isLocked(fileEntry, webDavRequest.getLockUuid())) break block18;
                return 423;
            }
            try {
                name = fileEntry.getName();
                description = fileEntry.getDescription();
                extraSettings = fileEntry.getExtraSettings();
                String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
                serviceContext.setAssetTagNames(assetTagNames);
                file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                FileUtil.write((File)file, (InputStream)request.getInputStream());
                DLFileEntryServiceUtil.updateFileEntry((long)groupId, (long)parentFolderId, (String)name, (String)title, (String)title, (String)description, (String)changeLog, (boolean)false, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                FileUtil.write((File)file, (InputStream)request.getInputStream());
                DLFileEntryServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)name, (String)title, (String)description, (String)changeLog, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            }
            return 201;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return 409;
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
            return 409;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public Lock refreshResourceLock(WebDAVRequest webDavRequest, String uuid, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        Lock lock = null;
        try {
            lock = resource instanceof DLFileEntryResourceImpl ? DLFileEntryServiceUtil.refreshFileEntryLock((String)uuid, (long)timeout) : DLFolderServiceUtil.refreshFolderLock((String)uuid, (long)timeout);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        return lock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unlockResource(WebDAVRequest webDavRequest, String token) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        try {
            if (!(resource instanceof DLFileEntryResourceImpl)) {
                DLFolder folder = (DLFolder)resource.getModel();
                DLFolderServiceUtil.unlockFolder((long)folder.getGroupId(), (long)folder.getParentFolderId(), (String)folder.getName(), (String)token);
                return true;
            }
            DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
            if (PropsValues.DL_WEBDAV_HOLD_LOCK) {
                return true;
            }
            if (PropsValues.DL_WEBDAV_SAVE_TO_SINGLE_VERSION) {
                this.publishFileEntry(fileEntry);
            }
            DLFileEntryServiceUtil.unlockFileEntry((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName(), (String)token);
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvalidLockException) {
                if (!_log.isWarnEnabled()) return false;
                _log.warn((Object)e.getMessage());
                return false;
            }
            if (!_log.isWarnEnabled()) return false;
            _log.warn((Object)"Unable to unlock file entry", (Throwable)e);
            return false;
        }
    }

    protected boolean deleteResource(long groupId, long parentFolderId, String name, String lockUuid) throws Exception {
        try {
            DLFolder folder = DLFolderServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
            DLFolderServiceUtil.deleteFolder((long)folder.getFolderId());
            return true;
        }
        catch (NoSuchFolderException noSuchFolderException) {
            try {
                DLFileEntry fileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)parentFolderId, (String)name);
                if (this.isLocked(fileEntry, lockUuid)) {
                    throw new LockException();
                }
                DLFileEntryServiceUtil.deleteFileEntryByTitle((long)groupId, (long)parentFolderId, (String)name);
                return true;
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                return false;
            }
        }
    }

    protected List<Resource> getFileEntries(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List fileEntries = DLFileEntryServiceUtil.getFileEntries((long)webDavRequest.getGroupId(), (long)parentFolderId);
        for (DLFileEntry fileEntry : fileEntries) {
            Resource resource = this.toResource(webDavRequest, fileEntry, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, false);
    }

    protected long getFolderId(long companyId, String[] pathArray, boolean parent) throws Exception {
        long folderId = 0L;
        if (pathArray.length <= 1) {
            return folderId;
        }
        long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])pathArray);
        int x = pathArray.length;
        if (parent) {
            --x;
        }
        int i = 2;
        while (i < x) {
            String name = pathArray[i];
            DLFolder folder = DLFolderServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
            if (groupId == folder.getGroupId()) {
                folderId = folder.getFolderId();
            }
            ++i;
        }
        return folderId;
    }

    protected List<Resource> getFolders(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDavRequest.getGroupId();
        List folders = DLFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
        for (DLFolder folder : folders) {
            Resource resource = this.toResource(webDavRequest, folder, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getParentFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, true);
    }

    protected boolean isLocked(DLFileEntry fileEntry, String lockUuid) throws Exception {
        long groupId = fileEntry.getGroupId();
        long parentFolderId = fileEntry.getFolderId();
        String fileName = fileEntry.getName();
        if (Validator.isNull((String)lockUuid)) {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)groupId, (long)parentFolderId, (String)fileName);
        }
        try {
            boolean verified = DLFileEntryServiceUtil.verifyFileEntryLock((long)groupId, (long)parentFolderId, (String)fileName, (String)lockUuid);
            return !verified;
        }
        catch (NoSuchLockException noSuchLockException) {
            return false;
        }
    }

    protected void publishFileEntry(DLFileEntry fileEntry) throws Exception {
        DLFileVersion latestFileVersion = DLFileVersionLocalServiceUtil.getLatestFileVersion((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
        if (latestFileVersion.getStatus() == 0) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(fileEntry.getGroupId()));
        serviceContext.setAddGuestPermissions(true);
        DLFileEntryLocalServiceUtil.updateFileEntry((long)latestFileVersion.getUserId(), (long)latestFileVersion.getGroupId(), (long)latestFileVersion.getFolderId(), (String)latestFileVersion.getName(), (String)fileEntry.getTitle(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), (String)latestFileVersion.getDescription(), (boolean)true, (String)fileEntry.getExtraSettings(), null, (long)0L, (ServiceContext)serviceContext);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, DLFileEntry fileEntry, boolean appendPath) {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = fileEntry.getTitle();
        }
        return new DLFileEntryResourceImpl(webDavRequest, fileEntry, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, DLFolder folder, boolean appendPath) {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreateDate(), folder.getModifiedDate());
        resource.setModel((Object)folder);
        resource.setClassName(DLFolder.class.getName());
        resource.setPrimaryKey(folder.getPrimaryKey());
        return resource;
    }
}

