/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FileEntryModifiedDateComparator;
import java.io.File;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryServiceImpl
extends DLFileEntryServiceBaseImpl {
    public DLFileEntry addFileEntry(long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.addFileEntry(this.getUserId(), groupId, folderId, name, title, description, changeLog, extraSettings, bytes, serviceContext);
    }

    public DLFileEntry addFileEntry(long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.addFileEntry(this.getUserId(), groupId, folderId, name, title, description, changeLog, extraSettings, file, serviceContext);
    }

    public void deleteFileEntry(long groupId, long folderId, String name) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), groupId, folderId, name, "DELETE");
        boolean hasLock = this.hasFileEntryLock(groupId, folderId, name);
        if (!hasLock) {
            this.lockFileEntry(groupId, folderId, name);
        }
        try {
            this.dlFileEntryLocalService.deleteFileEntry(groupId, folderId, name);
        }
        finally {
            this.unlockFileEntry(groupId, folderId, name);
        }
    }

    public void deleteFileEntry(long groupId, long folderId, String name, String version) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), groupId, folderId, name, "DELETE");
        boolean hasLock = this.hasFileEntryLock(groupId, folderId, name);
        if (!hasLock) {
            this.lockFileEntry(groupId, folderId, name);
        }
        try {
            this.dlFileEntryLocalService.deleteFileEntry(groupId, folderId, name, version);
        }
        finally {
            this.unlockFileEntry(groupId, folderId, name);
        }
    }

    public void deleteFileEntryByTitle(long groupId, long folderId, String titleWithExtension) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.getFileEntryByTitle(groupId, folderId, titleWithExtension);
        this.deleteFileEntry(groupId, folderId, fileEntry.getName());
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        return this.dlFileEntryPersistence.filterFindByG_F(groupId, folderId);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        return this.dlFileEntryPersistence.filterFindByG_F(groupId, folderId, start, end);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        return this.dlFileEntryPersistence.filterFindByG_F(groupId, folderId, start, end, obc);
    }

    public int getFileEntriesCount(long groupId, long folderId) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        return this.dlFileEntryPersistence.filterCountByG_F(groupId, folderId);
    }

    public DLFileEntry getFileEntry(long groupId, long folderId, String name) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), groupId, folderId, name, "VIEW");
        return this.dlFileEntryLocalService.getFileEntry(groupId, folderId, name);
    }

    public DLFileEntry getFileEntryByTitle(long groupId, long folderId, String titleWithExtension) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntryByTitle(groupId, folderId, titleWithExtension);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "VIEW");
        return fileEntry;
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "VIEW");
        return fileEntry;
    }

    public int getFoldersFileEntriesCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.dlFileEntryFinder.filterCountByG_F_S(groupId, folderIds, status);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int filesCount = this.dlFileEntryFinder.filterCountByG_F_S(groupId, folderIds.subList(start, end), status);
        folderIds.subList(start, end).clear();
        return filesCount += this.getFoldersFileEntriesCount(groupId, folderIds, status);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, userId, start, end, (OrderByComparator)new FileEntryModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        long[] folderIds = this.dlFolderService.getFolderIds(groupId, 0L);
        if (folderIds.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.filterFindByG_F(groupId, folderIds, start, end, obc);
        }
        return this.dlFileEntryPersistence.filterFindByG_U_F(groupId, userId, folderIds, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws SystemException {
        long[] folderIds = this.dlFolderService.getFolderIds(groupId, 0L);
        if (folderIds.length == 0) {
            return 0;
        }
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.filterCountByG_F(groupId, folderIds);
        }
        return this.dlFileEntryPersistence.filterCountByG_U_F(groupId, userId, folderIds);
    }

    public boolean hasFileEntryLock(long groupId, long folderId, String name) throws PortalException, SystemException {
        String lockId = DLUtil.getLockId((long)groupId, (long)folderId, (String)name);
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFileEntry.class.getName(), lockId);
        if (!hasLock && folderId != 0L) {
            hasLock = this.dlFolderService.hasInheritableLock(folderId);
        }
        return hasLock;
    }

    public Lock lockFileEntry(long groupId, long folderId, String name) throws PortalException, SystemException {
        return this.lockFileEntry(groupId, folderId, name, null, DLFileEntryImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFileEntry(long groupId, long folderId, String name, String owner, long expirationTime) throws PortalException, SystemException {
        if (expirationTime <= 0L || expirationTime > DLFileEntryImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFileEntryImpl.LOCK_EXPIRATION_TIME;
        }
        String lockId = DLUtil.getLockId((long)groupId, (long)folderId, (String)name);
        return this.lockLocalService.lock(this.getUser().getUserId(), DLFileEntry.class.getName(), lockId, owner, false, expirationTime);
    }

    public DLFileEntry moveFileEntry(long groupId, long folderId, long newFolderId, String name, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), groupId, folderId, name, "UPDATE");
        boolean hasLock = this.hasFileEntryLock(groupId, folderId, name);
        if (!hasLock) {
            this.lockFileEntry(groupId, folderId, name);
        }
        DLFileEntry fileEntry = null;
        try {
            fileEntry = this.dlFileEntryLocalService.moveFileEntry(this.getUserId(), groupId, folderId, newFolderId, name, serviceContext);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(groupId, folderId, name);
            }
        }
        return fileEntry;
    }

    public Lock refreshFileEntryLock(String lockUuid, long expirationTime) throws PortalException, SystemException {
        return this.lockLocalService.refresh(lockUuid, expirationTime);
    }

    public void unlockFileEntry(long groupId, long folderId, String name) throws SystemException {
        String lockId = DLUtil.getLockId((long)groupId, (long)folderId, (String)name);
        this.lockLocalService.unlock(DLFileEntry.class.getName(), lockId);
    }

    public void unlockFileEntry(long groupId, long folderId, String name, String lockUuid) throws PortalException, SystemException {
        String lockId;
        block4: {
            lockId = DLUtil.getLockId((long)groupId, (long)folderId, (String)name);
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFileEntry.class.getName(), lockId);
                    if (!lock.getUuid().equals(lockUuid)) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block4;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFileEntry.class.getName(), lockId);
    }

    public DLFileEntry updateFileEntry(long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), groupId, folderId, name, "UPDATE");
        boolean hasLock = this.hasFileEntryLock(groupId, folderId, name);
        if (!hasLock) {
            this.lockFileEntry(groupId, folderId, name);
        }
        DLFileEntry fileEntry = null;
        try {
            fileEntry = this.dlFileEntryLocalService.updateFileEntry(this.getUserId(), groupId, folderId, name, sourceFileName, title, description, changeLog, majorVersion, extraSettings, bytes, serviceContext);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(groupId, folderId, name);
            }
        }
        return fileEntry;
    }

    public DLFileEntry updateFileEntry(long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), groupId, folderId, name, "UPDATE");
        boolean hasLock = this.hasFileEntryLock(groupId, folderId, name);
        if (!hasLock) {
            this.lockFileEntry(groupId, folderId, name);
        }
        DLFileEntry fileEntry = null;
        try {
            fileEntry = this.dlFileEntryLocalService.updateFileEntry(this.getUserId(), groupId, folderId, name, sourceFileName, title, description, changeLog, majorVersion, extraSettings, file, serviceContext);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(groupId, folderId, name);
            }
        }
        return fileEntry;
    }

    public boolean verifyFileEntryLock(long groupId, long folderId, String name, String lockUuid) throws PortalException, SystemException {
        boolean verified = false;
        try {
            String lockId = DLUtil.getLockId((long)groupId, (long)folderId, (String)name);
            Lock lock = this.lockLocalService.getLock(DLFileEntry.class.getName(), lockId);
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (PortalException pe) {
            if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) {
                verified = this.dlFolderService.verifyInheritableLock(folderId, lockUuid);
            }
            throw pe;
        }
        return verified;
    }
}

