/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.lar.WordPressImporter;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryUtil;
import java.util.Calendar;
import java.util.List;
import javax.portlet.PortletPreferences;

public class BlogsPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "blogs";
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("blogs", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("blogs", "comments");
    private static PortletDataHandlerBoolean _entries = new PortletDataHandlerBoolean("blogs", "entries", true, true);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("blogs", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("blogs", "tags");
    private static PortletDataHandlerBoolean _wordpress = new PortletDataHandlerBoolean("blogs", "wordpress");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_entries, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_entries, _categories, _comments, _ratings, _tags, _wordpress};
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(BlogsPortletDataHandlerImpl.class, "deleteData")) {
            BlogsEntryLocalServiceUtil.deleteEntries((long)context.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.blogs", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("blogs-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        List entries = BlogsEntryUtil.findByGroupId((long)context.getScopeGroupId());
        for (BlogsEntry entry : entries) {
            this.exportEntry(context, rootElement, entry);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.blogs", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        for (Element entryElement : rootElement.elements("entry")) {
            String path = entryElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            BlogsEntry entry = (BlogsEntry)context.getZipEntryAsObject(path);
            this.importEntry(context, entry);
        }
        if (context.getBooleanParameter(_NAMESPACE, "wordpress")) {
            WordPressImporter.importData(context);
        }
        return null;
    }

    protected void exportEntry(PortletDataContext context, Element root, BlogsEntry entry) throws PortalException, SystemException {
        if (!context.isWithinDateRange(entry.getModifiedDate())) {
            return;
        }
        if (entry.getStatus() != 0) {
            return;
        }
        String path = this.getEntryPath(context, entry);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element entryElement = root.addElement("entry");
        entryElement.addAttribute("path", path);
        context.addPermissions(BlogsEntry.class, entry.getEntryId());
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            context.addAssetCategories(BlogsEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.addComments(BlogsEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.addRatingsEntries(BlogsEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            context.addAssetTags(BlogsEntry.class, entry.getEntryId());
        }
        entry.setUserUuid(entry.getUserUuid());
        context.addZipEntry(path, (Object)entry);
    }

    protected String getEntryPath(PortletDataContext context, BlogsEntry entry) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("33"));
        sb.append("/entries/");
        sb.append(entry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEntry(PortletDataContext context, BlogsEntry entry) throws Exception {
        long userId = context.getUserId(entry.getUserUuid());
        Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
        displayDateCal.setTime(entry.getDisplayDate());
        int displayDateMonth = displayDateCal.get(2);
        int displayDateDay = displayDateCal.get(5);
        int displayDateYear = displayDateCal.get(1);
        int displayDateHour = displayDateCal.get(10);
        int displayDateMinute = displayDateCal.get(12);
        if (displayDateCal.get(9) == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = entry.isAllowPingbacks();
        boolean allowTrackbacks = entry.isAllowTrackbacks();
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        int status = entry.getStatus();
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = context.getAssetCategoryIds(BlogsEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(BlogsEntry.class, entry.getEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(entry.getCreateDate());
        serviceContext.setModifiedDate(entry.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (status != 0) {
            serviceContext.setWorkflowAction(2);
        }
        BlogsEntry importedEntry = null;
        if (context.isDataStrategyMirror()) {
            BlogsEntry existingEntry = BlogsEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)context.getScopeGroupId());
            if (existingEntry == null) {
                serviceContext.setUuid(entry.getUuid());
                importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext);
            } else {
                importedEntry = BlogsEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (String)entry.getTitle(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext);
            }
        } else {
            importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext);
        }
        context.importPermissions(BlogsEntry.class, entry.getEntryId(), importedEntry.getEntryId());
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.importComments(BlogsEntry.class, entry.getEntryId(), importedEntry.getEntryId(), context.getScopeGroupId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(BlogsEntry.class, entry.getEntryId(), importedEntry.getEntryId());
        }
    }
}

