/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.util.RSSUtil;
import java.io.OutputStream;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class RSSAction
extends PortletAction {
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        resourceResponse.setContentType("text/xml; charset=UTF-8");
        OutputStream os = resourceResponse.getPortletOutputStream();
        try {
            os.write(this.getRSS((PortletRequest)resourceRequest));
        }
        finally {
            os.close();
        }
    }

    protected String getEntryURL(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        StringBundler sb = new StringBundler(5);
        sb.append(PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay));
        sb.append("/-/");
        sb.append("asset_publisher/");
        sb.append(portletDisplay.getInstanceId());
        sb.append("/");
        return sb.toString();
    }

    protected String getFeedURL(PortletRequest portletRequest) throws Exception {
        String feedURL = this.getEntryURL(portletRequest);
        return feedURL.concat("rss");
    }

    protected byte[] getRSS(PortletRequest portletRequest) throws Exception {
        PortletPreferences preferences = portletRequest.getPreferences();
        String selectionStyle = preferences.getValue("selection-style", "dynamic");
        if (!selectionStyle.equals("dynamic")) {
            return new byte[0];
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        long[] groupIds = AssetPublisherUtil.getGroupIds(preferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout());
        boolean excludeZeroViewCount = GetterUtil.getBoolean((String)preferences.getValue("exclude-zero-view-count", "0"));
        int rssDelta = GetterUtil.getInteger((String)preferences.getValue("rss-delta", "20"));
        String rssDisplayStyle = preferences.getValue("rss-display-style", "abstract");
        String rssFormat = preferences.getValue("rss-format", "atom10");
        String rssName = preferences.getValue("rss-name", null);
        String rssFormatType = RSSUtil.getFormatType((String)rssFormat);
        double rssFormatVersion = RSSUtil.getFormatVersion((String)rssFormat);
        AssetEntryQuery assetEntryQuery = AssetPublisherUtil.getAssetEntryQuery(preferences, themeDisplay.getScopeGroupId());
        assetEntryQuery.setEnd(rssDelta);
        assetEntryQuery.setExcludeZeroViewCount(excludeZeroViewCount);
        assetEntryQuery.setGroupIds(groupIds);
        assetEntryQuery.setStart(0);
        String rss = AssetEntryServiceUtil.getEntriesRSS((AssetEntryQuery)assetEntryQuery, (String)rssName, (String)rssFormatType, (double)rssFormatVersion, (String)rssDisplayStyle, (String)this.getFeedURL(portletRequest), (String)this.getEntryURL(portletRequest));
        return rss.getBytes("UTF-8");
    }
}

